/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.util;

import java.io.FileOutputStream;
import java.io.PrintWriter;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantInterfaceMethodref;
import org.apache.bcel.classfile.ConstantMethodref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.util.Class2HTML;

final class ConstantHTML
implements Constants {
    private String class_name;
    private String class_package;
    private ConstantPool constant_pool;
    private PrintWriter file;
    private String[] constant_ref;
    private Constant[] constants;
    private Method[] methods;

    ConstantHTML(String string, String string2, String string3, Method[] methodArray, ConstantPool constantPool) {
        this.class_name = string2;
        this.class_package = string3;
        this.constant_pool = constantPool;
        this.methods = methodArray;
        this.constants = constantPool.getConstantPool();
        this.file = new PrintWriter(new FileOutputStream(string + string2 + "_cp.html"));
        this.constant_ref = new String[this.constants.length];
        this.constant_ref[0] = "&lt;unknown&gt;";
        this.file.println("<HTML><BODY BGCOLOR=\"#C0C0C0\"><TABLE BORDER=0>");
        int n2 = 1;
        while (n2 < this.constants.length) {
            if (n2 % 2 == 0) {
                this.file.print("<TR BGCOLOR=\"#C0C0C0\"><TD>");
            } else {
                this.file.print("<TR BGCOLOR=\"#A0A0A0\"><TD>");
            }
            if (this.constants[n2] != null) {
                this.writeConstant(n2);
            }
            this.file.print("</TD></TR>\n");
            ++n2;
        }
        this.file.println("</TABLE></BODY></HTML>");
        this.file.close();
    }

    String referenceConstant(int n2) {
        return this.constant_ref[n2];
    }

    private void writeConstant(int n2) {
        byte by2 = this.constants[n2].getTag();
        this.file.println("<H4> <A NAME=cp" + n2 + ">" + n2 + "</A> " + Constants.CONSTANT_NAMES[by2] + "</H4>");
        switch (by2) {
            case 10: 
            case 11: {
                int n3;
                int n4;
                Object object;
                if (by2 == 10) {
                    object = (ConstantMethodref)this.constant_pool.getConstant(n2, (byte)10);
                    n4 = ((ConstantCP)object).getClassIndex();
                    n3 = ((ConstantCP)object).getNameAndTypeIndex();
                } else {
                    object = (ConstantInterfaceMethodref)this.constant_pool.getConstant(n2, (byte)11);
                    n4 = ((ConstantCP)object).getClassIndex();
                    n3 = ((ConstantCP)object).getNameAndTypeIndex();
                }
                object = this.constant_pool.constantToString(n3, (byte)12);
                String string = Class2HTML.toHTML((String)object);
                String string2 = this.constant_pool.constantToString(n4, (byte)7);
                String string3 = Utility.compactClassName(string2);
                string3 = Utility.compactClassName(string2);
                string3 = Utility.compactClassName(string3, this.class_package + ".", true);
                ConstantNameAndType constantNameAndType = (ConstantNameAndType)this.constant_pool.getConstant(n3, (byte)12);
                String string4 = this.constant_pool.constantToString(constantNameAndType.getSignatureIndex(), (byte)1);
                String[] stringArray = Utility.methodSignatureArgumentTypes(string4, false);
                String string5 = Utility.methodSignatureReturnType(string4, false);
                String string6 = Class2HTML.referenceType(string5);
                StringBuffer stringBuffer = new StringBuffer("(");
                int n5 = 0;
                while (n5 < stringArray.length) {
                    stringBuffer.append(Class2HTML.referenceType(stringArray[n5]));
                    if (n5 < stringArray.length - 1) {
                        stringBuffer.append(",&nbsp;");
                    }
                    ++n5;
                }
                stringBuffer.append(")");
                String string7 = stringBuffer.toString();
                String string8 = string2.equals(this.class_name) ? "<A HREF=\"" + this.class_name + "_code.html#method" + this.getMethodNumber((String)object + string4) + "\" TARGET=Code>" + string + "</A>" : "<A HREF=\"" + string2 + ".html" + "\" TARGET=_top>" + string3 + "</A>." + string;
                this.constant_ref[n2] = string6 + "&nbsp;<A HREF=\"" + this.class_name + "_cp.html#cp" + n4 + "\" TARGET=Constants>" + string3 + "</A>.<A HREF=\"" + this.class_name + "_cp.html#cp" + n2 + "\" TARGET=ConstantPool>" + string + "</A>&nbsp;" + string7;
                this.file.println("<P><TT>" + string6 + "&nbsp;" + string8 + string7 + "&nbsp;</TT>\n<UL>" + "<LI><A HREF=\"#cp" + n4 + "\">Class index(" + n4 + ")</A>\n" + "<LI><A HREF=\"#cp" + n3 + "\">NameAndType index(" + n3 + ")</A></UL>");
                break;
            }
            case 9: {
                ConstantFieldref constantFieldref = (ConstantFieldref)this.constant_pool.getConstant(n2, (byte)9);
                int n6 = constantFieldref.getClassIndex();
                int n7 = constantFieldref.getNameAndTypeIndex();
                String string = this.constant_pool.constantToString(n6, (byte)7);
                String string9 = Utility.compactClassName(string);
                string9 = Utility.compactClassName(string9, this.class_package + ".", true);
                String string10 = this.constant_pool.constantToString(n7, (byte)12);
                String string11 = string.equals(this.class_name) ? "<A HREF=\"" + string + "_methods.html#field" + string10 + "\" TARGET=Methods>" + string10 + "</A>" : "<A HREF=\"" + string + ".html\" TARGET=_top>" + string9 + "</A>." + string10 + "\n";
                this.constant_ref[n2] = "<A HREF=\"" + this.class_name + "_cp.html#cp" + n6 + "\" TARGET=Constants>" + string9 + "</A>.<A HREF=\"" + this.class_name + "_cp.html#cp" + n2 + "\" TARGET=ConstantPool>" + string10 + "</A>";
                this.file.println("<P><TT>" + string11 + "</TT><BR>\n" + "<UL>" + "<LI><A HREF=\"#cp" + n6 + "\">Class(" + n6 + ")</A><BR>\n" + "<LI><A HREF=\"#cp" + n7 + "\">NameAndType(" + n7 + ")</A></UL>");
                break;
            }
            case 7: {
                ConstantClass constantClass = (ConstantClass)this.constant_pool.getConstant(n2, (byte)7);
                int n8 = constantClass.getNameIndex();
                String string = this.constant_pool.constantToString(n2, by2);
                String string12 = Utility.compactClassName(string);
                string12 = Utility.compactClassName(string12, this.class_package + ".", true);
                String string13 = "<A HREF=\"" + string + ".html\" TARGET=_top>" + string12 + "</A>";
                this.constant_ref[n2] = "<A HREF=\"" + this.class_name + "_cp.html#cp" + n2 + "\" TARGET=ConstantPool>" + string12 + "</A>";
                this.file.println("<P><TT>" + string13 + "</TT><UL>" + "<LI><A HREF=\"#cp" + n8 + "\">Name index(" + n8 + ")</A></UL>\n");
                break;
            }
            case 8: {
                ConstantString constantString = (ConstantString)this.constant_pool.getConstant(n2, (byte)8);
                int n9 = constantString.getStringIndex();
                String string = Class2HTML.toHTML(this.constant_pool.constantToString(n2, by2));
                this.file.println("<P><TT>" + string + "</TT><UL>" + "<LI><A HREF=\"#cp" + n9 + "\">Name index(" + n9 + ")</A></UL>\n");
                break;
            }
            case 12: {
                ConstantNameAndType constantNameAndType = (ConstantNameAndType)this.constant_pool.getConstant(n2, (byte)12);
                int n10 = constantNameAndType.getNameIndex();
                int n11 = constantNameAndType.getSignatureIndex();
                this.file.println("<P><TT>" + Class2HTML.toHTML(this.constant_pool.constantToString(n2, by2)) + "</TT><UL>" + "<LI><A HREF=\"#cp" + n10 + "\">Name index(" + n10 + ")</A>\n" + "<LI><A HREF=\"#cp" + n11 + "\">Signature index(" + n11 + ")</A></UL>\n");
                break;
            }
            default: {
                this.file.println("<P><TT>" + Class2HTML.toHTML(this.constant_pool.constantToString(n2, by2)) + "</TT>\n");
            }
        }
    }

    private final int getMethodNumber(String string) {
        int n2 = 0;
        while (n2 < this.methods.length) {
            String string2 = this.methods[n2].getName() + this.methods[n2].getSignature();
            if (string2.equals(string)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }
}

