/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.util;

import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.BitSet;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantInterfaceMethodref;
import org.apache.bcel.classfile.ConstantMethodref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.util.ByteSequence;
import org.apache.bcel.util.Class2HTML;
import org.apache.bcel.util.ConstantHTML;

final class CodeHTML
implements Constants {
    private String class_name;
    private Method[] methods;
    private PrintWriter file;
    private BitSet goto_set;
    private ConstantPool constant_pool;
    private ConstantHTML constant_html;
    private static boolean wide = false;

    CodeHTML(String string, String string2, Method[] methodArray, ConstantPool constantPool, ConstantHTML constantHTML) {
        this.class_name = string2;
        this.methods = methodArray;
        this.constant_pool = constantPool;
        this.constant_html = constantHTML;
        this.file = new PrintWriter(new FileOutputStream(string + string2 + "_code.html"));
        this.file.println("<HTML><BODY BGCOLOR=\"#C0C0C0\">");
        int n2 = 0;
        while (n2 < methodArray.length) {
            this.writeMethod(methodArray[n2], n2);
            ++n2;
        }
        this.file.println("</BODY></HTML>");
        this.file.close();
    }

    private final String codeToHTML(ByteSequence byteSequence, int n2) {
        int n3;
        int n4;
        short s2 = (short)byteSequence.readUnsignedByte();
        int n5 = 0;
        int n6 = 0;
        StringBuffer stringBuffer = new StringBuffer("<TT>" + Constants.OPCODE_NAMES[s2] + "</TT></TD><TD>");
        if (s2 == 170 || s2 == 171) {
            n4 = byteSequence.getIndex() % 4;
            n6 = n4 == 0 ? 0 : 4 - n4;
            n3 = 0;
            while (n3 < n6) {
                byteSequence.readByte();
                ++n3;
            }
            n5 = byteSequence.readInt();
        }
        switch (s2) {
            case 170: {
                int n7 = byteSequence.readInt();
                int n8 = byteSequence.readInt();
                int n9 = byteSequence.getIndex() - 12 - n6 - 1;
                n5 += n9;
                stringBuffer.append("<TABLE BORDER=1><TR>");
                int[] nArray = new int[n8 - n7 + 1];
                n4 = 0;
                while (n4 < nArray.length) {
                    nArray[n4] = n9 + byteSequence.readInt();
                    stringBuffer.append("<TH>" + (n7 + n4) + "</TH>");
                    ++n4;
                }
                stringBuffer.append("<TH>default</TH></TR>\n<TR>");
                n3 = 0;
                while (n3 < nArray.length) {
                    stringBuffer.append("<TD><A HREF=\"#code" + n2 + "@" + nArray[n3] + "\">" + nArray[n3] + "</A></TD>");
                    ++n3;
                }
                stringBuffer.append("<TD><A HREF=\"#code" + n2 + "@" + n5 + "\">" + n5 + "</A></TD></TR>\n</TABLE>\n");
                break;
            }
            case 171: {
                int n10;
                int n11 = byteSequence.readInt();
                int n12 = byteSequence.getIndex() - 8 - n6 - 1;
                int[] nArray = new int[n11];
                n5 += n12;
                stringBuffer.append("<TABLE BORDER=1><TR>");
                int n13 = 0;
                while (n13 < n11) {
                    n10 = byteSequence.readInt();
                    nArray[n13] = n12 + byteSequence.readInt();
                    stringBuffer.append("<TH>" + n10 + "</TH>");
                    ++n13;
                }
                stringBuffer.append("<TH>default</TH></TR>\n<TR>");
                n10 = 0;
                while (n10 < n11) {
                    stringBuffer.append("<TD><A HREF=\"#code" + n2 + "@" + nArray[n10] + "\">" + nArray[n10] + "</A></TD>");
                    ++n10;
                }
                stringBuffer.append("<TD><A HREF=\"#code" + n2 + "@" + n5 + "\">" + n5 + "</A></TD></TR>\n</TABLE>\n");
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                int n14 = byteSequence.getIndex() + byteSequence.readShort() - 1;
                stringBuffer.append("<A HREF=\"#code" + n2 + "@" + n14 + "\">" + n14 + "</A>");
                break;
            }
            case 200: 
            case 201: {
                int n15 = byteSequence.getIndex() + byteSequence.readInt() - 1;
                stringBuffer.append("<A HREF=\"#code" + n2 + "@" + n15 + "\">" + n15 + "</A>");
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: {
                int n16;
                if (wide) {
                    n16 = byteSequence.readShort();
                    wide = false;
                } else {
                    n16 = byteSequence.readUnsignedByte();
                }
                stringBuffer.append("%" + n16);
                break;
            }
            case 196: {
                wide = true;
                stringBuffer.append("(wide)");
                break;
            }
            case 188: {
                stringBuffer.append("<FONT COLOR=\"#00FF00\">" + Constants.TYPE_NAMES[byteSequence.readByte()] + "</FONT>");
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                int n17 = byteSequence.readShort();
                ConstantFieldref constantFieldref = (ConstantFieldref)this.constant_pool.getConstant(n17, (byte)9);
                int n18 = constantFieldref.getClassIndex();
                String string = this.constant_pool.getConstantString(n18, (byte)7);
                string = Utility.compactClassName(string, false);
                n17 = constantFieldref.getNameAndTypeIndex();
                String string2 = this.constant_pool.constantToString(n17, (byte)12);
                if (string.equals(this.class_name)) {
                    stringBuffer.append("<A HREF=\"" + this.class_name + "_methods.html#field" + string2 + "\" TARGET=Methods>" + string2 + "</A>\n");
                    break;
                }
                stringBuffer.append(this.constant_html.referenceConstant(n18) + "." + string2);
                break;
            }
            case 187: 
            case 192: 
            case 193: {
                short s3 = byteSequence.readShort();
                stringBuffer.append(this.constant_html.referenceConstant(s3));
                break;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                int n19;
                String string;
                int n20;
                Object object;
                short s4 = byteSequence.readShort();
                if (s2 == 185) {
                    int n21 = byteSequence.readUnsignedByte();
                    int n22 = byteSequence.readUnsignedByte();
                    object = (ConstantInterfaceMethodref)this.constant_pool.getConstant(s4, (byte)11);
                    n20 = ((ConstantCP)object).getClassIndex();
                    string = this.constant_pool.constantToString((Constant)object);
                    n19 = ((ConstantCP)object).getNameAndTypeIndex();
                } else {
                    ConstantMethodref constantMethodref = (ConstantMethodref)this.constant_pool.getConstant(s4, (byte)10);
                    n20 = constantMethodref.getClassIndex();
                    string = this.constant_pool.constantToString(constantMethodref);
                    n19 = constantMethodref.getNameAndTypeIndex();
                }
                String string3 = Class2HTML.referenceClass(n20);
                string = Class2HTML.toHTML(this.constant_pool.constantToString(this.constant_pool.getConstant(n19, (byte)12)));
                ConstantNameAndType constantNameAndType = (ConstantNameAndType)this.constant_pool.getConstant(n19, (byte)12);
                String string4 = this.constant_pool.constantToString(constantNameAndType.getSignatureIndex(), (byte)1);
                String[] stringArray = Utility.methodSignatureArgumentTypes(string4, false);
                object = Utility.methodSignatureReturnType(string4, false);
                stringBuffer.append(string3 + ".<A HREF=\"" + this.class_name + "_cp.html#cp" + s4 + "\" TARGET=ConstantPool>" + string + "</A>" + "(");
                int n23 = 0;
                while (n23 < stringArray.length) {
                    stringBuffer.append(Class2HTML.referenceType(stringArray[n23]));
                    if (n23 < stringArray.length - 1) {
                        stringBuffer.append(", ");
                    }
                    ++n23;
                }
                stringBuffer.append("):" + Class2HTML.referenceType((String)object));
                break;
            }
            case 19: 
            case 20: {
                short s5 = byteSequence.readShort();
                stringBuffer.append("<A HREF=\"" + this.class_name + "_cp.html#cp" + s5 + "\" TARGET=\"ConstantPool\">" + Class2HTML.toHTML(this.constant_pool.constantToString(s5, this.constant_pool.getConstant(s5).getTag())) + "</a>");
                break;
            }
            case 18: {
                int n24 = byteSequence.readUnsignedByte();
                stringBuffer.append("<A HREF=\"" + this.class_name + "_cp.html#cp" + n24 + "\" TARGET=\"ConstantPool\">" + Class2HTML.toHTML(this.constant_pool.constantToString(n24, this.constant_pool.getConstant(n24).getTag())) + "</a>");
                break;
            }
            case 189: {
                short s6 = byteSequence.readShort();
                stringBuffer.append(this.constant_html.referenceConstant(s6));
                break;
            }
            case 197: {
                short s7 = byteSequence.readShort();
                byte by2 = byteSequence.readByte();
                stringBuffer.append(this.constant_html.referenceConstant(s7) + ":" + by2 + "-dimensional");
                break;
            }
            case 132: {
                short s8;
                int n25;
                if (wide) {
                    n25 = byteSequence.readShort();
                    s8 = byteSequence.readShort();
                    wide = false;
                } else {
                    n25 = byteSequence.readUnsignedByte();
                    s8 = byteSequence.readByte();
                }
                stringBuffer.append("%" + n25 + " " + s8);
                break;
            }
            default: {
                if (Constants.NO_OF_OPERANDS[s2] <= 0) break;
                int n26 = 0;
                while (n26 < Constants.TYPE_OF_OPERANDS[s2].length) {
                    switch (Constants.TYPE_OF_OPERANDS[s2][n26]) {
                        case 8: {
                            stringBuffer.append(byteSequence.readUnsignedByte());
                            break;
                        }
                        case 9: {
                            stringBuffer.append(byteSequence.readShort());
                            break;
                        }
                        case 10: {
                            stringBuffer.append(byteSequence.readInt());
                            break;
                        }
                        default: {
                            System.err.println("Unreachable default case reached!");
                            System.exit(-1);
                        }
                    }
                    stringBuffer.append("&nbsp;");
                    ++n26;
                }
                break block0;
            }
        }
        stringBuffer.append("</TD>");
        return stringBuffer.toString();
    }

    private final void findGotos(ByteSequence byteSequence, Method method, Code code) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        this.goto_set = new BitSet(byteSequence.available());
        if (code != null) {
            CodeException[] codeExceptionArray = code.getExceptionTable();
            n7 = codeExceptionArray.length;
            n6 = 0;
            while (n6 < n7) {
                this.goto_set.set(codeExceptionArray[n6].getStartPC());
                this.goto_set.set(codeExceptionArray[n6].getEndPC());
                this.goto_set.set(codeExceptionArray[n6].getHandlerPC());
                ++n6;
            }
            Attribute[] attributeArray = code.getAttributes();
            n5 = 0;
            while (n5 < attributeArray.length) {
                if (attributeArray[n5].getTag() == 5) {
                    LocalVariable[] localVariableArray = ((LocalVariableTable)attributeArray[n5]).getLocalVariableTable();
                    n4 = 0;
                    while (n4 < localVariableArray.length) {
                        n3 = localVariableArray[n4].getStartPC();
                        n2 = n3 + localVariableArray[n4].getLength();
                        this.goto_set.set(n3);
                        this.goto_set.set(n2);
                        ++n4;
                    }
                    break;
                }
                ++n5;
            }
        }
        int n8 = 0;
        while (byteSequence.available() > 0) {
            int n9 = byteSequence.readUnsignedByte();
            switch (n9) {
                case 170: 
                case 171: {
                    int n10;
                    n7 = byteSequence.getIndex() % 4;
                    n6 = n7 == 0 ? 0 : 4 - n7;
                    int n11 = 0;
                    while (n11 < n6) {
                        byteSequence.readByte();
                        ++n11;
                    }
                    int n12 = byteSequence.readInt();
                    if (n9 == 170) {
                        n4 = byteSequence.readInt();
                        n3 = byteSequence.readInt();
                        n5 = byteSequence.getIndex() - 12 - n6 - 1;
                        this.goto_set.set(n12 += n5);
                        n2 = 0;
                        while (n2 < n3 - n4 + 1) {
                            n10 = n5 + byteSequence.readInt();
                            this.goto_set.set(n10);
                            ++n2;
                        }
                    } else {
                        n4 = byteSequence.readInt();
                        n5 = byteSequence.getIndex() - 8 - n6 - 1;
                        this.goto_set.set(n12 += n5);
                        n3 = 0;
                        while (n3 < n4) {
                            n2 = byteSequence.readInt();
                            n10 = n5 + byteSequence.readInt();
                            this.goto_set.set(n10);
                            ++n3;
                        }
                    }
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 198: 
                case 199: {
                    int n10 = byteSequence.getIndex() + byteSequence.readShort() - 1;
                    this.goto_set.set(n10);
                    break;
                }
                case 200: 
                case 201: {
                    int n10 = byteSequence.getIndex() + byteSequence.readInt() - 1;
                    this.goto_set.set(n10);
                    break;
                }
                default: {
                    byteSequence.unreadByte();
                    this.codeToHTML(byteSequence, 0);
                }
            }
            ++n8;
        }
    }

    private void writeMethod(Method method, int n2) {
        int n3;
        String string = method.getSignature();
        String[] stringArray = Utility.methodSignatureArgumentTypes(string, false);
        String string2 = Utility.methodSignatureReturnType(string, false);
        String string3 = method.getName();
        String string4 = Class2HTML.toHTML(string3);
        String string5 = Utility.accessToString(method.getAccessFlags());
        string5 = Utility.replace(string5, " ", "&nbsp;");
        Attribute[] attributeArray = method.getAttributes();
        this.file.print("<P><B><FONT COLOR=\"#FF0000\">" + string5 + "</FONT>&nbsp;" + "<A NAME=method" + n2 + ">" + Class2HTML.referenceType(string2) + "</A>&nbsp<A HREF=\"" + this.class_name + "_methods.html#method" + n2 + "\" TARGET=Methods>" + string4 + "</A>(");
        int n4 = 0;
        while (n4 < stringArray.length) {
            this.file.print(Class2HTML.referenceType(stringArray[n4]));
            if (n4 < stringArray.length - 1) {
                this.file.print(",&nbsp;");
            }
            ++n4;
        }
        this.file.println(")</B></P>");
        Code code = null;
        byte[] byArray = null;
        if (attributeArray.length > 0) {
            this.file.print("<H4>Attributes</H4><UL>\n");
            int n5 = 0;
            while (n5 < attributeArray.length) {
                n3 = attributeArray[n5].getTag();
                if (n3 != -1) {
                    this.file.print("<LI><A HREF=\"" + this.class_name + "_attributes.html#method" + n2 + "@" + n5 + "\" TARGET=Attributes>" + Constants.ATTRIBUTE_NAMES[n3] + "</A></LI>\n");
                } else {
                    this.file.print("<LI>" + attributeArray[n5] + "</LI>");
                }
                if (n3 == 2) {
                    code = (Code)attributeArray[n5];
                    Attribute[] attributeArray2 = code.getAttributes();
                    byArray = code.getCode();
                    this.file.print("<UL>");
                    int n6 = 0;
                    while (n6 < attributeArray2.length) {
                        n3 = attributeArray2[n6].getTag();
                        this.file.print("<LI><A HREF=\"" + this.class_name + "_attributes.html#" + "method" + n2 + "@" + n5 + "@" + n6 + "\" TARGET=Attributes>" + Constants.ATTRIBUTE_NAMES[n3] + "</A></LI>\n");
                        ++n6;
                    }
                    this.file.print("</UL>");
                }
                ++n5;
            }
            this.file.println("</UL>");
        }
        if (byArray != null) {
            ByteSequence byteSequence = new ByteSequence(byArray);
            byteSequence.mark(byteSequence.available());
            this.findGotos(byteSequence, method, code);
            byteSequence.reset();
            this.file.println("<TABLE BORDER=0><TR><TH ALIGN=LEFT>Byte<BR>offset</TH><TH ALIGN=LEFT>Instruction</TH><TH ALIGN=LEFT>Argument</TH>");
            n3 = 0;
            while (byteSequence.available() > 0) {
                int n7 = byteSequence.getIndex();
                String string6 = this.codeToHTML(byteSequence, n2);
                String string7 = "";
                if (this.goto_set.get(n7)) {
                    string7 = "<A NAME=code" + n2 + "@" + n7 + "></A>";
                }
                String string8 = byteSequence.getIndex() == byArray.length ? "<A NAME=code" + n2 + "@" + byArray.length + ">" + n7 + "</A>" : "" + n7;
                this.file.println("<TR VALIGN=TOP><TD>" + string8 + "</TD><TD>" + string7 + string6 + "</TR>");
                ++n3;
            }
            this.file.println("<TR><TD> </A></TD></TR>");
            this.file.println("</TABLE>");
        }
    }
}

