/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassPath {
    private PathEntry[] paths;

    public ClassPath(String string) {
        ArrayList<PathEntry> arrayList = new ArrayList<PathEntry>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, System.getProperty("path.separator"));
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("")) continue;
            File file = new File(string2);
            try {
                if (!file.exists()) continue;
                if (file.isDirectory()) {
                    arrayList.add(new Dir(string2));
                    continue;
                }
                arrayList.add(new Zip(new ZipFile(file)));
            }
            catch (IOException iOException) {
                System.err.println("CLASSPATH component " + file + ": " + iOException);
            }
        }
        this.paths = new PathEntry[arrayList.size()];
        arrayList.toArray(this.paths);
    }

    public ClassPath() {
        this(ClassPath.getClassPath());
    }

    private static final void getPathComponents(String string, ArrayList arrayList) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                File file = new File(string2);
                if (!file.exists()) continue;
                arrayList.add(string2);
            }
        }
    }

    public static final String getClassPath() {
        String[] stringArray;
        Comparable<StringBuffer> comparable;
        String string = System.getProperty("java.class.path");
        String string2 = System.getProperty("sun.boot.class.path");
        String string3 = System.getProperty("java.ext.dirs");
        ArrayList<String> arrayList = new ArrayList<String>();
        ClassPath.getPathComponents(string, arrayList);
        ClassPath.getPathComponents(string2, arrayList);
        ArrayList arrayList2 = new ArrayList();
        ClassPath.getPathComponents(string3, arrayList2);
        Iterator iterator = ((AbstractList)arrayList2).iterator();
        while (iterator.hasNext()) {
            comparable = new File((String)iterator.next());
            stringArray = ((File)comparable).list(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return (string = string.toLowerCase()).endsWith(".zip") || string.endsWith(".jar");
                }
            });
            if (stringArray == null) continue;
            int n2 = 0;
            while (n2 < stringArray.length) {
                arrayList.add(string3 + File.separatorChar + stringArray[n2]);
                ++n2;
            }
        }
        comparable = new StringBuffer();
        stringArray = ((AbstractList)arrayList).iterator();
        while (stringArray.hasNext()) {
            ((StringBuffer)comparable).append((String)stringArray.next());
            if (!stringArray.hasNext()) continue;
            ((StringBuffer)comparable).append(File.pathSeparatorChar);
        }
        return ((StringBuffer)comparable).toString();
    }

    public InputStream getInputStream(String string) {
        return this.getInputStream(string, ".class");
    }

    public InputStream getInputStream(String string, String string2) {
        InputStream inputStream = null;
        try {
            inputStream = this.getClass().getClassLoader().getResourceAsStream(string + string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (inputStream != null) {
            return inputStream;
        }
        return this.getClassFile(string, string2).getInputStream();
    }

    public ClassFile getClassFile(String string, String string2) {
        int n2 = 0;
        while (n2 < this.paths.length) {
            ClassFile classFile = this.paths[n2].getClassFile(string, string2);
            if (classFile != null) {
                return classFile;
            }
            ++n2;
        }
        throw new IOException("Couldn't find: " + string + string2);
    }

    public ClassFile getClassFile(String string) {
        return this.getClassFile(string, ".class");
    }

    public byte[] getBytes(String string, String string2) {
        InputStream inputStream = this.getInputStream(string, string2);
        if (inputStream == null) {
            throw new IOException("Couldn't find: " + string + string2);
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] byArray = new byte[inputStream.available()];
        dataInputStream.readFully(byArray);
        dataInputStream.close();
        inputStream.close();
        return byArray;
    }

    public byte[] getBytes(String string) {
        return this.getBytes(string, ".class");
    }

    public String getPath(String string) {
        int n2 = string.lastIndexOf(46);
        String string2 = "";
        if (n2 > 0) {
            string2 = string.substring(n2);
            string = string.substring(0, n2);
        }
        return this.getPath(string, string2);
    }

    public String getPath(String string, String string2) {
        return this.getClassFile(string, string2).getPath();
    }

    private static class Zip
    extends PathEntry {
        private ZipFile zip;

        Zip(ZipFile zipFile) {
            super(null);
            this.zip = zipFile;
        }

        ClassFile getClassFile(String string, String string2) {
            ZipEntry zipEntry = this.zip.getEntry(string.replace('.', '/') + string2);
            return zipEntry != null ? new ClassFile(this, zipEntry){
                private final ZipEntry val$entry;
                private final Zip this$0;
                {
                    this.this$0 = zip;
                    this.val$entry = zipEntry;
                }

                public InputStream getInputStream() {
                    return Zip.access$100(this.this$0).getInputStream(this.val$entry);
                }

                public String getPath() {
                    return this.val$entry.toString();
                }

                public long getTime() {
                    return this.val$entry.getTime();
                }

                public long getSize() {
                    return this.val$entry.getSize();
                }
            } : null;
        }

        static ZipFile access$100(Zip zip) {
            return zip.zip;
        }
    }

    private static class Dir
    extends PathEntry {
        private String dir;

        Dir(String string) {
            super(null);
            this.dir = string;
        }

        ClassFile getClassFile(String string, String string2) {
            File file = new File(this.dir + File.separatorChar + string.replace('.', File.separatorChar) + string2);
            return file.exists() ? new ClassFile(this, file){
                private final File val$file;
                private final Dir this$0;
                {
                    this.this$0 = dir;
                    this.val$file = file;
                }

                public InputStream getInputStream() {
                    return new FileInputStream(this.val$file);
                }

                public String getPath() {
                    try {
                        return this.val$file.getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                }

                public long getTime() {
                    return this.val$file.lastModified();
                }

                public long getSize() {
                    return this.val$file.length();
                }
            } : null;
        }

        public String toString() {
            return this.dir;
        }
    }

    public static abstract class ClassFile {
        public abstract InputStream getInputStream();

        public abstract String getPath();

        public abstract long getTime();

        public abstract long getSize();
    }

    private static abstract class PathEntry {
        private PathEntry() {
        }

        abstract ClassFile getClassFile(String var1, String var2);

        PathEntry(1 var1_1) {
            this();
        }
    }
}

