/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.util.AttributeHTML;
import org.apache.bcel.util.CodeHTML;
import org.apache.bcel.util.ConstantHTML;
import org.apache.bcel.util.MethodHTML;

public class Class2HTML
implements Constants {
    private JavaClass java_class;
    private String dir;
    private static String class_package;
    private static String class_name;
    private static ConstantPool constant_pool;

    public Class2HTML(JavaClass javaClass, String string) {
        Method[] methodArray = javaClass.getMethods();
        this.java_class = javaClass;
        this.dir = string;
        class_name = javaClass.getClassName();
        constant_pool = javaClass.getConstantPool();
        int n2 = class_name.lastIndexOf(46);
        class_package = n2 > -1 ? class_name.substring(0, n2) : "";
        ConstantHTML constantHTML = new ConstantHTML(string, class_name, class_package, methodArray, constant_pool);
        AttributeHTML attributeHTML = new AttributeHTML(string, class_name, constant_pool, constantHTML);
        MethodHTML methodHTML = new MethodHTML(string, class_name, methodArray, javaClass.getFields(), constantHTML, attributeHTML);
        this.writeMainHTML(attributeHTML);
        new CodeHTML(string, class_name, methodArray, constant_pool, constantHTML);
        attributeHTML.close();
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        int n2 = 0;
        ClassParser classParser = null;
        JavaClass javaClass = null;
        String string = null;
        char c2 = System.getProperty("file.separator").toCharArray()[0];
        String string2 = "." + c2;
        try {
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (stringArray[n3].charAt(0) == '-') {
                    if (stringArray[n3].equals("-d")) {
                        if (!(string2 = stringArray[++n3]).endsWith("" + c2)) {
                            string2 = string2 + c2;
                        }
                        new File(string2).mkdirs();
                    } else if (stringArray[n3].equals("-zip")) {
                        string = stringArray[++n3];
                    } else {
                        System.out.println("Unknown option " + stringArray[n3]);
                    }
                } else {
                    stringArray2[n2++] = stringArray[n3];
                }
                ++n3;
            }
            if (n2 == 0) {
                System.err.println("Class2HTML: No input files specified.");
            } else {
                int n4 = 0;
                while (n4 < n2) {
                    System.out.print("Processing " + stringArray2[n4] + "...");
                    classParser = string == null ? new ClassParser(stringArray2[n4]) : new ClassParser(string, stringArray2[n4]);
                    javaClass = classParser.parse();
                    new Class2HTML(javaClass, string2);
                    System.out.println("Done.");
                    ++n4;
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace(System.out);
        }
    }

    static String referenceClass(int n2) {
        String string = constant_pool.getConstantString(n2, (byte)7);
        string = Utility.compactClassName(string);
        string = Utility.compactClassName(string, class_package + ".", true);
        return "<A HREF=\"" + class_name + "_cp.html#cp" + n2 + "\" TARGET=ConstantPool>" + string + "</A>";
    }

    static final String referenceType(String string) {
        String string2 = Utility.compactClassName(string);
        string2 = Utility.compactClassName(string2, class_package + ".", true);
        int n2 = string.indexOf(91);
        if (n2 > -1) {
            string = string.substring(0, n2);
        }
        if (string.equals("int") || string.equals("short") || string.equals("boolean") || string.equals("void") || string.equals("char") || string.equals("byte") || string.equals("long") || string.equals("double") || string.equals("float")) {
            return "<FONT COLOR=\"#00FF00\">" + string + "</FONT>";
        }
        return "<A HREF=\"" + string + ".html\" TARGET=_top>" + string2 + "</A>";
    }

    static String toHTML(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n2 = 0;
            while (n2 < string.length()) {
                char c2 = string.charAt(n2);
                switch (c2) {
                    case '<': {
                        stringBuffer.append("&lt;");
                        break;
                    }
                    case '>': {
                        stringBuffer.append("&gt;");
                        break;
                    }
                    case '\n': {
                        stringBuffer.append("\\n");
                        break;
                    }
                    case '\r': {
                        stringBuffer.append("\\r");
                        break;
                    }
                    default: {
                        stringBuffer.append(c2);
                    }
                }
                ++n2;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    private void writeMainHTML(AttributeHTML attributeHTML) {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(this.dir + class_name + ".html"));
        Attribute[] attributeArray = this.java_class.getAttributes();
        printWriter.println("<HTML>\n<HEAD><TITLE>Documentation for " + class_name + "</TITLE>" + "</HEAD>\n" + "<FRAMESET BORDER=1 cols=\"30%,*\">\n" + "<FRAMESET BORDER=1 rows=\"80%,*\">\n" + "<FRAME NAME=\"ConstantPool\" SRC=\"" + class_name + "_cp.html" + "\"\n MARGINWIDTH=\"0\" " + "MARGINHEIGHT=\"0\" FRAMEBORDER=\"1\" SCROLLING=\"AUTO\">\n" + "<FRAME NAME=\"Attributes\" SRC=\"" + class_name + "_attributes.html" + "\"\n MARGINWIDTH=\"0\" " + "MARGINHEIGHT=\"0\" FRAMEBORDER=\"1\" SCROLLING=\"AUTO\">\n" + "</FRAMESET>\n" + "<FRAMESET BORDER=1 rows=\"80%,*\">\n" + "<FRAME NAME=\"Code\" SRC=\"" + class_name + "_code.html\"\n MARGINWIDTH=0 " + "MARGINHEIGHT=0 FRAMEBORDER=1 SCROLLING=\"AUTO\">\n" + "<FRAME NAME=\"Methods\" SRC=\"" + class_name + "_methods.html\"\n MARGINWIDTH=0 " + "MARGINHEIGHT=0 FRAMEBORDER=1 SCROLLING=\"AUTO\">\n" + "</FRAMESET></FRAMESET></HTML>");
        printWriter.close();
        int n2 = 0;
        while (n2 < attributeArray.length) {
            attributeHTML.writeAttribute(attributeArray[n2], "class" + n2);
            ++n2;
        }
    }
}

