/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.util;

import java.io.FileOutputStream;
import java.io.PrintWriter;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.ConstantValue;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.InnerClass;
import org.apache.bcel.classfile.InnerClasses;
import org.apache.bcel.classfile.LineNumber;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.SourceFile;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.util.Class2HTML;
import org.apache.bcel.util.ConstantHTML;

final class AttributeHTML
implements Constants {
    private String class_name;
    private PrintWriter file;
    private int attr_count = 0;
    private ConstantHTML constant_html;
    private ConstantPool constant_pool;

    AttributeHTML(String string, String string2, ConstantPool constantPool, ConstantHTML constantHTML) {
        this.class_name = string2;
        this.constant_pool = constantPool;
        this.constant_html = constantHTML;
        this.file = new PrintWriter(new FileOutputStream(string + string2 + "_attributes.html"));
        this.file.println("<HTML><BODY BGCOLOR=\"#C0C0C0\"><TABLE BORDER=0>");
    }

    private final String codeLink(int n2, int n3) {
        return "<A HREF=\"" + this.class_name + "_code.html#code" + n3 + "@" + n2 + "\" TARGET=Code>" + n2 + "</A>";
    }

    final void close() {
        this.file.println("</TABLE></BODY></HTML>");
        this.file.close();
    }

    final void writeAttribute(Attribute attribute, String string) {
        this.writeAttribute(attribute, string, 0);
    }

    final void writeAttribute(Attribute attribute, String string, int n2) {
        byte by2 = attribute.getTag();
        if (by2 == -1) {
            return;
        }
        ++this.attr_count;
        if (this.attr_count % 2 == 0) {
            this.file.print("<TR BGCOLOR=\"#C0C0C0\"><TD>");
        } else {
            this.file.print("<TR BGCOLOR=\"#A0A0A0\"><TD>");
        }
        this.file.println("<H4><A NAME=\"" + string + "\">" + this.attr_count + " " + Constants.ATTRIBUTE_NAMES[by2] + "</A></H4>");
        switch (by2) {
            case 2: {
                Code code = (Code)attribute;
                Attribute[] attributeArray = code.getAttributes();
                this.file.print("<UL><LI>Maximum stack size = " + code.getMaxStack() + "</LI>\n<LI>Number of local variables = " + code.getMaxLocals() + "</LI>\n<LI><A HREF=\"" + this.class_name + "_code.html#method" + n2 + "\" TARGET=Code>Byte code</A></LI></UL>\n");
                CodeException[] codeExceptionArray = code.getExceptionTable();
                int n3 = codeExceptionArray.length;
                if (n3 <= 0) break;
                this.file.print("<P><B>Exceptions handled</B><UL>");
                int n4 = 0;
                while (n4 < n3) {
                    int n5 = codeExceptionArray[n4].getCatchType();
                    this.file.print("<LI>");
                    if (n5 != 0) {
                        this.file.print(this.constant_html.referenceConstant(n5));
                    } else {
                        this.file.print("Any Exception");
                    }
                    this.file.print("<BR>(Ranging from lines " + this.codeLink(codeExceptionArray[n4].getStartPC(), n2) + " to " + this.codeLink(codeExceptionArray[n4].getEndPC(), n2) + ", handled at line " + this.codeLink(codeExceptionArray[n4].getHandlerPC(), n2) + ")</LI>");
                    ++n4;
                }
                this.file.print("</UL>");
                break;
            }
            case 1: {
                int n6 = ((ConstantValue)attribute).getConstantValueIndex();
                this.file.print("<UL><LI><A HREF=\"" + this.class_name + "_cp.html#cp" + n6 + "\" TARGET=\"ConstantPool\">Constant value index(" + n6 + ")</A></UL>\n");
                break;
            }
            case 0: {
                int n7 = ((SourceFile)attribute).getSourceFileIndex();
                this.file.print("<UL><LI><A HREF=\"" + this.class_name + "_cp.html#cp" + n7 + "\" TARGET=\"ConstantPool\">Source file index(" + n7 + ")</A></UL>\n");
                break;
            }
            case 3: {
                int[] nArray = ((ExceptionTable)attribute).getExceptionIndexTable();
                this.file.print("<UL>");
                int n8 = 0;
                while (n8 < nArray.length) {
                    this.file.print("<LI><A HREF=\"" + this.class_name + "_cp.html#cp" + nArray[n8] + "\" TARGET=\"ConstantPool\">Exception class index(" + nArray[n8] + ")</A>\n");
                    ++n8;
                }
                this.file.print("</UL>\n");
                break;
            }
            case 4: {
                LineNumber[] lineNumberArray = ((LineNumberTable)attribute).getLineNumberTable();
                this.file.print("<P>");
                int n9 = 0;
                while (n9 < lineNumberArray.length) {
                    this.file.print("(" + lineNumberArray[n9].getStartPC() + ",&nbsp;" + lineNumberArray[n9].getLineNumber() + ")");
                    if (n9 < lineNumberArray.length - 1) {
                        this.file.print(", ");
                    }
                    ++n9;
                }
                break;
            }
            case 5: {
                LocalVariable[] localVariableArray = ((LocalVariableTable)attribute).getLocalVariableTable();
                this.file.print("<UL>");
                int n10 = 0;
                while (n10 < localVariableArray.length) {
                    int n11 = localVariableArray[n10].getSignatureIndex();
                    String string2 = ((ConstantUtf8)this.constant_pool.getConstant(n11, (byte)1)).getBytes();
                    string2 = Utility.signatureToString(string2, false);
                    int n12 = localVariableArray[n10].getStartPC();
                    int n13 = n12 + localVariableArray[n10].getLength();
                    this.file.println("<LI>" + Class2HTML.referenceType(string2) + "&nbsp;<B>" + localVariableArray[n10].getName() + "</B> in slot %" + localVariableArray[n10].getIndex() + "<BR>Valid from lines " + "<A HREF=\"" + this.class_name + "_code.html#code" + n2 + "@" + n12 + "\" TARGET=Code>" + n12 + "</A> to " + "<A HREF=\"" + this.class_name + "_code.html#code" + n2 + "@" + n13 + "\" TARGET=Code>" + n13 + "</A></LI>");
                    ++n10;
                }
                this.file.print("</UL>\n");
                break;
            }
            case 6: {
                InnerClass[] innerClassArray = ((InnerClasses)attribute).getInnerClasses();
                this.file.print("<UL>");
                int n14 = 0;
                while (n14 < innerClassArray.length) {
                    int n15 = innerClassArray[n14].getInnerNameIndex();
                    String string3 = n15 > 0 ? ((ConstantUtf8)this.constant_pool.getConstant(n15, (byte)1)).getBytes() : "&lt;anonymous&gt;";
                    String string4 = Utility.accessToString(innerClassArray[n14].getInnerAccessFlags());
                    this.file.print("<LI><FONT COLOR=\"#FF0000\">" + string4 + "</FONT> " + this.constant_html.referenceConstant(innerClassArray[n14].getInnerClassIndex()) + " in&nbsp;class " + this.constant_html.referenceConstant(innerClassArray[n14].getOuterClassIndex()) + " named " + string3 + "</LI>\n");
                    ++n14;
                }
                this.file.print("</UL>\n");
                break;
            }
            default: {
                this.file.print("<P>" + attribute.toString());
            }
        }
        this.file.println("</TD></TR>");
        this.file.flush();
    }
}

