/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.DataOutputStream;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGenException;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.StackProducer;
import org.apache.bcel.generic.VariableLengthInstruction;
import org.apache.bcel.util.ByteSequence;

public abstract class Select
extends BranchInstruction
implements StackProducer,
VariableLengthInstruction {
    protected int[] match;
    protected int[] indices;
    protected InstructionHandle[] targets;
    protected int fixed_length;
    protected int match_length;
    protected int padding = 0;

    Select() {
    }

    Select(short s2, int[] nArray, InstructionHandle[] instructionHandleArray, InstructionHandle instructionHandle) {
        super(s2, instructionHandle);
        this.targets = instructionHandleArray;
        int n2 = 0;
        while (n2 < instructionHandleArray.length) {
            BranchInstruction.notifyTarget(null, instructionHandleArray[n2], this);
            ++n2;
        }
        this.match = nArray;
        this.match_length = nArray.length;
        if (this.match_length != instructionHandleArray.length) {
            throw new ClassGenException("Match and target array have not the same length");
        }
        this.indices = new int[this.match_length];
    }

    protected int updatePosition(int n2, int n3) {
        this.position += n2;
        short s2 = this.length;
        this.padding = (4 - (this.position + 1) % 4) % 4;
        this.length = (short)(this.fixed_length + this.padding);
        return this.length - s2;
    }

    public void dump(DataOutputStream dataOutputStream) {
        dataOutputStream.writeByte(this.opcode);
        int n2 = 0;
        while (n2 < this.padding) {
            dataOutputStream.writeByte(0);
            ++n2;
        }
        this.index = this.getTargetOffset();
        dataOutputStream.writeInt(this.index);
    }

    protected void initFromFile(ByteSequence byteSequence, boolean bl2) {
        this.padding = (4 - byteSequence.getIndex() % 4) % 4;
        int n2 = 0;
        while (n2 < this.padding) {
            byte by2 = byteSequence.readByte();
            if (by2 != 0) {
                throw new ClassGenException("Padding byte != 0: " + by2);
            }
            ++n2;
        }
        this.index = byteSequence.readInt();
    }

    public String toString(boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(super.toString(bl2));
        if (bl2) {
            int n2 = 0;
            while (n2 < this.match_length) {
                String string = "null";
                if (this.targets[n2] != null) {
                    string = this.targets[n2].getInstruction().toString();
                }
                stringBuffer.append("(" + this.match[n2] + ", " + string + " = {" + this.indices[n2] + "})");
                ++n2;
            }
        } else {
            stringBuffer.append(" ...");
        }
        return stringBuffer.toString();
    }

    public void setTarget(int n2, InstructionHandle instructionHandle) {
        BranchInstruction.notifyTarget(this.targets[n2], instructionHandle, this);
        this.targets[n2] = instructionHandle;
    }

    public void updateTarget(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        boolean bl2 = false;
        if (this.target == instructionHandle) {
            bl2 = true;
            this.setTarget(instructionHandle2);
        }
        int n2 = 0;
        while (n2 < this.targets.length) {
            if (this.targets[n2] == instructionHandle) {
                bl2 = true;
                this.setTarget(n2, instructionHandle2);
            }
            ++n2;
        }
        if (!bl2) {
            throw new ClassGenException("Not targeting " + instructionHandle);
        }
    }

    public boolean containsTarget(InstructionHandle instructionHandle) {
        if (this.target == instructionHandle) {
            return true;
        }
        int n2 = 0;
        while (n2 < this.targets.length) {
            if (this.targets[n2] == instructionHandle) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    void dispose() {
        super.dispose();
        int n2 = 0;
        while (n2 < this.targets.length) {
            this.targets[n2].removeTargeter(this);
            ++n2;
        }
    }

    public int[] getMatchs() {
        return this.match;
    }

    public int[] getIndices() {
        return this.indices;
    }

    public InstructionHandle[] getTargets() {
        return this.targets;
    }
}

