/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.DataOutputStream;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ConstantPushInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.Type;
import org.apache.bcel.generic.Visitor;
import org.apache.bcel.util.ByteSequence;

public class SIPUSH
extends Instruction
implements ConstantPushInstruction {
    private short b;

    SIPUSH() {
    }

    public SIPUSH(short s2) {
        super((short)17, (short)3);
        this.b = s2;
    }

    public void dump(DataOutputStream dataOutputStream) {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.b);
    }

    public String toString(boolean bl2) {
        return super.toString(bl2) + " " + this.b;
    }

    protected void initFromFile(ByteSequence byteSequence, boolean bl2) {
        this.length = (short)3;
        this.b = byteSequence.readShort();
    }

    public Number getValue() {
        return new Integer(this.b);
    }

    public Type getType(ConstantPoolGen constantPoolGen) {
        return Type.SHORT;
    }

    public void accept(Visitor visitor) {
        visitor.visitPushInstruction(this);
        visitor.visitStackProducer(this);
        visitor.visitTypedInstruction(this);
        visitor.visitConstantPushInstruction(this);
        visitor.visitSIPUSH(this);
    }
}

