/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.DataOutputStream;
import org.apache.bcel.generic.ClassGenException;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.IndexedInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.ReturnaddressType;
import org.apache.bcel.generic.Type;
import org.apache.bcel.generic.TypedInstruction;
import org.apache.bcel.generic.Visitor;
import org.apache.bcel.util.ByteSequence;

public class RET
extends Instruction
implements IndexedInstruction,
TypedInstruction {
    private boolean wide;
    private int index;

    RET() {
    }

    public RET(int n2) {
        super((short)169, (short)2);
        this.setIndex(n2);
    }

    public void dump(DataOutputStream dataOutputStream) {
        if (this.wide) {
            dataOutputStream.writeByte(196);
        }
        dataOutputStream.writeByte(this.opcode);
        if (this.wide) {
            dataOutputStream.writeShort(this.index);
        } else {
            dataOutputStream.writeByte(this.index);
        }
    }

    private final void setWide() {
        this.wide = this.index > 255;
        this.length = this.wide ? (short)4 : (short)2;
    }

    protected void initFromFile(ByteSequence byteSequence, boolean bl2) {
        this.wide = bl2;
        if (bl2) {
            this.index = byteSequence.readUnsignedShort();
            this.length = (short)4;
        } else {
            this.index = byteSequence.readUnsignedByte();
            this.length = (short)2;
        }
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int n2) {
        if (n2 < 0) {
            throw new ClassGenException("Negative index value: " + n2);
        }
        this.index = n2;
        this.setWide();
    }

    public String toString(boolean bl2) {
        return super.toString(bl2) + " " + this.index;
    }

    public Type getType(ConstantPoolGen constantPoolGen) {
        return ReturnaddressType.NO_TARGET;
    }

    public void accept(Visitor visitor) {
        visitor.visitRET(this);
    }
}

