/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import org.apache.bcel.generic.BIPUSH;
import org.apache.bcel.generic.ClassGenException;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LDC2_W;
import org.apache.bcel.generic.SIPUSH;
import org.apache.bcel.generic.VariableLengthInstruction;

public final class PUSH
implements CompoundInstruction,
InstructionConstants,
VariableLengthInstruction {
    private Instruction instruction;

    public PUSH(ConstantPoolGen constantPoolGen, int n2) {
        this.instruction = n2 >= -1 && n2 <= 5 ? InstructionConstants.INSTRUCTIONS[3 + n2] : (n2 >= -128 && n2 <= 127 ? new BIPUSH((byte)n2) : (n2 >= Short.MIN_VALUE && n2 <= Short.MAX_VALUE ? new SIPUSH((short)n2) : new LDC(constantPoolGen.addInteger(n2))));
    }

    public PUSH(ConstantPoolGen constantPoolGen, boolean bl2) {
        this.instruction = InstructionConstants.INSTRUCTIONS[3 + (bl2 ? 1 : 0)];
    }

    public PUSH(ConstantPoolGen constantPoolGen, float f2) {
        this.instruction = (double)f2 == 0.0 ? InstructionConstants.FCONST_0 : ((double)f2 == 1.0 ? InstructionConstants.FCONST_1 : ((double)f2 == 2.0 ? InstructionConstants.FCONST_2 : new LDC(constantPoolGen.addFloat(f2))));
    }

    public PUSH(ConstantPoolGen constantPoolGen, long l2) {
        this.instruction = l2 == 0L ? InstructionConstants.LCONST_0 : (l2 == 1L ? InstructionConstants.LCONST_1 : new LDC2_W(constantPoolGen.addLong(l2)));
    }

    public PUSH(ConstantPoolGen constantPoolGen, double d2) {
        this.instruction = d2 == 0.0 ? InstructionConstants.DCONST_0 : (d2 == 1.0 ? InstructionConstants.DCONST_1 : new LDC2_W(constantPoolGen.addDouble(d2)));
    }

    public PUSH(ConstantPoolGen constantPoolGen, String string) {
        this.instruction = string == null ? InstructionConstants.ACONST_NULL : new LDC(constantPoolGen.addString(string));
    }

    public PUSH(ConstantPoolGen constantPoolGen, Number number) {
        if (number instanceof Integer || number instanceof Short || number instanceof Byte) {
            this.instruction = new PUSH((ConstantPoolGen)constantPoolGen, (int)number.intValue()).instruction;
        } else if (number instanceof Double) {
            this.instruction = new PUSH((ConstantPoolGen)constantPoolGen, (double)number.doubleValue()).instruction;
        } else if (number instanceof Float) {
            this.instruction = new PUSH((ConstantPoolGen)constantPoolGen, (float)number.floatValue()).instruction;
        } else if (number instanceof Long) {
            this.instruction = new PUSH((ConstantPoolGen)constantPoolGen, (long)number.longValue()).instruction;
        } else {
            throw new ClassGenException("What's this: " + number);
        }
    }

    public PUSH(ConstantPoolGen constantPoolGen, Character c2) {
        this(constantPoolGen, (int)c2.charValue());
    }

    public PUSH(ConstantPoolGen constantPoolGen, Boolean bl2) {
        this(constantPoolGen, (boolean)bl2);
    }

    public final InstructionList getInstructionList() {
        return new InstructionList(this.instruction);
    }

    public final Instruction getInstruction() {
        return this.instruction;
    }

    public String toString() {
        return this.instruction.toString() + " (PUSH)";
    }
}

