/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.generic.CPInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.PushInstruction;
import org.apache.bcel.generic.Type;
import org.apache.bcel.generic.TypedInstruction;
import org.apache.bcel.generic.Visitor;

public class LDC2_W
extends CPInstruction
implements PushInstruction,
TypedInstruction {
    LDC2_W() {
    }

    public LDC2_W(int n2) {
        super((short)20, n2);
    }

    public Type getType(ConstantPoolGen constantPoolGen) {
        switch (constantPoolGen.getConstantPool().getConstant(this.index).getTag()) {
            case 5: {
                return Type.LONG;
            }
            case 6: {
                return Type.DOUBLE;
            }
        }
        throw new RuntimeException("Unknown constant type " + this.opcode);
    }

    public Number getValue(ConstantPoolGen constantPoolGen) {
        Constant constant = constantPoolGen.getConstantPool().getConstant(this.index);
        switch (constant.getTag()) {
            case 5: {
                return new Long(((ConstantLong)constant).getBytes());
            }
            case 6: {
                return new Double(((ConstantDouble)constant).getBytes());
            }
        }
        throw new RuntimeException("Unknown or invalid constant type at " + this.index);
    }

    public void accept(Visitor visitor) {
        visitor.visitStackProducer(this);
        visitor.visitPushInstruction(this);
        visitor.visitTypedInstruction(this);
        visitor.visitCPInstruction(this);
        visitor.visitLDC2_W(this);
    }
}

