/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.DataOutputStream;
import org.apache.bcel.ExceptionConstants;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.generic.CPInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ExceptionThrower;
import org.apache.bcel.generic.PushInstruction;
import org.apache.bcel.generic.Type;
import org.apache.bcel.generic.TypedInstruction;
import org.apache.bcel.generic.Visitor;
import org.apache.bcel.util.ByteSequence;

public class LDC
extends CPInstruction
implements ExceptionThrower,
PushInstruction,
TypedInstruction {
    LDC() {
    }

    public LDC(int n2) {
        super((short)19, n2);
        this.setSize();
    }

    protected final void setSize() {
        if (this.index <= 255) {
            this.opcode = (short)18;
            this.length = (short)2;
        } else {
            this.opcode = (short)19;
            this.length = (short)3;
        }
    }

    public void dump(DataOutputStream dataOutputStream) {
        dataOutputStream.writeByte(this.opcode);
        if (this.length == 2) {
            dataOutputStream.writeByte(this.index);
        } else {
            dataOutputStream.writeShort(this.index);
        }
    }

    public final void setIndex(int n2) {
        super.setIndex(n2);
        this.setSize();
    }

    protected void initFromFile(ByteSequence byteSequence, boolean bl2) {
        this.length = (short)2;
        this.index = byteSequence.readUnsignedByte();
    }

    public Object getValue(ConstantPoolGen constantPoolGen) {
        Constant constant = constantPoolGen.getConstantPool().getConstant(this.index);
        switch (constant.getTag()) {
            case 8: {
                int n2 = ((ConstantString)constant).getStringIndex();
                constant = constantPoolGen.getConstantPool().getConstant(n2);
                return ((ConstantUtf8)constant).getBytes();
            }
            case 4: {
                return new Float(((ConstantFloat)constant).getBytes());
            }
            case 3: {
                return new Integer(((ConstantInteger)constant).getBytes());
            }
        }
        throw new RuntimeException("Unknown or invalid constant type at " + this.index);
    }

    public Type getType(ConstantPoolGen constantPoolGen) {
        switch (constantPoolGen.getConstantPool().getConstant(this.index).getTag()) {
            case 8: {
                return Type.STRING;
            }
            case 4: {
                return Type.FLOAT;
            }
            case 3: {
                return Type.INT;
            }
        }
        throw new RuntimeException("Unknown or invalid constant type at " + this.index);
    }

    public Class[] getExceptions() {
        return ExceptionConstants.EXCS_STRING_RESOLUTION;
    }

    public void accept(Visitor visitor) {
        visitor.visitStackProducer(this);
        visitor.visitPushInstruction(this);
        visitor.visitExceptionThrower(this);
        visitor.visitTypedInstruction(this);
        visitor.visitCPInstruction(this);
        visitor.visitLDC(this);
    }
}

