/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.AllocationInstruction;
import org.apache.bcel.generic.ArithmeticInstruction;
import org.apache.bcel.generic.ArrayInstruction;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.DLOAD;
import org.apache.bcel.generic.DSTORE;
import org.apache.bcel.generic.FLOAD;
import org.apache.bcel.generic.FSTORE;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.GOTO_W;
import org.apache.bcel.generic.IFEQ;
import org.apache.bcel.generic.IFGE;
import org.apache.bcel.generic.IFGT;
import org.apache.bcel.generic.IFLE;
import org.apache.bcel.generic.IFLT;
import org.apache.bcel.generic.IFNE;
import org.apache.bcel.generic.IFNONNULL;
import org.apache.bcel.generic.IFNULL;
import org.apache.bcel.generic.IF_ACMPEQ;
import org.apache.bcel.generic.IF_ACMPNE;
import org.apache.bcel.generic.IF_ICMPEQ;
import org.apache.bcel.generic.IF_ICMPGE;
import org.apache.bcel.generic.IF_ICMPGT;
import org.apache.bcel.generic.IF_ICMPLE;
import org.apache.bcel.generic.IF_ICMPLT;
import org.apache.bcel.generic.IF_ICMPNE;
import org.apache.bcel.generic.ILOAD;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.ISTORE;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.JSR;
import org.apache.bcel.generic.JSR_W;
import org.apache.bcel.generic.LLOAD;
import org.apache.bcel.generic.LSTORE;
import org.apache.bcel.generic.LocalVariableInstruction;
import org.apache.bcel.generic.MULTIANEWARRAY;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.NEWARRAY;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.bcel.generic.PUTSTATIC;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.StackInstruction;
import org.apache.bcel.generic.Type;

public class InstructionFactory
implements InstructionConstants {
    protected ClassGen cg;
    protected ConstantPoolGen cp;
    private static MethodObject[] append_mos = new MethodObject[]{new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.STRING}, 1), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.OBJECT}, 1), null, null, new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.BOOLEAN}, 1), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.CHAR}, 1), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.FLOAT}, 1), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.DOUBLE}, 1), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.INT}, 1), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.INT}, 1), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.INT}, 1), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.LONG}, 1)};

    public InstructionFactory(ClassGen classGen, ConstantPoolGen constantPoolGen) {
        this.cg = classGen;
        this.cp = constantPoolGen;
    }

    public InstructionFactory(ClassGen classGen) {
        this(classGen, classGen.getConstantPool());
    }

    public InstructionFactory(ConstantPoolGen constantPoolGen) {
        this(null, constantPoolGen);
    }

    public InvokeInstruction createInvoke(String string, String string2, Type type, Type[] typeArray, short s2) {
        int n2 = 0;
        String string3 = Type.getMethodSignature(type, typeArray);
        int n3 = 0;
        while (n3 < typeArray.length) {
            n2 += typeArray[n3].getSize();
            ++n3;
        }
        int n4 = s2 == 185 ? this.cp.addInterfaceMethodref(string, string2, string3) : this.cp.addMethodref(string, string2, string3);
        switch (s2) {
            case 183: {
                return new INVOKESPECIAL(n4);
            }
            case 182: {
                return new INVOKEVIRTUAL(n4);
            }
            case 184: {
                return new INVOKESTATIC(n4);
            }
            case 185: {
                return new INVOKEINTERFACE(n4, n2 + 1);
            }
        }
        throw new RuntimeException("Oops: Unknown invoke kind:" + s2);
    }

    public InstructionList createPrintln(String string) {
        InstructionList instructionList = new InstructionList();
        int n2 = this.cp.addFieldref("java.lang.System", "out", "Ljava/io/PrintStream;");
        int n3 = this.cp.addMethodref("java.io.PrintStream", "println", "(Ljava/lang/String;)V");
        instructionList.append(new GETSTATIC(n2));
        instructionList.append(new PUSH(this.cp, string));
        instructionList.append(new INVOKEVIRTUAL(n3));
        return instructionList;
    }

    private InvokeInstruction createInvoke(MethodObject methodObject, short s2) {
        return this.createInvoke(methodObject.class_name, methodObject.name, methodObject.result_type, methodObject.arg_types, s2);
    }

    private static final boolean isString(Type type) {
        return type instanceof ObjectType && ((ObjectType)type).getClassName().equals("java.lang.String");
    }

    public Instruction createAppend(Type type) {
        byte by2 = type.getType();
        if (InstructionFactory.isString(type)) {
            return this.createInvoke(append_mos[0], (short)182);
        }
        switch (by2) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return this.createInvoke(append_mos[by2], (short)182);
            }
            case 13: 
            case 14: {
                return this.createInvoke(append_mos[1], (short)182);
            }
        }
        throw new RuntimeException("Oops: No append for this type? " + type);
    }

    public FieldInstruction createFieldAccess(String string, String string2, Type type, short s2) {
        String string3 = type.getSignature();
        int n2 = this.cp.addFieldref(string, string2, string3);
        switch (s2) {
            case 180: {
                return new GETFIELD(n2);
            }
            case 181: {
                return new PUTFIELD(n2);
            }
            case 178: {
                return new GETSTATIC(n2);
            }
            case 179: {
                return new PUTSTATIC(n2);
            }
        }
        throw new RuntimeException("Oops: Unknown getfield kind:" + s2);
    }

    public static Instruction createThis() {
        return new ALOAD(0);
    }

    public static ReturnInstruction createReturn(Type type) {
        switch (type.getType()) {
            case 13: 
            case 14: {
                return InstructionConstants.ARETURN;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return InstructionConstants.IRETURN;
            }
            case 6: {
                return InstructionConstants.FRETURN;
            }
            case 7: {
                return InstructionConstants.DRETURN;
            }
            case 11: {
                return InstructionConstants.LRETURN;
            }
            case 12: {
                return InstructionConstants.RETURN;
            }
        }
        throw new RuntimeException("Invalid type: " + type);
    }

    private static final ArithmeticInstruction createBinaryIntOp(char c2, String string) {
        switch (c2) {
            case '-': {
                return InstructionConstants.ISUB;
            }
            case '+': {
                return InstructionConstants.IADD;
            }
            case '%': {
                return InstructionConstants.IREM;
            }
            case '*': {
                return InstructionConstants.IMUL;
            }
            case '/': {
                return InstructionConstants.IDIV;
            }
            case '&': {
                return InstructionConstants.IAND;
            }
            case '|': {
                return InstructionConstants.IOR;
            }
            case '^': {
                return InstructionConstants.IXOR;
            }
            case '<': {
                return InstructionConstants.ISHL;
            }
            case '>': {
                return string.equals(">>>") ? InstructionConstants.IUSHR : InstructionConstants.ISHR;
            }
        }
        throw new RuntimeException("Invalid operand " + string);
    }

    private static final ArithmeticInstruction createBinaryLongOp(char c2, String string) {
        switch (c2) {
            case '-': {
                return InstructionConstants.LSUB;
            }
            case '+': {
                return InstructionConstants.LADD;
            }
            case '%': {
                return InstructionConstants.LREM;
            }
            case '*': {
                return InstructionConstants.LMUL;
            }
            case '/': {
                return InstructionConstants.LDIV;
            }
            case '&': {
                return InstructionConstants.LAND;
            }
            case '|': {
                return InstructionConstants.LOR;
            }
            case '^': {
                return InstructionConstants.LXOR;
            }
            case '<': {
                return InstructionConstants.LSHL;
            }
            case '>': {
                return string.equals(">>>") ? InstructionConstants.LUSHR : InstructionConstants.LSHR;
            }
        }
        throw new RuntimeException("Invalid operand " + string);
    }

    private static final ArithmeticInstruction createBinaryFloatOp(char c2) {
        switch (c2) {
            case '-': {
                return InstructionConstants.FSUB;
            }
            case '+': {
                return InstructionConstants.FADD;
            }
            case '*': {
                return InstructionConstants.FMUL;
            }
            case '/': {
                return InstructionConstants.FDIV;
            }
        }
        throw new RuntimeException("Invalid operand " + c2);
    }

    private static final ArithmeticInstruction createBinaryDoubleOp(char c2) {
        switch (c2) {
            case '-': {
                return InstructionConstants.DSUB;
            }
            case '+': {
                return InstructionConstants.DADD;
            }
            case '*': {
                return InstructionConstants.DMUL;
            }
            case '/': {
                return InstructionConstants.DDIV;
            }
        }
        throw new RuntimeException("Invalid operand " + c2);
    }

    public static ArithmeticInstruction createBinaryOperation(String string, Type type) {
        char c2 = string.toCharArray()[0];
        switch (type.getType()) {
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return InstructionFactory.createBinaryIntOp(c2, string);
            }
            case 11: {
                return InstructionFactory.createBinaryLongOp(c2, string);
            }
            case 6: {
                return InstructionFactory.createBinaryFloatOp(c2);
            }
            case 7: {
                return InstructionFactory.createBinaryDoubleOp(c2);
            }
        }
        throw new RuntimeException("Invalid type " + type);
    }

    public static StackInstruction createPop(int n2) {
        return n2 == 2 ? InstructionConstants.POP2 : InstructionConstants.POP;
    }

    public static StackInstruction createDup(int n2) {
        return n2 == 2 ? InstructionConstants.DUP2 : InstructionConstants.DUP;
    }

    public static StackInstruction createDup_2(int n2) {
        return n2 == 2 ? InstructionConstants.DUP2_X2 : InstructionConstants.DUP_X2;
    }

    public static StackInstruction createDup_1(int n2) {
        return n2 == 2 ? InstructionConstants.DUP2_X1 : InstructionConstants.DUP_X1;
    }

    public static LocalVariableInstruction createStore(Type type, int n2) {
        switch (type.getType()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return new ISTORE(n2);
            }
            case 6: {
                return new FSTORE(n2);
            }
            case 7: {
                return new DSTORE(n2);
            }
            case 11: {
                return new LSTORE(n2);
            }
            case 13: 
            case 14: {
                return new ASTORE(n2);
            }
        }
        throw new RuntimeException("Invalid type " + type);
    }

    public static LocalVariableInstruction createLoad(Type type, int n2) {
        switch (type.getType()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return new ILOAD(n2);
            }
            case 6: {
                return new FLOAD(n2);
            }
            case 7: {
                return new DLOAD(n2);
            }
            case 11: {
                return new LLOAD(n2);
            }
            case 13: 
            case 14: {
                return new ALOAD(n2);
            }
        }
        throw new RuntimeException("Invalid type " + type);
    }

    public static ArrayInstruction createArrayLoad(Type type) {
        switch (type.getType()) {
            case 4: 
            case 8: {
                return InstructionConstants.BALOAD;
            }
            case 5: {
                return InstructionConstants.CALOAD;
            }
            case 9: {
                return InstructionConstants.SALOAD;
            }
            case 10: {
                return InstructionConstants.IALOAD;
            }
            case 6: {
                return InstructionConstants.FALOAD;
            }
            case 7: {
                return InstructionConstants.DALOAD;
            }
            case 11: {
                return InstructionConstants.LALOAD;
            }
            case 13: 
            case 14: {
                return InstructionConstants.AALOAD;
            }
        }
        throw new RuntimeException("Invalid type " + type);
    }

    public static ArrayInstruction createArrayStore(Type type) {
        switch (type.getType()) {
            case 4: 
            case 8: {
                return InstructionConstants.BASTORE;
            }
            case 5: {
                return InstructionConstants.CASTORE;
            }
            case 9: {
                return InstructionConstants.SASTORE;
            }
            case 10: {
                return InstructionConstants.IASTORE;
            }
            case 6: {
                return InstructionConstants.FASTORE;
            }
            case 7: {
                return InstructionConstants.DASTORE;
            }
            case 11: {
                return InstructionConstants.LASTORE;
            }
            case 13: 
            case 14: {
                return InstructionConstants.AASTORE;
            }
        }
        throw new RuntimeException("Invalid type " + type);
    }

    public Instruction createCast(Type type, Type type2) {
        if (type instanceof BasicType && type2 instanceof BasicType) {
            byte by2 = type2.getType();
            int n2 = type.getType();
            if (by2 == 11 && (n2 == 5 || n2 == 8 || n2 == 9)) {
                n2 = 10;
            }
            String[] stringArray = new String[]{"C", "F", "D", "B", "S", "I", "L"};
            String string = "org.apache.bcel.generic." + stringArray[n2 - 5] + "2" + stringArray[by2 - 5];
            Instruction instruction = null;
            try {
                instruction = (Instruction)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                throw new RuntimeException("Could not find instruction: " + string);
            }
            return instruction;
        }
        if (type instanceof ReferenceType && type2 instanceof ReferenceType) {
            if (type2 instanceof ArrayType) {
                return new CHECKCAST(this.cp.addArrayClass((ArrayType)type2));
            }
            return new CHECKCAST(this.cp.addClass(((ObjectType)type2).getClassName()));
        }
        throw new RuntimeException("Can not cast " + type + " to " + type2);
    }

    public GETFIELD createGetField(String string, String string2, Type type) {
        return new GETFIELD(this.cp.addFieldref(string, string2, type.getSignature()));
    }

    public GETSTATIC createGetStatic(String string, String string2, Type type) {
        return new GETSTATIC(this.cp.addFieldref(string, string2, type.getSignature()));
    }

    public PUTFIELD createPutField(String string, String string2, Type type) {
        return new PUTFIELD(this.cp.addFieldref(string, string2, type.getSignature()));
    }

    public PUTSTATIC createPutStatic(String string, String string2, Type type) {
        return new PUTSTATIC(this.cp.addFieldref(string, string2, type.getSignature()));
    }

    public CHECKCAST createCheckCast(ReferenceType referenceType) {
        if (referenceType instanceof ArrayType) {
            return new CHECKCAST(this.cp.addArrayClass((ArrayType)referenceType));
        }
        return new CHECKCAST(this.cp.addClass((ObjectType)referenceType));
    }

    public NEW createNew(ObjectType objectType) {
        return new NEW(this.cp.addClass(objectType));
    }

    public NEW createNew(String string) {
        return this.createNew(new ObjectType(string));
    }

    public AllocationInstruction createNewArray(Type type, short s2) {
        if (s2 == 1) {
            if (type instanceof ObjectType) {
                return new ANEWARRAY(this.cp.addClass((ObjectType)type));
            }
            if (type instanceof ArrayType) {
                return new ANEWARRAY(this.cp.addArrayClass((ArrayType)type));
            }
            return new NEWARRAY(((BasicType)type).getType());
        }
        ArrayType arrayType = type instanceof ArrayType ? (ArrayType)type : new ArrayType(type, (int)s2);
        return new MULTIANEWARRAY(this.cp.addArrayClass(arrayType), s2);
    }

    public static Instruction createNull(Type type) {
        switch (type.getType()) {
            case 13: 
            case 14: {
                return InstructionConstants.ACONST_NULL;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return InstructionConstants.ICONST_0;
            }
            case 6: {
                return InstructionConstants.FCONST_0;
            }
            case 7: {
                return InstructionConstants.DCONST_0;
            }
            case 11: {
                return InstructionConstants.LCONST_0;
            }
            case 12: {
                return InstructionConstants.NOP;
            }
        }
        throw new RuntimeException("Invalid type: " + type);
    }

    public static BranchInstruction createBranchInstruction(short s2, InstructionHandle instructionHandle) {
        switch (s2) {
            case 153: {
                return new IFEQ(instructionHandle);
            }
            case 154: {
                return new IFNE(instructionHandle);
            }
            case 155: {
                return new IFLT(instructionHandle);
            }
            case 156: {
                return new IFGE(instructionHandle);
            }
            case 157: {
                return new IFGT(instructionHandle);
            }
            case 158: {
                return new IFLE(instructionHandle);
            }
            case 159: {
                return new IF_ICMPEQ(instructionHandle);
            }
            case 160: {
                return new IF_ICMPNE(instructionHandle);
            }
            case 161: {
                return new IF_ICMPLT(instructionHandle);
            }
            case 162: {
                return new IF_ICMPGE(instructionHandle);
            }
            case 163: {
                return new IF_ICMPGT(instructionHandle);
            }
            case 164: {
                return new IF_ICMPLE(instructionHandle);
            }
            case 165: {
                return new IF_ACMPEQ(instructionHandle);
            }
            case 166: {
                return new IF_ACMPNE(instructionHandle);
            }
            case 167: {
                return new GOTO(instructionHandle);
            }
            case 168: {
                return new JSR(instructionHandle);
            }
            case 198: {
                return new IFNULL(instructionHandle);
            }
            case 199: {
                return new IFNONNULL(instructionHandle);
            }
            case 200: {
                return new GOTO_W(instructionHandle);
            }
            case 201: {
                return new JSR_W(instructionHandle);
            }
        }
        throw new RuntimeException("Invalid opcode: " + s2);
    }

    public void setClassGen(ClassGen classGen) {
        this.cg = classGen;
    }

    public ClassGen getClassGen() {
        return this.cg;
    }

    public void setConstantPool(ConstantPoolGen constantPoolGen) {
        this.cp = constantPoolGen;
    }

    public ConstantPoolGen getConstantPool() {
        return this.cp;
    }

    private static class MethodObject {
        Type[] arg_types;
        Type result_type;
        String[] arg_names;
        String class_name;
        String name;
        int access;

        MethodObject(String string, String string2, Type type, Type[] typeArray, int n2) {
            this.class_name = string;
            this.name = string2;
            this.result_type = type;
            this.arg_types = typeArray;
            this.access = n2;
        }
    }
}

