/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.DataOutputStream;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ConstantPushInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.Type;
import org.apache.bcel.generic.Visitor;
import org.apache.bcel.util.ByteSequence;

public class BIPUSH
extends Instruction
implements ConstantPushInstruction {
    private byte b;

    BIPUSH() {
    }

    public BIPUSH(byte by2) {
        super((short)16, (short)2);
        this.b = by2;
    }

    public void dump(DataOutputStream dataOutputStream) {
        super.dump(dataOutputStream);
        dataOutputStream.writeByte(this.b);
    }

    public String toString(boolean bl2) {
        return super.toString(bl2) + " " + this.b;
    }

    protected void initFromFile(ByteSequence byteSequence, boolean bl2) {
        this.length = (short)2;
        this.b = byteSequence.readByte();
    }

    public Number getValue() {
        return new Integer(this.b);
    }

    public Type getType(ConstantPoolGen constantPoolGen) {
        return Type.BYTE;
    }

    public void accept(Visitor visitor) {
        visitor.visitPushInstruction(this);
        visitor.visitStackProducer(this);
        visitor.visitTypedInstruction(this);
        visitor.visitConstantPushInstruction(this);
        visitor.visitBIPUSH(this);
    }
}

