/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.FilterReader;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.util.ByteSequence;

public abstract class Utility {
    private static int consumed_chars;
    private static boolean wide;
    private static final int FREE_CHARS = 48;
    private static int[] CHAR_MAP;
    private static int[] MAP_CHAR;
    private static final char ESCAPE_CHAR = '$';

    public static final String accessToString(int n2) {
        return Utility.accessToString(n2, false);
    }

    public static final String accessToString(int n2, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        int n4 = 0;
        while (n3 < 1024) {
            n3 = Utility.pow2(n4);
            if ((n2 & n3) != 0 && (!bl2 || n3 != 32 && n3 != 512)) {
                stringBuffer.append(Constants.ACCESS_NAMES[n4] + " ");
            }
            ++n4;
        }
        return stringBuffer.toString().trim();
    }

    public static final String classOrInterface(int n2) {
        return (n2 & 0x200) != 0 ? "interface" : "class";
    }

    public static final String codeToString(byte[] byArray, ConstantPool constantPool, int n2, int n3, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 20);
        ByteSequence byteSequence = new ByteSequence(byArray);
        try {
            int n4 = 0;
            while (n4 < n2) {
                Utility.codeToString(byteSequence, constantPool, bl2);
                ++n4;
            }
            int n5 = 0;
            while (byteSequence.available() > 0) {
                if (n3 < 0 || n5 < n3) {
                    String string = Utility.fillup(byteSequence.getIndex() + ":", 6, true, ' ');
                    stringBuffer.append(string + Utility.codeToString(byteSequence, constantPool, bl2) + '\n');
                }
                ++n5;
            }
        }
        catch (IOException iOException) {
            System.out.println(stringBuffer.toString());
            iOException.printStackTrace();
            throw new ClassFormatError("Byte code error: " + iOException);
        }
        return stringBuffer.toString();
    }

    public static final String codeToString(byte[] byArray, ConstantPool constantPool, int n2, int n3) {
        return Utility.codeToString(byArray, constantPool, n2, n3, true);
    }

    public static final String codeToString(ByteSequence byteSequence, ConstantPool constantPool, boolean bl2) {
        int n2;
        int n3;
        int n4;
        short s2 = (short)byteSequence.readUnsignedByte();
        int n5 = 0;
        int n6 = 0;
        StringBuffer stringBuffer = new StringBuffer(Constants.OPCODE_NAMES[s2]);
        if (s2 == 170 || s2 == 171) {
            n4 = byteSequence.getIndex() % 4;
            n6 = n4 == 0 ? 0 : 4 - n4;
            n3 = 0;
            while (n3 < n6) {
                byte by2 = byteSequence.readByte();
                n2 = by2;
                if (by2 != 0) {
                    System.err.println("Warning: Padding byte != 0 in " + Constants.OPCODE_NAMES[s2] + ":" + n2);
                }
                ++n3;
            }
            n5 = byteSequence.readInt();
        }
        switch (s2) {
            case 170: {
                int n7 = byteSequence.readInt();
                int n8 = byteSequence.readInt();
                int n9 = byteSequence.getIndex() - 12 - n6 - 1;
                stringBuffer.append("\tdefault = " + (n5 += n9) + ", low = " + n7 + ", high = " + n8 + "(");
                int[] nArray = new int[n8 - n7 + 1];
                n4 = 0;
                while (n4 < nArray.length) {
                    nArray[n4] = n9 + byteSequence.readInt();
                    stringBuffer.append(nArray[n4]);
                    if (n4 < nArray.length - 1) {
                        stringBuffer.append(", ");
                    }
                    ++n4;
                }
                stringBuffer.append(")");
                break;
            }
            case 171: {
                int n10 = byteSequence.readInt();
                int n11 = byteSequence.getIndex() - 8 - n6 - 1;
                int[] nArray = new int[n10];
                int[] nArray2 = new int[n10];
                stringBuffer.append("\tdefault = " + (n5 += n11) + ", npairs = " + n10 + " (");
                n3 = 0;
                while (n3 < n10) {
                    nArray[n3] = byteSequence.readInt();
                    nArray2[n3] = n11 + byteSequence.readInt();
                    stringBuffer.append("(" + nArray[n3] + ", " + nArray2[n3] + ")");
                    if (n3 < n10 - 1) {
                        stringBuffer.append(", ");
                    }
                    ++n3;
                }
                stringBuffer.append(")");
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                stringBuffer.append("\t\t#" + (byteSequence.getIndex() - 1 + byteSequence.readShort()));
                break;
            }
            case 200: 
            case 201: {
                stringBuffer.append("\t\t#" + (byteSequence.getIndex() - 1 + byteSequence.readInt()));
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: {
                int n12;
                if (wide) {
                    n12 = byteSequence.readUnsignedShort();
                    wide = false;
                } else {
                    n12 = byteSequence.readUnsignedByte();
                }
                stringBuffer.append("\t\t%" + n12);
                break;
            }
            case 196: {
                wide = true;
                stringBuffer.append("\t(wide)");
                break;
            }
            case 188: {
                stringBuffer.append("\t\t<" + Constants.TYPE_NAMES[byteSequence.readByte()] + ">");
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                int n13 = byteSequence.readUnsignedShort();
                stringBuffer.append("\t\t" + constantPool.constantToString(n13, (byte)9) + (bl2 ? " (" + n13 + ")" : ""));
                break;
            }
            case 187: 
            case 192: {
                stringBuffer.append("\t");
            }
            case 193: {
                int n14 = byteSequence.readUnsignedShort();
                stringBuffer.append("\t<" + constantPool.constantToString(n14, (byte)7) + ">" + (bl2 ? " (" + n14 + ")" : ""));
                break;
            }
            case 182: 
            case 183: 
            case 184: {
                int n15 = byteSequence.readUnsignedShort();
                stringBuffer.append("\t" + constantPool.constantToString(n15, (byte)10) + (bl2 ? " (" + n15 + ")" : ""));
                break;
            }
            case 185: {
                int n16 = byteSequence.readUnsignedShort();
                n3 = byteSequence.readUnsignedByte();
                stringBuffer.append("\t" + constantPool.constantToString(n16, (byte)11) + (bl2 ? " (" + n16 + ")\t" : "") + n3 + "\t" + byteSequence.readUnsignedByte());
                break;
            }
            case 19: 
            case 20: {
                int n17 = byteSequence.readUnsignedShort();
                stringBuffer.append("\t\t" + constantPool.constantToString(n17, constantPool.getConstant(n17).getTag()) + (bl2 ? " (" + n17 + ")" : ""));
                break;
            }
            case 18: {
                int n18 = byteSequence.readUnsignedByte();
                stringBuffer.append("\t\t" + constantPool.constantToString(n18, constantPool.getConstant(n18).getTag()) + (bl2 ? " (" + n18 + ")" : ""));
                break;
            }
            case 189: {
                int n19 = byteSequence.readUnsignedShort();
                stringBuffer.append("\t\t<" + Utility.compactClassName(constantPool.getConstantString(n19, (byte)7), false) + ">" + (bl2 ? " (" + n19 + ")" : ""));
                break;
            }
            case 197: {
                int n20 = byteSequence.readUnsignedShort();
                n2 = byteSequence.readUnsignedByte();
                stringBuffer.append("\t<" + Utility.compactClassName(constantPool.getConstantString(n20, (byte)7), false) + ">\t" + n2 + (bl2 ? " (" + n20 + ")" : ""));
                break;
            }
            case 132: {
                short s3;
                int n21;
                if (wide) {
                    n21 = byteSequence.readUnsignedShort();
                    s3 = byteSequence.readShort();
                    wide = false;
                } else {
                    n21 = byteSequence.readUnsignedByte();
                    s3 = byteSequence.readByte();
                }
                stringBuffer.append("\t\t%" + n21 + "\t" + s3);
                break;
            }
            default: {
                if (Constants.NO_OF_OPERANDS[s2] <= 0) break;
                n2 = 0;
                while (n2 < Constants.TYPE_OF_OPERANDS[s2].length) {
                    stringBuffer.append("\t\t");
                    switch (Constants.TYPE_OF_OPERANDS[s2][n2]) {
                        case 8: {
                            stringBuffer.append(byteSequence.readByte());
                            break;
                        }
                        case 9: {
                            stringBuffer.append(byteSequence.readShort());
                            break;
                        }
                        case 10: {
                            stringBuffer.append(byteSequence.readInt());
                            break;
                        }
                        default: {
                            System.err.println("Unreachable default case reached!");
                            System.exit(-1);
                        }
                    }
                    ++n2;
                }
                break block0;
            }
        }
        return stringBuffer.toString();
    }

    public static final String codeToString(ByteSequence byteSequence, ConstantPool constantPool) {
        return Utility.codeToString(byteSequence, constantPool, true);
    }

    public static final String compactClassName(String string) {
        return Utility.compactClassName(string, true);
    }

    public static final String compactClassName(String string, String string2, boolean bl2) {
        int n2 = string2.length();
        string = string.replace('/', '.');
        if (bl2 && string.startsWith(string2) && string.substring(n2).indexOf(46) == -1) {
            string = string.substring(n2);
        }
        return string;
    }

    public static final String compactClassName(String string, boolean bl2) {
        return Utility.compactClassName(string, "java.lang.", bl2);
    }

    private static final boolean is_digit(char c2) {
        return c2 >= '0' && c2 <= '9';
    }

    private static final boolean is_space(char c2) {
        return c2 == ' ' || c2 == '\t' || c2 == '\r' || c2 == '\n';
    }

    public static final int setBit(int n2, int n3) {
        return n2 | Utility.pow2(n3);
    }

    public static final int clearBit(int n2, int n3) {
        int n4 = Utility.pow2(n3);
        return (n2 & n4) == 0 ? n2 : n2 ^ n4;
    }

    public static final boolean isSet(int n2, int n3) {
        return (n2 & Utility.pow2(n3)) != 0;
    }

    public static final String methodTypeToSignature(String string, String[] stringArray) {
        String string2;
        StringBuffer stringBuffer = new StringBuffer("(");
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                string2 = Utility.getSignature(stringArray[n2]);
                if (string2.endsWith("V")) {
                    throw new ClassFormatError("Invalid type: " + stringArray[n2]);
                }
                stringBuffer.append(string2);
                ++n2;
            }
        }
        string2 = Utility.getSignature(string);
        stringBuffer.append(")" + string2);
        return stringBuffer.toString();
    }

    public static final String[] methodSignatureArgumentTypes(String string) {
        return Utility.methodSignatureArgumentTypes(string, true);
    }

    public static final String[] methodSignatureArgumentTypes(String string, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            if (string.charAt(0) != '(') {
                throw new ClassFormatError("Invalid method signature: " + string);
            }
            int n2 = 1;
            while (string.charAt(n2) != ')') {
                arrayList.add(Utility.signatureToString(string.substring(n2), bl2));
                n2 += consumed_chars;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatError("Invalid method signature: " + string);
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static final String methodSignatureReturnType(String string) {
        return Utility.methodSignatureReturnType(string, true);
    }

    public static final String methodSignatureReturnType(String string, boolean bl2) {
        String string2;
        try {
            int n2 = string.lastIndexOf(41) + 1;
            string2 = Utility.signatureToString(string.substring(n2), bl2);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatError("Invalid method signature: " + string);
        }
        return string2;
    }

    public static final String methodSignatureToString(String string, String string2, String string3) {
        return Utility.methodSignatureToString(string, string2, string3, true);
    }

    public static final String methodSignatureToString(String string, String string2, String string3, boolean bl2) {
        return Utility.methodSignatureToString(string, string2, string3, bl2, null);
    }

    public static final String methodSignatureToString(String string, String string2, String string3, boolean bl2, LocalVariableTable localVariableTable) {
        String string4;
        StringBuffer stringBuffer = new StringBuffer("(");
        int n2 = string3.indexOf("static") >= 0 ? 0 : 1;
        try {
            if (string.charAt(0) != '(') {
                throw new ClassFormatError("Invalid method signature: " + string);
            }
            int n3 = 1;
            while (string.charAt(n3) != ')') {
                stringBuffer.append(Utility.signatureToString(string.substring(n3), bl2));
                if (localVariableTable != null) {
                    LocalVariable localVariable = localVariableTable.getLocalVariable(n2);
                    if (localVariable != null) {
                        stringBuffer.append(" " + localVariable.getName());
                    }
                } else {
                    stringBuffer.append(" arg" + n2);
                }
                ++n2;
                stringBuffer.append(", ");
                n3 += consumed_chars;
            }
            string4 = Utility.signatureToString(string.substring(++n3), bl2);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatError("Invalid method signature: " + string);
        }
        if (stringBuffer.length() > 1) {
            stringBuffer.setLength(stringBuffer.length() - 2);
        }
        stringBuffer.append(")");
        return string3 + (string3.length() > 0 ? " " : "") + string4 + " " + string2 + stringBuffer.toString();
    }

    private static final int pow2(int n2) {
        return 1 << n2;
    }

    public static final String replace(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n2 = string.indexOf(string2);
            if (n2 != -1) {
                int n3 = 0;
                while ((n2 = string.indexOf(string2, n3)) != -1) {
                    stringBuffer.append(string.substring(n3, n2));
                    stringBuffer.append(string3);
                    n3 = n2 + string2.length();
                }
                stringBuffer.append(string.substring(n3));
                string = stringBuffer.toString();
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            System.err.println(stringIndexOutOfBoundsException);
        }
        return string;
    }

    public static final String signatureToString(String string) {
        return Utility.signatureToString(string, true);
    }

    public static final String signatureToString(String string, boolean bl2) {
        consumed_chars = 1;
        try {
            switch (string.charAt(0)) {
                case 'B': {
                    return "byte";
                }
                case 'C': {
                    return "char";
                }
                case 'D': {
                    return "double";
                }
                case 'F': {
                    return "float";
                }
                case 'I': {
                    return "int";
                }
                case 'J': {
                    return "long";
                }
                case 'L': {
                    int n2 = string.indexOf(59);
                    if (n2 < 0) {
                        throw new ClassFormatError("Invalid signature: " + string);
                    }
                    consumed_chars = n2 + 1;
                    return Utility.compactClassName(string.substring(1, n2), bl2);
                }
                case 'S': {
                    return "short";
                }
                case 'Z': {
                    return "boolean";
                }
                case '[': {
                    StringBuffer stringBuffer = new StringBuffer();
                    int n3 = 0;
                    while (string.charAt(n3) == '[') {
                        stringBuffer.append("[]");
                        ++n3;
                    }
                    int n4 = n3;
                    String string2 = Utility.signatureToString(string.substring(n3), bl2);
                    consumed_chars += n4;
                    return string2 + stringBuffer.toString();
                }
                case 'V': {
                    return "void";
                }
            }
            throw new ClassFormatError("Invalid signature: `" + string + "'");
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatError("Invalid signature: " + stringIndexOutOfBoundsException + ":" + string);
        }
    }

    public static String getSignature(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = -1;
        int n3 = 0;
        block4: while (n3 < cArray.length) {
            switch (cArray[n3]) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (!bl2) break;
                    bl3 = true;
                    break;
                }
                case '[': {
                    if (!bl2) {
                        throw new RuntimeException("Illegal type: " + string);
                    }
                    n2 = n3;
                    break block4;
                }
                default: {
                    bl2 = true;
                    if (bl3) break;
                    stringBuffer.append(cArray[n3]);
                }
            }
            ++n3;
        }
        int n4 = 0;
        if (n2 > 0) {
            n4 = Utility.countBrackets(string.substring(n2));
        }
        string = stringBuffer.toString();
        stringBuffer.setLength(0);
        int n5 = 0;
        while (n5 < n4) {
            stringBuffer.append('[');
            ++n5;
        }
        boolean bl4 = false;
        int n6 = 4;
        while (n6 <= 12 && !bl4) {
            if (Constants.TYPE_NAMES[n6].equals(string)) {
                bl4 = true;
                stringBuffer.append(Constants.SHORT_TYPE_NAMES[n6]);
            }
            ++n6;
        }
        if (!bl4) {
            stringBuffer.append('L' + string.replace('.', '/') + ';');
        }
        return stringBuffer.toString();
    }

    private static int countBrackets(String string) {
        char[] cArray = string.toCharArray();
        int n2 = 0;
        boolean bl2 = false;
        int n3 = 0;
        while (n3 < cArray.length) {
            switch (cArray[n3]) {
                case '[': {
                    if (bl2) {
                        throw new RuntimeException("Illegally nested brackets:" + string);
                    }
                    bl2 = true;
                    break;
                }
                case ']': {
                    if (!bl2) {
                        throw new RuntimeException("Illegally nested brackets:" + string);
                    }
                    bl2 = false;
                    ++n2;
                    break;
                }
            }
            ++n3;
        }
        if (bl2) {
            throw new RuntimeException("Illegally nested brackets:" + string);
        }
        return n2;
    }

    public static final byte typeOfMethodSignature(String string) {
        try {
            if (string.charAt(0) != '(') {
                throw new ClassFormatError("Invalid method signature: " + string);
            }
            int n2 = string.lastIndexOf(41) + 1;
            return Utility.typeOfSignature(string.substring(n2));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatError("Invalid method signature: " + string);
        }
    }

    public static final byte typeOfSignature(String string) {
        try {
            switch (string.charAt(0)) {
                case 'B': {
                    return 8;
                }
                case 'C': {
                    return 5;
                }
                case 'D': {
                    return 7;
                }
                case 'F': {
                    return 6;
                }
                case 'I': {
                    return 10;
                }
                case 'J': {
                    return 11;
                }
                case 'L': {
                    return 14;
                }
                case '[': {
                    return 13;
                }
                case 'V': {
                    return 12;
                }
                case 'Z': {
                    return 4;
                }
                case 'S': {
                    return 9;
                }
            }
            throw new ClassFormatError("Invalid method signature: " + string);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatError("Invalid method signature: " + string);
        }
    }

    public static short searchOpcode(String string) {
        string = string.toLowerCase();
        short s2 = 0;
        while (s2 < Constants.OPCODE_NAMES.length) {
            if (Constants.OPCODE_NAMES[s2].equals(string)) {
                return s2;
            }
            s2 = (short)(s2 + 1);
        }
        return -1;
    }

    private static final short byteToShort(byte by2) {
        return by2 < 0 ? (short)(256 + by2) : (short)by2;
    }

    public static final String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < byArray.length) {
            short s2 = Utility.byteToShort(byArray[n2]);
            String string = Integer.toString(s2, 16);
            if (s2 < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
            if (n2 < byArray.length - 1) {
                stringBuffer.append(' ');
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static final String format(int n2, int n3, boolean bl2, char c2) {
        return Utility.fillup(Integer.toString(n2), n3, bl2, c2);
    }

    public static final String fillup(String string, int n2, boolean bl2, char c2) {
        int n3 = n2 - string.length();
        char[] cArray = new char[n3 < 0 ? 0 : n3];
        int n4 = 0;
        while (n4 < cArray.length) {
            cArray[n4] = c2;
            ++n4;
        }
        if (bl2) {
            return string + new String(cArray);
        }
        return new String(cArray) + string;
    }

    static final boolean equals(byte[] byArray, byte[] byArray2) {
        int n2 = byArray.length;
        if (n2 != byArray2.length) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (byArray[n3] != byArray2[n3]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static final void printArray(PrintStream printStream, Object[] objectArray) {
        printStream.println(Utility.printArray(objectArray, true));
    }

    public static final void printArray(PrintWriter printWriter, Object[] objectArray) {
        printWriter.println(Utility.printArray(objectArray, true));
    }

    public static final String printArray(Object[] objectArray) {
        return Utility.printArray(objectArray, true);
    }

    public static final String printArray(Object[] objectArray, boolean bl2) {
        if (objectArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (bl2) {
            stringBuffer.append('{');
        }
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (objectArray[n2] != null) {
                stringBuffer.append(objectArray[n2].toString());
            } else {
                stringBuffer.append("null");
            }
            if (n2 < objectArray.length - 1) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        if (bl2) {
            stringBuffer.append('}');
        }
        return stringBuffer.toString();
    }

    public static boolean isJavaIdentifierPart(char c2) {
        return c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || c2 == '_';
    }

    public static String encode(byte[] byArray, boolean bl2) {
        Closeable closeable;
        Closeable closeable2;
        if (bl2) {
            closeable2 = new ByteArrayOutputStream();
            closeable = new GZIPOutputStream((OutputStream)closeable2);
            ((GZIPOutputStream)closeable).write(byArray, 0, byArray.length);
            ((DeflaterOutputStream)closeable).close();
            ((ByteArrayOutputStream)closeable2).close();
            byArray = ((ByteArrayOutputStream)closeable2).toByteArray();
        }
        closeable2 = new CharArrayWriter();
        closeable = new JavaWriter((Writer)closeable2);
        int n2 = 0;
        while (n2 < byArray.length) {
            int n3 = byArray[n2] & 0xFF;
            ((JavaWriter)closeable).write(n3);
            ++n2;
        }
        return ((CharArrayWriter)closeable2).toString();
    }

    public static byte[] decode(String string, boolean bl2) {
        int n2;
        char[] cArray = string.toCharArray();
        CharArrayReader charArrayReader = new CharArrayReader(cArray);
        JavaReader javaReader = new JavaReader(charArrayReader);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n2 = javaReader.read()) >= 0) {
            byteArrayOutputStream.write(n2);
        }
        byteArrayOutputStream.close();
        charArrayReader.close();
        javaReader.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (bl2) {
            int n3;
            GZIPInputStream gZIPInputStream = new GZIPInputStream(new ByteArrayInputStream(byArray));
            byte[] byArray2 = new byte[byArray.length * 3];
            int n4 = 0;
            while ((n3 = gZIPInputStream.read()) >= 0) {
                byArray2[n4++] = (byte)n3;
            }
            byArray = new byte[n4];
            System.arraycopy(byArray2, 0, byArray, 0, n4);
        }
        return byArray;
    }

    static int[] access$000() {
        return MAP_CHAR;
    }

    static int[] access$100() {
        return CHAR_MAP;
    }

    static {
        wide = false;
        CHAR_MAP = new int[48];
        MAP_CHAR = new int[256];
        int n2 = 0;
        boolean bl2 = false;
        int n3 = 65;
        while (n3 <= 90) {
            Utility.CHAR_MAP[n2] = n3;
            Utility.MAP_CHAR[n3] = n2++;
            ++n3;
        }
        int n4 = 103;
        while (n4 <= 122) {
            Utility.CHAR_MAP[n2] = n4;
            Utility.MAP_CHAR[n4] = n2++;
            ++n4;
        }
        Utility.CHAR_MAP[n2] = 36;
        Utility.MAP_CHAR[36] = n2++;
        Utility.CHAR_MAP[n2] = 95;
        Utility.MAP_CHAR[95] = n2;
    }

    private static class JavaWriter
    extends FilterWriter {
        public JavaWriter(Writer writer) {
            super(writer);
        }

        public void write(int n2) {
            if (Utility.isJavaIdentifierPart((char)n2) && n2 != 36) {
                this.out.write(n2);
            } else {
                this.out.write(36);
                if (n2 >= 0 && n2 < 48) {
                    this.out.write(Utility.access$100()[n2]);
                } else {
                    char[] cArray = Integer.toHexString(n2).toCharArray();
                    if (cArray.length == 1) {
                        this.out.write(48);
                        this.out.write(cArray[0]);
                    } else {
                        this.out.write(cArray[0]);
                        this.out.write(cArray[1]);
                    }
                }
            }
        }

        public void write(char[] cArray, int n2, int n3) {
            int n4 = 0;
            while (n4 < n3) {
                this.write(cArray[n2 + n4]);
                ++n4;
            }
        }

        public void write(String string, int n2, int n3) {
            this.write(string.toCharArray(), n2, n3);
        }
    }

    private static class JavaReader
    extends FilterReader {
        public JavaReader(Reader reader) {
            super(reader);
        }

        public int read() {
            int n2 = this.in.read();
            if (n2 != 36) {
                return n2;
            }
            int n3 = this.in.read();
            if (n3 < 0) {
                return -1;
            }
            if (n3 >= 48 && n3 <= 57 || n3 >= 97 && n3 <= 102) {
                int n4 = this.in.read();
                if (n4 < 0) {
                    return -1;
                }
                char[] cArray = new char[]{(char)n3, (char)n4};
                int n5 = Integer.parseInt(new String(cArray), 16);
                return n5;
            }
            return Utility.access$000()[n3];
        }

        public int read(char[] cArray, int n2, int n3) {
            int n4 = 0;
            while (n4 < n3) {
                cArray[n2 + n4] = (char)this.read();
                ++n4;
            }
            return n3;
        }
    }
}

