/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.StackMapType;
import org.apache.bcel.classfile.Visitor;

public final class StackMapEntry
implements Cloneable {
    private int byte_code_offset;
    private int number_of_locals;
    private StackMapType[] types_of_locals;
    private int number_of_stack_items;
    private StackMapType[] types_of_stack_items;
    private ConstantPool constant_pool;

    StackMapEntry(DataInputStream dataInputStream, ConstantPool constantPool) {
        this(dataInputStream.readShort(), dataInputStream.readShort(), null, -1, null, constantPool);
        this.types_of_locals = new StackMapType[this.number_of_locals];
        int n2 = 0;
        while (n2 < this.number_of_locals) {
            this.types_of_locals[n2] = new StackMapType(dataInputStream, constantPool);
            ++n2;
        }
        this.number_of_stack_items = dataInputStream.readShort();
        this.types_of_stack_items = new StackMapType[this.number_of_stack_items];
        int n3 = 0;
        while (n3 < this.number_of_stack_items) {
            this.types_of_stack_items[n3] = new StackMapType(dataInputStream, constantPool);
            ++n3;
        }
    }

    public StackMapEntry(int n2, int n3, StackMapType[] stackMapTypeArray, int n4, StackMapType[] stackMapTypeArray2, ConstantPool constantPool) {
        this.byte_code_offset = n2;
        this.number_of_locals = n3;
        this.types_of_locals = stackMapTypeArray;
        this.number_of_stack_items = n4;
        this.types_of_stack_items = stackMapTypeArray2;
        this.constant_pool = constantPool;
    }

    public final void dump(DataOutputStream dataOutputStream) {
        dataOutputStream.writeShort(this.byte_code_offset);
        dataOutputStream.writeShort(this.number_of_locals);
        int n2 = 0;
        while (n2 < this.number_of_locals) {
            this.types_of_locals[n2].dump(dataOutputStream);
            ++n2;
        }
        dataOutputStream.writeShort(this.number_of_stack_items);
        int n3 = 0;
        while (n3 < this.number_of_stack_items) {
            this.types_of_stack_items[n3].dump(dataOutputStream);
            ++n3;
        }
    }

    public final String toString() {
        int n2;
        StringBuffer stringBuffer = new StringBuffer("(offset=" + this.byte_code_offset);
        if (this.number_of_locals > 0) {
            stringBuffer.append(", locals={");
            n2 = 0;
            while (n2 < this.number_of_locals) {
                stringBuffer.append(this.types_of_locals[n2]);
                if (n2 < this.number_of_locals - 1) {
                    stringBuffer.append(", ");
                }
                ++n2;
            }
            stringBuffer.append("}");
        }
        if (this.number_of_stack_items > 0) {
            stringBuffer.append(", stack items={");
            n2 = 0;
            while (n2 < this.number_of_stack_items) {
                stringBuffer.append(this.types_of_stack_items[n2]);
                if (n2 < this.number_of_stack_items - 1) {
                    stringBuffer.append(", ");
                }
                ++n2;
            }
            stringBuffer.append("}");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public void setByteCodeOffset(int n2) {
        this.byte_code_offset = n2;
    }

    public int getByteCodeOffset() {
        return this.byte_code_offset;
    }

    public void setNumberOfLocals(int n2) {
        this.number_of_locals = n2;
    }

    public int getNumberOfLocals() {
        return this.number_of_locals;
    }

    public void setTypesOfLocals(StackMapType[] stackMapTypeArray) {
        this.types_of_locals = stackMapTypeArray;
    }

    public StackMapType[] getTypesOfLocals() {
        return this.types_of_locals;
    }

    public void setNumberOfStackItems(int n2) {
        this.number_of_stack_items = n2;
    }

    public int getNumberOfStackItems() {
        return this.number_of_stack_items;
    }

    public void setTypesOfStackItems(StackMapType[] stackMapTypeArray) {
        this.types_of_stack_items = stackMapTypeArray;
    }

    public StackMapType[] getTypesOfStackItems() {
        return this.types_of_stack_items;
    }

    public StackMapEntry copy() {
        try {
            return (StackMapEntry)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void accept(Visitor visitor) {
        visitor.visitStackMapEntry(this);
    }

    public final ConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public final void setConstantPool(ConstantPool constantPool) {
        this.constant_pool = constantPool;
    }
}

