/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.StackMapEntry;
import org.apache.bcel.classfile.Visitor;

public final class StackMap
extends Attribute
implements Node {
    private int map_length;
    private StackMapEntry[] map;

    public StackMap(int n2, int n3, StackMapEntry[] stackMapEntryArray, ConstantPool constantPool) {
        super((byte)11, n2, n3, constantPool);
        this.setStackMap(stackMapEntryArray);
    }

    StackMap(int n2, int n3, DataInputStream dataInputStream, ConstantPool constantPool) {
        this(n2, n3, (StackMapEntry[])null, constantPool);
        this.map_length = dataInputStream.readUnsignedShort();
        this.map = new StackMapEntry[this.map_length];
        int n4 = 0;
        while (n4 < this.map_length) {
            this.map[n4] = new StackMapEntry(dataInputStream, constantPool);
            ++n4;
        }
    }

    public final void dump(DataOutputStream dataOutputStream) {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.map_length);
        int n2 = 0;
        while (n2 < this.map_length) {
            this.map[n2].dump(dataOutputStream);
            ++n2;
        }
    }

    public final StackMapEntry[] getStackMap() {
        return this.map;
    }

    public final void setStackMap(StackMapEntry[] stackMapEntryArray) {
        this.map = stackMapEntryArray;
        this.map_length = stackMapEntryArray == null ? 0 : stackMapEntryArray.length;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer("StackMap(");
        int n2 = 0;
        while (n2 < this.map_length) {
            stringBuffer.append(this.map[n2].toString());
            if (n2 < this.map_length - 1) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public Attribute copy(ConstantPool constantPool) {
        StackMap stackMap = (StackMap)this.clone();
        stackMap.map = new StackMapEntry[this.map_length];
        int n2 = 0;
        while (n2 < this.map_length) {
            stackMap.map[n2] = this.map[n2].copy();
            ++n2;
        }
        stackMap.constant_pool = constantPool;
        return stackMap;
    }

    public void accept(Visitor visitor) {
        visitor.visitStackMap(this);
    }

    public final int getMapLength() {
        return this.map_length;
    }
}

