/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Visitor;

public final class SourceFile
extends Attribute {
    private int sourcefile_index;

    public SourceFile(SourceFile sourceFile) {
        this(sourceFile.getNameIndex(), sourceFile.getLength(), sourceFile.getSourceFileIndex(), sourceFile.getConstantPool());
    }

    SourceFile(int n2, int n3, DataInputStream dataInputStream, ConstantPool constantPool) {
        this(n2, n3, dataInputStream.readUnsignedShort(), constantPool);
    }

    public SourceFile(int n2, int n3, int n4, ConstantPool constantPool) {
        super((byte)0, n2, n3, constantPool);
        this.sourcefile_index = n4;
    }

    public void accept(Visitor visitor) {
        visitor.visitSourceFile(this);
    }

    public final void dump(DataOutputStream dataOutputStream) {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.sourcefile_index);
    }

    public final int getSourceFileIndex() {
        return this.sourcefile_index;
    }

    public final void setSourceFileIndex(int n2) {
        this.sourcefile_index = n2;
    }

    public final String getSourceFileName() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.constant_pool.getConstant(this.sourcefile_index, (byte)1);
        return constantUtf8.getBytes();
    }

    public final String toString() {
        return "SourceFile(" + this.getSourceFileName() + ")";
    }

    public Attribute copy(ConstantPool constantPool) {
        return (SourceFile)this.clone();
    }
}

