/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.Visitor;

public class LocalVariableTable
extends Attribute {
    private int local_variable_table_length;
    private LocalVariable[] local_variable_table;

    public LocalVariableTable(LocalVariableTable localVariableTable) {
        this(localVariableTable.getNameIndex(), localVariableTable.getLength(), localVariableTable.getLocalVariableTable(), localVariableTable.getConstantPool());
    }

    public LocalVariableTable(int n2, int n3, LocalVariable[] localVariableArray, ConstantPool constantPool) {
        super((byte)5, n2, n3, constantPool);
        this.setLocalVariableTable(localVariableArray);
    }

    LocalVariableTable(int n2, int n3, DataInputStream dataInputStream, ConstantPool constantPool) {
        this(n2, n3, (LocalVariable[])null, constantPool);
        this.local_variable_table_length = dataInputStream.readUnsignedShort();
        this.local_variable_table = new LocalVariable[this.local_variable_table_length];
        int n4 = 0;
        while (n4 < this.local_variable_table_length) {
            this.local_variable_table[n4] = new LocalVariable(dataInputStream, constantPool);
            ++n4;
        }
    }

    public void accept(Visitor visitor) {
        visitor.visitLocalVariableTable(this);
    }

    public final void dump(DataOutputStream dataOutputStream) {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.local_variable_table_length);
        int n2 = 0;
        while (n2 < this.local_variable_table_length) {
            this.local_variable_table[n2].dump(dataOutputStream);
            ++n2;
        }
    }

    public final LocalVariable[] getLocalVariableTable() {
        return this.local_variable_table;
    }

    public final LocalVariable getLocalVariable(int n2) {
        int n3 = 0;
        while (n3 < this.local_variable_table_length) {
            if (this.local_variable_table[n3].getIndex() == n2) {
                return this.local_variable_table[n3];
            }
            ++n3;
        }
        return null;
    }

    public final void setLocalVariableTable(LocalVariable[] localVariableArray) {
        this.local_variable_table = localVariableArray;
        this.local_variable_table_length = localVariableArray == null ? 0 : localVariableArray.length;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = 0;
        while (n2 < this.local_variable_table_length) {
            stringBuffer.append(this.local_variable_table[n2].toString());
            if (n2 < this.local_variable_table_length - 1) {
                stringBuffer.append('\n');
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public Attribute copy(ConstantPool constantPool) {
        LocalVariableTable localVariableTable = (LocalVariableTable)this.clone();
        localVariableTable.local_variable_table = new LocalVariable[this.local_variable_table_length];
        int n2 = 0;
        while (n2 < this.local_variable_table_length) {
            localVariableTable.local_variable_table[n2] = this.local_variable_table[n2].copy();
            ++n2;
        }
        localVariableTable.constant_pool = constantPool;
        return localVariableTable;
    }

    public final int getTableLength() {
        return this.local_variable_table_length;
    }
}

