/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;

public final class LocalVariable
implements Cloneable,
Constants,
Node {
    private int start_pc;
    private int length;
    private int name_index;
    private int signature_index;
    private int index;
    private ConstantPool constant_pool;

    public LocalVariable(LocalVariable localVariable) {
        this(localVariable.getStartPC(), localVariable.getLength(), localVariable.getNameIndex(), localVariable.getSignatureIndex(), localVariable.getIndex(), localVariable.getConstantPool());
    }

    LocalVariable(DataInputStream dataInputStream, ConstantPool constantPool) {
        this(dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort(), constantPool);
    }

    public LocalVariable(int n2, int n3, int n4, int n5, int n6, ConstantPool constantPool) {
        this.start_pc = n2;
        this.length = n3;
        this.name_index = n4;
        this.signature_index = n5;
        this.index = n6;
        this.constant_pool = constantPool;
    }

    public void accept(Visitor visitor) {
        visitor.visitLocalVariable(this);
    }

    public final void dump(DataOutputStream dataOutputStream) {
        dataOutputStream.writeShort(this.start_pc);
        dataOutputStream.writeShort(this.length);
        dataOutputStream.writeShort(this.name_index);
        dataOutputStream.writeShort(this.signature_index);
        dataOutputStream.writeShort(this.index);
    }

    public final ConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public final int getLength() {
        return this.length;
    }

    public final String getName() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.constant_pool.getConstant(this.name_index, (byte)1);
        return constantUtf8.getBytes();
    }

    public final int getNameIndex() {
        return this.name_index;
    }

    public final String getSignature() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.constant_pool.getConstant(this.signature_index, (byte)1);
        return constantUtf8.getBytes();
    }

    public final int getSignatureIndex() {
        return this.signature_index;
    }

    public final int getIndex() {
        return this.index;
    }

    public final int getStartPC() {
        return this.start_pc;
    }

    public final void setConstantPool(ConstantPool constantPool) {
        this.constant_pool = constantPool;
    }

    public final void setLength(int n2) {
        this.length = n2;
    }

    public final void setNameIndex(int n2) {
        this.name_index = n2;
    }

    public final void setSignatureIndex(int n2) {
        this.signature_index = n2;
    }

    public final void setIndex(int n2) {
        this.index = n2;
    }

    public final void setStartPC(int n2) {
        this.start_pc = n2;
    }

    public final String toString() {
        String string = this.getName();
        String string2 = Utility.signatureToString(this.getSignature());
        return "LocalVariable(start_pc = " + this.start_pc + ", length = " + this.length + ", index = " + this.index + ":" + string2 + " " + string + ")";
    }

    public LocalVariable copy() {
        try {
            return (LocalVariable)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

