/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.Visitor;

public final class LineNumber
implements Cloneable,
Node {
    private int start_pc;
    private int line_number;

    public LineNumber(LineNumber lineNumber) {
        this(lineNumber.getStartPC(), lineNumber.getLineNumber());
    }

    LineNumber(DataInputStream dataInputStream) {
        this(dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort());
    }

    public LineNumber(int n2, int n3) {
        this.start_pc = n2;
        this.line_number = n3;
    }

    public void accept(Visitor visitor) {
        visitor.visitLineNumber(this);
    }

    public final void dump(DataOutputStream dataOutputStream) {
        dataOutputStream.writeShort(this.start_pc);
        dataOutputStream.writeShort(this.line_number);
    }

    public final int getLineNumber() {
        return this.line_number;
    }

    public final int getStartPC() {
        return this.start_pc;
    }

    public final void setLineNumber(int n2) {
        this.line_number = n2;
    }

    public final void setStartPC(int n2) {
        this.start_pc = n2;
    }

    public final String toString() {
        return "LineNumber(" + this.start_pc + ", " + this.line_number + ")";
    }

    public LineNumber copy() {
        try {
            return (LineNumber)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

