/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.InnerClass;
import org.apache.bcel.classfile.Visitor;

public final class InnerClasses
extends Attribute {
    private InnerClass[] inner_classes;
    private int number_of_classes;

    public InnerClasses(InnerClasses innerClasses) {
        this(innerClasses.getNameIndex(), innerClasses.getLength(), innerClasses.getInnerClasses(), innerClasses.getConstantPool());
    }

    public InnerClasses(int n2, int n3, InnerClass[] innerClassArray, ConstantPool constantPool) {
        super((byte)6, n2, n3, constantPool);
        this.setInnerClasses(innerClassArray);
    }

    InnerClasses(int n2, int n3, DataInputStream dataInputStream, ConstantPool constantPool) {
        this(n2, n3, (InnerClass[])null, constantPool);
        this.number_of_classes = dataInputStream.readUnsignedShort();
        this.inner_classes = new InnerClass[this.number_of_classes];
        int n4 = 0;
        while (n4 < this.number_of_classes) {
            this.inner_classes[n4] = new InnerClass(dataInputStream);
            ++n4;
        }
    }

    public void accept(Visitor visitor) {
        visitor.visitInnerClasses(this);
    }

    public final void dump(DataOutputStream dataOutputStream) {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.number_of_classes);
        int n2 = 0;
        while (n2 < this.number_of_classes) {
            this.inner_classes[n2].dump(dataOutputStream);
            ++n2;
        }
    }

    public final InnerClass[] getInnerClasses() {
        return this.inner_classes;
    }

    public final void setInnerClasses(InnerClass[] innerClassArray) {
        this.inner_classes = innerClassArray;
        this.number_of_classes = innerClassArray == null ? 0 : innerClassArray.length;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < this.number_of_classes) {
            stringBuffer.append(this.inner_classes[n2].toString(this.constant_pool) + "\n");
            ++n2;
        }
        return stringBuffer.toString();
    }

    public Attribute copy(ConstantPool constantPool) {
        InnerClasses innerClasses = (InnerClasses)this.clone();
        innerClasses.inner_classes = new InnerClass[this.number_of_classes];
        int n2 = 0;
        while (n2 < this.number_of_classes) {
            innerClasses.inner_classes[n2] = this.inner_classes[n2].copy();
            ++n2;
        }
        innerClasses.constant_pool = constantPool;
        return innerClasses;
    }
}

