/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;

public final class ExceptionTable
extends Attribute {
    private int number_of_exceptions;
    private int[] exception_index_table;

    public ExceptionTable(ExceptionTable exceptionTable) {
        this(exceptionTable.getNameIndex(), exceptionTable.getLength(), exceptionTable.getExceptionIndexTable(), exceptionTable.getConstantPool());
    }

    public ExceptionTable(int n2, int n3, int[] nArray, ConstantPool constantPool) {
        super((byte)3, n2, n3, constantPool);
        this.setExceptionIndexTable(nArray);
    }

    ExceptionTable(int n2, int n3, DataInputStream dataInputStream, ConstantPool constantPool) {
        this(n2, n3, (int[])null, constantPool);
        this.number_of_exceptions = dataInputStream.readUnsignedShort();
        this.exception_index_table = new int[this.number_of_exceptions];
        int n4 = 0;
        while (n4 < this.number_of_exceptions) {
            this.exception_index_table[n4] = dataInputStream.readUnsignedShort();
            ++n4;
        }
    }

    public void accept(Visitor visitor) {
        visitor.visitExceptionTable(this);
    }

    public final void dump(DataOutputStream dataOutputStream) {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.number_of_exceptions);
        int n2 = 0;
        while (n2 < this.number_of_exceptions) {
            dataOutputStream.writeShort(this.exception_index_table[n2]);
            ++n2;
        }
    }

    public final int[] getExceptionIndexTable() {
        return this.exception_index_table;
    }

    public final int getNumberOfExceptions() {
        return this.number_of_exceptions;
    }

    public final String[] getExceptionNames() {
        String[] stringArray = new String[this.number_of_exceptions];
        int n2 = 0;
        while (n2 < this.number_of_exceptions) {
            stringArray[n2] = this.constant_pool.getConstantString(this.exception_index_table[n2], (byte)7).replace('/', '.');
            ++n2;
        }
        return stringArray;
    }

    public final void setExceptionIndexTable(int[] nArray) {
        this.exception_index_table = nArray;
        this.number_of_exceptions = nArray == null ? 0 : nArray.length;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = 0;
        while (n2 < this.number_of_exceptions) {
            String string = this.constant_pool.getConstantString(this.exception_index_table[n2], (byte)7);
            stringBuffer.append(Utility.compactClassName(string, false));
            if (n2 < this.number_of_exceptions - 1) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public Attribute copy(ConstantPool constantPool) {
        ExceptionTable exceptionTable = (ExceptionTable)this.clone();
        exceptionTable.exception_index_table = (int[])this.exception_index_table.clone();
        exceptionTable.constant_pool = constantPool;
        return exceptionTable;
    }
}

