/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.util.Stack;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantInterfaceMethodref;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantMethodref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.ConstantValue;
import org.apache.bcel.classfile.Deprecated;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.InnerClass;
import org.apache.bcel.classfile.InnerClasses;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumber;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.SourceFile;
import org.apache.bcel.classfile.StackMap;
import org.apache.bcel.classfile.StackMapEntry;
import org.apache.bcel.classfile.Synthetic;
import org.apache.bcel.classfile.Unknown;
import org.apache.bcel.classfile.Visitor;

public class DescendingVisitor
implements Visitor {
    private JavaClass clazz;
    private Visitor visitor;
    private Stack stack = new Stack();

    public Object predecessor() {
        return this.predecessor(0);
    }

    public Object predecessor(int n2) {
        int n3 = this.stack.size();
        if (n3 < 2 || n2 < 0) {
            return null;
        }
        return this.stack.elementAt(n3 - (n2 + 2));
    }

    public Object current() {
        return this.stack.peek();
    }

    public DescendingVisitor(JavaClass javaClass, Visitor visitor) {
        this.clazz = javaClass;
        this.visitor = visitor;
    }

    public void visit() {
        this.clazz.accept(this);
    }

    public void visitJavaClass(JavaClass javaClass) {
        this.stack.push(javaClass);
        javaClass.accept(this.visitor);
        Field[] fieldArray = javaClass.getFields();
        int n2 = 0;
        while (n2 < fieldArray.length) {
            fieldArray[n2].accept(this);
            ++n2;
        }
        Method[] methodArray = javaClass.getMethods();
        int n3 = 0;
        while (n3 < methodArray.length) {
            methodArray[n3].accept(this);
            ++n3;
        }
        Attribute[] attributeArray = javaClass.getAttributes();
        int n4 = 0;
        while (n4 < attributeArray.length) {
            attributeArray[n4].accept(this);
            ++n4;
        }
        javaClass.getConstantPool().accept(this);
        this.stack.pop();
    }

    public void visitField(Field field) {
        this.stack.push(field);
        field.accept(this.visitor);
        Attribute[] attributeArray = field.getAttributes();
        int n2 = 0;
        while (n2 < attributeArray.length) {
            attributeArray[n2].accept(this);
            ++n2;
        }
        this.stack.pop();
    }

    public void visitConstantValue(ConstantValue constantValue) {
        this.stack.push(constantValue);
        constantValue.accept(this.visitor);
        this.stack.pop();
    }

    public void visitMethod(Method method) {
        this.stack.push(method);
        method.accept(this.visitor);
        Attribute[] attributeArray = method.getAttributes();
        int n2 = 0;
        while (n2 < attributeArray.length) {
            attributeArray[n2].accept(this);
            ++n2;
        }
        this.stack.pop();
    }

    public void visitExceptionTable(ExceptionTable exceptionTable) {
        this.stack.push(exceptionTable);
        exceptionTable.accept(this.visitor);
        this.stack.pop();
    }

    public void visitCode(Code code) {
        this.stack.push(code);
        code.accept(this.visitor);
        CodeException[] codeExceptionArray = code.getExceptionTable();
        int n2 = 0;
        while (n2 < codeExceptionArray.length) {
            codeExceptionArray[n2].accept(this);
            ++n2;
        }
        Attribute[] attributeArray = code.getAttributes();
        int n3 = 0;
        while (n3 < attributeArray.length) {
            attributeArray[n3].accept(this);
            ++n3;
        }
        this.stack.pop();
    }

    public void visitCodeException(CodeException codeException) {
        this.stack.push(codeException);
        codeException.accept(this.visitor);
        this.stack.pop();
    }

    public void visitLineNumberTable(LineNumberTable lineNumberTable) {
        this.stack.push(lineNumberTable);
        lineNumberTable.accept(this.visitor);
        LineNumber[] lineNumberArray = lineNumberTable.getLineNumberTable();
        int n2 = 0;
        while (n2 < lineNumberArray.length) {
            lineNumberArray[n2].accept(this);
            ++n2;
        }
        this.stack.pop();
    }

    public void visitLineNumber(LineNumber lineNumber) {
        this.stack.push(lineNumber);
        lineNumber.accept(this.visitor);
        this.stack.pop();
    }

    public void visitLocalVariableTable(LocalVariableTable localVariableTable) {
        this.stack.push(localVariableTable);
        localVariableTable.accept(this.visitor);
        LocalVariable[] localVariableArray = localVariableTable.getLocalVariableTable();
        int n2 = 0;
        while (n2 < localVariableArray.length) {
            localVariableArray[n2].accept(this);
            ++n2;
        }
        this.stack.pop();
    }

    public void visitStackMap(StackMap stackMap) {
        this.stack.push(stackMap);
        stackMap.accept(this.visitor);
        StackMapEntry[] stackMapEntryArray = stackMap.getStackMap();
        int n2 = 0;
        while (n2 < stackMapEntryArray.length) {
            stackMapEntryArray[n2].accept(this);
            ++n2;
        }
        this.stack.pop();
    }

    public void visitStackMapEntry(StackMapEntry stackMapEntry) {
        this.stack.push(stackMapEntry);
        stackMapEntry.accept(this.visitor);
        this.stack.pop();
    }

    public void visitLocalVariable(LocalVariable localVariable) {
        this.stack.push(localVariable);
        localVariable.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantPool(ConstantPool constantPool) {
        this.stack.push(constantPool);
        constantPool.accept(this.visitor);
        Constant[] constantArray = constantPool.getConstantPool();
        int n2 = 1;
        while (n2 < constantArray.length) {
            if (constantArray[n2] != null) {
                constantArray[n2].accept(this);
            }
            ++n2;
        }
        this.stack.pop();
    }

    public void visitConstantClass(ConstantClass constantClass) {
        this.stack.push(constantClass);
        constantClass.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantDouble(ConstantDouble constantDouble) {
        this.stack.push(constantDouble);
        constantDouble.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantFieldref(ConstantFieldref constantFieldref) {
        this.stack.push(constantFieldref);
        constantFieldref.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantFloat(ConstantFloat constantFloat) {
        this.stack.push(constantFloat);
        constantFloat.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantInteger(ConstantInteger constantInteger) {
        this.stack.push(constantInteger);
        constantInteger.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantInterfaceMethodref(ConstantInterfaceMethodref constantInterfaceMethodref) {
        this.stack.push(constantInterfaceMethodref);
        constantInterfaceMethodref.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantLong(ConstantLong constantLong) {
        this.stack.push(constantLong);
        constantLong.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantMethodref(ConstantMethodref constantMethodref) {
        this.stack.push(constantMethodref);
        constantMethodref.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantNameAndType(ConstantNameAndType constantNameAndType) {
        this.stack.push(constantNameAndType);
        constantNameAndType.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantString(ConstantString constantString) {
        this.stack.push(constantString);
        constantString.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantUtf8(ConstantUtf8 constantUtf8) {
        this.stack.push(constantUtf8);
        constantUtf8.accept(this.visitor);
        this.stack.pop();
    }

    public void visitInnerClasses(InnerClasses innerClasses) {
        this.stack.push(innerClasses);
        innerClasses.accept(this.visitor);
        InnerClass[] innerClassArray = innerClasses.getInnerClasses();
        int n2 = 0;
        while (n2 < innerClassArray.length) {
            innerClassArray[n2].accept(this);
            ++n2;
        }
        this.stack.pop();
    }

    public void visitInnerClass(InnerClass innerClass) {
        this.stack.push(innerClass);
        innerClass.accept(this.visitor);
        this.stack.pop();
    }

    public void visitDeprecated(Deprecated deprecated) {
        this.stack.push(deprecated);
        deprecated.accept(this.visitor);
        this.stack.pop();
    }

    public void visitSourceFile(SourceFile sourceFile) {
        this.stack.push(sourceFile);
        sourceFile.accept(this.visitor);
        this.stack.pop();
    }

    public void visitSynthetic(Synthetic synthetic) {
        this.stack.push(synthetic);
        synthetic.accept(this.visitor);
        this.stack.pop();
    }

    public void visitUnknown(Unknown unknown) {
        this.stack.push(unknown);
        unknown.accept(this.visitor);
        this.stack.pop();
    }
}

