/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Visitor;

public final class ConstantValue
extends Attribute {
    private int constantvalue_index;

    public ConstantValue(ConstantValue constantValue) {
        this(constantValue.getNameIndex(), constantValue.getLength(), constantValue.getConstantValueIndex(), constantValue.getConstantPool());
    }

    ConstantValue(int n2, int n3, DataInputStream dataInputStream, ConstantPool constantPool) {
        this(n2, n3, dataInputStream.readUnsignedShort(), constantPool);
    }

    public ConstantValue(int n2, int n3, int n4, ConstantPool constantPool) {
        super((byte)1, n2, n3, constantPool);
        this.constantvalue_index = n4;
    }

    public void accept(Visitor visitor) {
        visitor.visitConstantValue(this);
    }

    public final void dump(DataOutputStream dataOutputStream) {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.constantvalue_index);
    }

    public final int getConstantValueIndex() {
        return this.constantvalue_index;
    }

    public final void setConstantValueIndex(int n2) {
        this.constantvalue_index = n2;
    }

    public final String toString() {
        String string;
        Constant constant = this.constant_pool.getConstant(this.constantvalue_index);
        switch (constant.getTag()) {
            case 5: {
                string = "" + ((ConstantLong)constant).getBytes();
                break;
            }
            case 4: {
                string = "" + ((ConstantFloat)constant).getBytes();
                break;
            }
            case 6: {
                string = "" + ((ConstantDouble)constant).getBytes();
                break;
            }
            case 3: {
                string = "" + ((ConstantInteger)constant).getBytes();
                break;
            }
            case 8: {
                int n2 = ((ConstantString)constant).getStringIndex();
                constant = this.constant_pool.getConstant(n2, (byte)1);
                string = "\"" + ConstantValue.convertString(((ConstantUtf8)constant).getBytes()) + "\"";
                break;
            }
            default: {
                throw new InternalError("Type of ConstValue invalid: " + constant);
            }
        }
        return string;
    }

    private static final String convertString(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < cArray.length) {
            switch (cArray[n2]) {
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    break;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    break;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    break;
                }
                default: {
                    stringBuffer.append(cArray[n2]);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public Attribute copy(ConstantPool constantPool) {
        ConstantValue constantValue = (ConstantValue)this.clone();
        constantValue.constant_pool = constantPool;
        return constantValue;
    }
}

