/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantObject;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Visitor;

public final class ConstantString
extends Constant
implements ConstantObject {
    private int string_index;

    public ConstantString(ConstantString constantString) {
        this(constantString.getStringIndex());
    }

    ConstantString(DataInputStream dataInputStream) {
        this(dataInputStream.readUnsignedShort());
    }

    public ConstantString(int n2) {
        super((byte)8);
        this.string_index = n2;
    }

    public void accept(Visitor visitor) {
        visitor.visitConstantString(this);
    }

    public final void dump(DataOutputStream dataOutputStream) {
        dataOutputStream.writeByte(this.tag);
        dataOutputStream.writeShort(this.string_index);
    }

    public final int getStringIndex() {
        return this.string_index;
    }

    public final void setStringIndex(int n2) {
        this.string_index = n2;
    }

    public final String toString() {
        return super.toString() + "(string_index = " + this.string_index + ")";
    }

    public Object getConstantValue(ConstantPool constantPool) {
        Constant constant = constantPool.getConstant(this.string_index, (byte)1);
        return ((ConstantUtf8)constant).getBytes();
    }

    public String getBytes(ConstantPool constantPool) {
        return (String)this.getConstantValue(constantPool);
    }
}

