/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;

public class ConstantPool
implements Cloneable,
Node {
    private int constant_pool_count;
    private Constant[] constant_pool;

    public ConstantPool(Constant[] constantArray) {
        this.setConstantPool(constantArray);
    }

    ConstantPool(DataInputStream dataInputStream) {
        this.constant_pool_count = dataInputStream.readUnsignedShort();
        this.constant_pool = new Constant[this.constant_pool_count];
        int n2 = 1;
        while (n2 < this.constant_pool_count) {
            this.constant_pool[n2] = Constant.readConstant(dataInputStream);
            byte by2 = this.constant_pool[n2].getTag();
            if (by2 == 6 || by2 == 5) {
                ++n2;
            }
            ++n2;
        }
    }

    public void accept(Visitor visitor) {
        visitor.visitConstantPool(this);
    }

    public String constantToString(Constant constant) {
        String string;
        byte by2 = constant.getTag();
        switch (by2) {
            case 7: {
                int n2 = ((ConstantClass)constant).getNameIndex();
                constant = this.getConstant(n2, (byte)1);
                string = Utility.compactClassName(((ConstantUtf8)constant).getBytes(), false);
                break;
            }
            case 8: {
                int n3 = ((ConstantString)constant).getStringIndex();
                constant = this.getConstant(n3, (byte)1);
                string = "\"" + ConstantPool.escape(((ConstantUtf8)constant).getBytes()) + "\"";
                break;
            }
            case 1: {
                string = ((ConstantUtf8)constant).getBytes();
                break;
            }
            case 6: {
                string = "" + ((ConstantDouble)constant).getBytes();
                break;
            }
            case 4: {
                string = "" + ((ConstantFloat)constant).getBytes();
                break;
            }
            case 5: {
                string = "" + ((ConstantLong)constant).getBytes();
                break;
            }
            case 3: {
                string = "" + ((ConstantInteger)constant).getBytes();
                break;
            }
            case 12: {
                string = this.constantToString(((ConstantNameAndType)constant).getNameIndex(), (byte)1) + " " + this.constantToString(((ConstantNameAndType)constant).getSignatureIndex(), (byte)1);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                string = this.constantToString(((ConstantCP)constant).getClassIndex(), (byte)7) + "." + this.constantToString(((ConstantCP)constant).getNameAndTypeIndex(), (byte)12);
                break;
            }
            default: {
                throw new RuntimeException("Unknown constant type " + by2);
            }
        }
        return string;
    }

    private static final String escape(String string) {
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2 + 5);
        char[] cArray = string.toCharArray();
        int n3 = 0;
        while (n3 < n2) {
            switch (cArray[n3]) {
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    break;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    break;
                }
                default: {
                    stringBuffer.append(cArray[n3]);
                }
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    public String constantToString(int n2, byte by2) {
        Constant constant = this.getConstant(n2, by2);
        return this.constantToString(constant);
    }

    public void dump(DataOutputStream dataOutputStream) {
        dataOutputStream.writeShort(this.constant_pool_count);
        int n2 = 1;
        while (n2 < this.constant_pool_count) {
            if (this.constant_pool[n2] != null) {
                this.constant_pool[n2].dump(dataOutputStream);
            }
            ++n2;
        }
    }

    public Constant getConstant(int n2) {
        if (n2 >= this.constant_pool.length || n2 < 0) {
            throw new ClassFormatError("Invalid constant pool reference: " + n2 + ". Constant pool size is: " + this.constant_pool.length);
        }
        return this.constant_pool[n2];
    }

    public Constant getConstant(int n2, byte by2) {
        Constant constant = this.getConstant(n2);
        if (constant == null) {
            throw new ClassFormatError("Constant pool at index " + n2 + " is null.");
        }
        if (constant.getTag() == by2) {
            return constant;
        }
        throw new ClassFormatError("Expected class `" + Constants.CONSTANT_NAMES[by2] + "' at index " + n2 + " and got " + constant);
    }

    public Constant[] getConstantPool() {
        return this.constant_pool;
    }

    public String getConstantString(int n2, byte by2) {
        int n3;
        Constant constant = this.getConstant(n2, by2);
        switch (by2) {
            case 7: {
                n3 = ((ConstantClass)constant).getNameIndex();
                break;
            }
            case 8: {
                n3 = ((ConstantString)constant).getStringIndex();
                break;
            }
            default: {
                throw new RuntimeException("getConstantString called with illegal tag " + by2);
            }
        }
        constant = this.getConstant(n3, (byte)1);
        return ((ConstantUtf8)constant).getBytes();
    }

    public int getLength() {
        return this.constant_pool_count;
    }

    public void setConstant(int n2, Constant constant) {
        this.constant_pool[n2] = constant;
    }

    public void setConstantPool(Constant[] constantArray) {
        this.constant_pool = constantArray;
        this.constant_pool_count = constantArray == null ? 0 : constantArray.length;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 1;
        while (n2 < this.constant_pool_count) {
            stringBuffer.append(n2 + ")" + this.constant_pool[n2] + "\n");
            ++n2;
        }
        return stringBuffer.toString();
    }

    public ConstantPool copy() {
        ConstantPool constantPool = null;
        try {
            constantPool = (ConstantPool)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        constantPool.constant_pool = new Constant[this.constant_pool_count];
        int n2 = 1;
        while (n2 < this.constant_pool_count) {
            if (this.constant_pool[n2] != null) {
                constantPool.constant_pool[n2] = this.constant_pool[n2].copy();
            }
            ++n2;
        }
        return constantPool;
    }
}

