/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantObject;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Visitor;

public final class ConstantLong
extends Constant
implements ConstantObject {
    private long bytes;

    public ConstantLong(long l2) {
        super((byte)5);
        this.bytes = l2;
    }

    public ConstantLong(ConstantLong constantLong) {
        this(constantLong.getBytes());
    }

    ConstantLong(DataInputStream dataInputStream) {
        this(dataInputStream.readLong());
    }

    public void accept(Visitor visitor) {
        visitor.visitConstantLong(this);
    }

    public final void dump(DataOutputStream dataOutputStream) {
        dataOutputStream.writeByte(this.tag);
        dataOutputStream.writeLong(this.bytes);
    }

    public final long getBytes() {
        return this.bytes;
    }

    public final void setBytes(long l2) {
        this.bytes = l2;
    }

    public final String toString() {
        return super.toString() + "(bytes = " + this.bytes + ")";
    }

    public Object getConstantValue(ConstantPool constantPool) {
        return new Long(this.bytes);
    }
}

