/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantObject;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Visitor;

public final class ConstantFloat
extends Constant
implements ConstantObject {
    private float bytes;

    public ConstantFloat(float f2) {
        super((byte)4);
        this.bytes = f2;
    }

    public ConstantFloat(ConstantFloat constantFloat) {
        this(constantFloat.getBytes());
    }

    ConstantFloat(DataInputStream dataInputStream) {
        this(dataInputStream.readFloat());
    }

    public void accept(Visitor visitor) {
        visitor.visitConstantFloat(this);
    }

    public final void dump(DataOutputStream dataOutputStream) {
        dataOutputStream.writeByte(this.tag);
        dataOutputStream.writeFloat(this.bytes);
    }

    public final float getBytes() {
        return this.bytes;
    }

    public final void setBytes(float f2) {
        this.bytes = f2;
    }

    public final String toString() {
        return super.toString() + "(bytes = " + this.bytes + ")";
    }

    public Object getConstantValue(ConstantPool constantPool) {
        return new Float(this.bytes);
    }
}

