/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantObject;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Visitor;

public final class ConstantDouble
extends Constant
implements ConstantObject {
    private double bytes;

    public ConstantDouble(double d2) {
        super((byte)6);
        this.bytes = d2;
    }

    public ConstantDouble(ConstantDouble constantDouble) {
        this(constantDouble.getBytes());
    }

    ConstantDouble(DataInputStream dataInputStream) {
        this(dataInputStream.readDouble());
    }

    public void accept(Visitor visitor) {
        visitor.visitConstantDouble(this);
    }

    public final void dump(DataOutputStream dataOutputStream) {
        dataOutputStream.writeByte(this.tag);
        dataOutputStream.writeDouble(this.bytes);
    }

    public final double getBytes() {
        return this.bytes;
    }

    public final void setBytes(double d2) {
        this.bytes = d2;
    }

    public final String toString() {
        return super.toString() + "(bytes = " + this.bytes + ")";
    }

    public Object getConstantValue(ConstantPool constantPool) {
        return new Double(this.bytes);
    }
}

