/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantPool;

public abstract class ConstantCP
extends Constant {
    protected int class_index;
    protected int name_and_type_index;

    public ConstantCP(ConstantCP constantCP) {
        this(constantCP.getTag(), constantCP.getClassIndex(), constantCP.getNameAndTypeIndex());
    }

    ConstantCP(byte by2, DataInputStream dataInputStream) {
        this(by2, dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort());
    }

    protected ConstantCP(byte by2, int n2, int n3) {
        super(by2);
        this.class_index = n2;
        this.name_and_type_index = n3;
    }

    public final void dump(DataOutputStream dataOutputStream) {
        dataOutputStream.writeByte(this.tag);
        dataOutputStream.writeShort(this.class_index);
        dataOutputStream.writeShort(this.name_and_type_index);
    }

    public final int getClassIndex() {
        return this.class_index;
    }

    public final int getNameAndTypeIndex() {
        return this.name_and_type_index;
    }

    public final void setClassIndex(int n2) {
        this.class_index = n2;
    }

    public String getClass(ConstantPool constantPool) {
        return constantPool.constantToString(this.class_index, (byte)7);
    }

    public final void setNameAndTypeIndex(int n2) {
        this.name_and_type_index = n2;
    }

    public final String toString() {
        return super.toString() + "(class_index = " + this.class_index + ", name_and_type_index = " + this.name_and_type_index + ")";
    }
}

