/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantInterfaceMethodref;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantMethodref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.Visitor;

public abstract class Constant
implements Cloneable,
Node {
    protected byte tag;

    Constant(byte by2) {
        this.tag = by2;
    }

    public abstract void accept(Visitor var1);

    public abstract void dump(DataOutputStream var1);

    public final byte getTag() {
        return this.tag;
    }

    public String toString() {
        return Constants.CONSTANT_NAMES[this.tag] + "[" + this.tag + "]";
    }

    public Constant copy() {
        try {
            return (Constant)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Object clone() {
        return super.clone();
    }

    static final Constant readConstant(DataInputStream dataInputStream) {
        byte by2 = dataInputStream.readByte();
        switch (by2) {
            case 7: {
                return new ConstantClass(dataInputStream);
            }
            case 9: {
                return new ConstantFieldref(dataInputStream);
            }
            case 10: {
                return new ConstantMethodref(dataInputStream);
            }
            case 11: {
                return new ConstantInterfaceMethodref(dataInputStream);
            }
            case 8: {
                return new ConstantString(dataInputStream);
            }
            case 3: {
                return new ConstantInteger(dataInputStream);
            }
            case 4: {
                return new ConstantFloat(dataInputStream);
            }
            case 5: {
                return new ConstantLong(dataInputStream);
            }
            case 6: {
                return new ConstantDouble(dataInputStream);
            }
            case 12: {
                return new ConstantNameAndType(dataInputStream);
            }
            case 1: {
                return new ConstantUtf8(dataInputStream);
            }
        }
        throw new ClassFormatError("Invalid byte tag in constant pool: " + by2);
    }
}

