/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;

public final class CodeException
implements Cloneable,
Constants,
Node {
    private int start_pc;
    private int end_pc;
    private int handler_pc;
    private int catch_type;

    public CodeException(CodeException codeException) {
        this(codeException.getStartPC(), codeException.getEndPC(), codeException.getHandlerPC(), codeException.getCatchType());
    }

    CodeException(DataInputStream dataInputStream) {
        this(dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort());
    }

    public CodeException(int n2, int n3, int n4, int n5) {
        this.start_pc = n2;
        this.end_pc = n3;
        this.handler_pc = n4;
        this.catch_type = n5;
    }

    public void accept(Visitor visitor) {
        visitor.visitCodeException(this);
    }

    public final void dump(DataOutputStream dataOutputStream) {
        dataOutputStream.writeShort(this.start_pc);
        dataOutputStream.writeShort(this.end_pc);
        dataOutputStream.writeShort(this.handler_pc);
        dataOutputStream.writeShort(this.catch_type);
    }

    public final int getCatchType() {
        return this.catch_type;
    }

    public final int getEndPC() {
        return this.end_pc;
    }

    public final int getHandlerPC() {
        return this.handler_pc;
    }

    public final int getStartPC() {
        return this.start_pc;
    }

    public final void setCatchType(int n2) {
        this.catch_type = n2;
    }

    public final void setEndPC(int n2) {
        this.end_pc = n2;
    }

    public final void setHandlerPC(int n2) {
        this.handler_pc = n2;
    }

    public final void setStartPC(int n2) {
        this.start_pc = n2;
    }

    public final String toString() {
        return "CodeException(start_pc = " + this.start_pc + ", end_pc = " + this.end_pc + ", handler_pc = " + this.handler_pc + ", catch_type = " + this.catch_type + ")";
    }

    public final String toString(ConstantPool constantPool, boolean bl2) {
        String string = this.catch_type == 0 ? "<Any exception>(0)" : Utility.compactClassName(constantPool.getConstantString(this.catch_type, (byte)7), false) + (bl2 ? "(" + this.catch_type + ")" : "");
        return this.start_pc + "\t" + this.end_pc + "\t" + this.handler_pc + "\t" + string;
    }

    public final String toString(ConstantPool constantPool) {
        return this.toString(constantPool, true);
    }

    public CodeException copy() {
        try {
            return (CodeException)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

