/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;

public final class Code
extends Attribute {
    private int max_stack;
    private int max_locals;
    private int code_length;
    private byte[] code;
    private int exception_table_length;
    private CodeException[] exception_table;
    private int attributes_count;
    private Attribute[] attributes;

    public Code(Code code) {
        this(code.getNameIndex(), code.getLength(), code.getMaxStack(), code.getMaxLocals(), code.getCode(), code.getExceptionTable(), code.getAttributes(), code.getConstantPool());
    }

    Code(int n2, int n3, DataInputStream dataInputStream, ConstantPool constantPool) {
        this(n2, n3, dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort(), null, null, null, constantPool);
        this.code_length = dataInputStream.readInt();
        this.code = new byte[this.code_length];
        dataInputStream.readFully(this.code);
        this.exception_table_length = dataInputStream.readUnsignedShort();
        this.exception_table = new CodeException[this.exception_table_length];
        int n4 = 0;
        while (n4 < this.exception_table_length) {
            this.exception_table[n4] = new CodeException(dataInputStream);
            ++n4;
        }
        this.attributes_count = dataInputStream.readUnsignedShort();
        this.attributes = new Attribute[this.attributes_count];
        int n5 = 0;
        while (n5 < this.attributes_count) {
            this.attributes[n5] = Attribute.readAttribute(dataInputStream, constantPool);
            ++n5;
        }
        this.length = n3;
    }

    public Code(int n2, int n3, int n4, int n5, byte[] byArray, CodeException[] codeExceptionArray, Attribute[] attributeArray, ConstantPool constantPool) {
        super((byte)2, n2, n3, constantPool);
        this.max_stack = n4;
        this.max_locals = n5;
        this.setCode(byArray);
        this.setExceptionTable(codeExceptionArray);
        this.setAttributes(attributeArray);
    }

    public void accept(Visitor visitor) {
        visitor.visitCode(this);
    }

    public final void dump(DataOutputStream dataOutputStream) {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.max_stack);
        dataOutputStream.writeShort(this.max_locals);
        dataOutputStream.writeInt(this.code_length);
        dataOutputStream.write(this.code, 0, this.code_length);
        dataOutputStream.writeShort(this.exception_table_length);
        int n2 = 0;
        while (n2 < this.exception_table_length) {
            this.exception_table[n2].dump(dataOutputStream);
            ++n2;
        }
        dataOutputStream.writeShort(this.attributes_count);
        int n3 = 0;
        while (n3 < this.attributes_count) {
            this.attributes[n3].dump(dataOutputStream);
            ++n3;
        }
    }

    public final Attribute[] getAttributes() {
        return this.attributes;
    }

    public LineNumberTable getLineNumberTable() {
        int n2 = 0;
        while (n2 < this.attributes_count) {
            if (this.attributes[n2] instanceof LineNumberTable) {
                return (LineNumberTable)this.attributes[n2];
            }
            ++n2;
        }
        return null;
    }

    public LocalVariableTable getLocalVariableTable() {
        int n2 = 0;
        while (n2 < this.attributes_count) {
            if (this.attributes[n2] instanceof LocalVariableTable) {
                return (LocalVariableTable)this.attributes[n2];
            }
            ++n2;
        }
        return null;
    }

    public final byte[] getCode() {
        return this.code;
    }

    public final CodeException[] getExceptionTable() {
        return this.exception_table;
    }

    public final int getMaxLocals() {
        return this.max_locals;
    }

    public final int getMaxStack() {
        return this.max_stack;
    }

    private final int getInternalLength() {
        return 8 + this.code_length + 2 + 8 * this.exception_table_length + 2;
    }

    private final int calculateLength() {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.attributes_count) {
            n2 += this.attributes[n3].length + 6;
            ++n3;
        }
        return n2 + this.getInternalLength();
    }

    public final void setAttributes(Attribute[] attributeArray) {
        this.attributes = attributeArray;
        this.attributes_count = attributeArray == null ? 0 : attributeArray.length;
        this.length = this.calculateLength();
    }

    public final void setCode(byte[] byArray) {
        this.code = byArray;
        this.code_length = byArray == null ? 0 : byArray.length;
    }

    public final void setExceptionTable(CodeException[] codeExceptionArray) {
        this.exception_table = codeExceptionArray;
        this.exception_table_length = codeExceptionArray == null ? 0 : codeExceptionArray.length;
    }

    public final void setMaxLocals(int n2) {
        this.max_locals = n2;
    }

    public final void setMaxStack(int n2) {
        this.max_stack = n2;
    }

    public final String toString(boolean bl2) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer("Code(max_stack = " + this.max_stack + ", max_locals = " + this.max_locals + ", code_length = " + this.code_length + ")\n" + Utility.codeToString(this.code, this.constant_pool, 0, -1, bl2));
        if (this.exception_table_length > 0) {
            stringBuffer.append("\nException handler(s) = \nFrom\tTo\tHandler\tType\n");
            n2 = 0;
            while (n2 < this.exception_table_length) {
                stringBuffer.append(this.exception_table[n2].toString(this.constant_pool, bl2) + "\n");
                ++n2;
            }
        }
        if (this.attributes_count > 0) {
            stringBuffer.append("\nAttribute(s) = \n");
            n2 = 0;
            while (n2 < this.attributes_count) {
                stringBuffer.append(this.attributes[n2].toString() + "\n");
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    public final String toString() {
        return this.toString(true);
    }

    public Attribute copy(ConstantPool constantPool) {
        Code code = (Code)this.clone();
        code.code = (byte[])this.code.clone();
        code.constant_pool = constantPool;
        code.exception_table = new CodeException[this.exception_table_length];
        int n2 = 0;
        while (n2 < this.exception_table_length) {
            code.exception_table[n2] = this.exception_table[n2].copy();
            ++n2;
        }
        code.attributes = new Attribute[this.attributes_count];
        int n3 = 0;
        while (n3 < this.attributes_count) {
            code.attributes[n3] = this.attributes[n3].copy(constantPool);
            ++n3;
        }
        return code;
    }
}

