/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public final class ClassParser {
    private DataInputStream file;
    private ZipFile zip;
    private String file_name;
    private int class_name_index;
    private int superclass_name_index;
    private int major;
    private int minor;
    private int access_flags;
    private int[] interfaces;
    private ConstantPool constant_pool;
    private Field[] fields;
    private Method[] methods;
    private Attribute[] attributes;
    private boolean is_zip;
    private static final int BUFSIZE = 8192;

    public ClassParser(InputStream inputStream, String string) {
        this.file_name = string;
        String string2 = inputStream.getClass().getName();
        this.is_zip = string2.startsWith("java.util.zip.") || string2.startsWith("java.util.jar.");
        this.file = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(new BufferedInputStream(inputStream, 8192));
    }

    public ClassParser(String string) {
        this.is_zip = false;
        this.file_name = string;
        this.file = new DataInputStream(new BufferedInputStream(new FileInputStream(string), 8192));
    }

    public ClassParser(String string, String string2) {
        this.is_zip = true;
        this.zip = new ZipFile(string);
        ZipEntry zipEntry = this.zip.getEntry(string2);
        this.file_name = string2;
        this.file = new DataInputStream(new BufferedInputStream(this.zip.getInputStream(zipEntry), 8192));
    }

    public JavaClass parse() {
        this.readID();
        this.readVersion();
        this.readConstantPool();
        this.readClassInfo();
        this.readInterfaces();
        this.readFields();
        this.readMethods();
        this.readAttributes();
        this.file.close();
        if (this.zip != null) {
            this.zip.close();
        }
        return new JavaClass(this.class_name_index, this.superclass_name_index, this.file_name, this.major, this.minor, this.access_flags, this.constant_pool, this.interfaces, this.fields, this.methods, this.attributes, this.is_zip ? (byte)3 : 2);
    }

    private final void readAttributes() {
        int n2 = this.file.readUnsignedShort();
        this.attributes = new Attribute[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.attributes[n3] = Attribute.readAttribute(this.file, this.constant_pool);
            ++n3;
        }
    }

    private final void readClassInfo() {
        this.access_flags = this.file.readUnsignedShort();
        if ((this.access_flags & 0x200) != 0) {
            this.access_flags |= 0x400;
        }
        if ((this.access_flags & 0x400) != 0 && (this.access_flags & 0x10) != 0) {
            throw new ClassFormatError("Class can't be both final and abstract");
        }
        this.class_name_index = this.file.readUnsignedShort();
        this.superclass_name_index = this.file.readUnsignedShort();
    }

    private final void readConstantPool() {
        this.constant_pool = new ConstantPool(this.file);
    }

    private final void readFields() {
        int n2 = this.file.readUnsignedShort();
        this.fields = new Field[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.fields[n3] = new Field(this.file, this.constant_pool);
            ++n3;
        }
    }

    private final void readID() {
        int n2 = -889275714;
        if (this.file.readInt() != n2) {
            throw new ClassFormatError(this.file_name + " is not a Java .class file");
        }
    }

    private final void readInterfaces() {
        int n2 = this.file.readUnsignedShort();
        this.interfaces = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.interfaces[n3] = this.file.readUnsignedShort();
            ++n3;
        }
    }

    private final void readMethods() {
        int n2 = this.file.readUnsignedShort();
        this.methods = new Method[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.methods[n3] = new Method(this.file, this.constant_pool);
            ++n3;
        }
    }

    private final void readVersion() {
        this.minor = this.file.readUnsignedShort();
        this.major = this.file.readUnsignedShort();
    }
}

