/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class PreferenceManager {
    protected Properties internal = null;
    protected Map defaults = null;
    protected String prefFileName = null;
    protected String fullName = null;
    protected static final String USER_HOME = PreferenceManager.getSystemProperty("user.home");
    protected static final String USER_DIR = PreferenceManager.getSystemProperty("user.dir");
    protected static final String FILE_SEP = PreferenceManager.getSystemProperty("file.separator");
    private static String PREF_DIR = null;

    protected static String getSystemProperty(String string) {
        try {
            return System.getProperty(string);
        }
        catch (AccessControlException accessControlException) {
            return "";
        }
    }

    public PreferenceManager(String string) {
        this(string, null);
    }

    public PreferenceManager(String string, Map map) {
        this.prefFileName = string;
        this.defaults = map;
        this.internal = new Properties();
    }

    public static void setPreferenceDirectory(String string) {
        PREF_DIR = string;
    }

    public static String getPreferenceDirectory() {
        return PREF_DIR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        FileInputStream fileInputStream = null;
        if (this.fullName != null) {
            try {
                fileInputStream = new FileInputStream(this.fullName);
            }
            catch (IOException iOException) {
                this.fullName = null;
            }
        }
        if (this.fullName == null) {
            if (PREF_DIR != null) {
                try {
                    this.fullName = PREF_DIR + FILE_SEP + this.prefFileName;
                    fileInputStream = new FileInputStream(this.fullName);
                }
                catch (IOException iOException) {
                    this.fullName = null;
                }
            }
            if (this.fullName == null) {
                try {
                    this.fullName = USER_HOME + FILE_SEP + this.prefFileName;
                    fileInputStream = new FileInputStream(this.fullName);
                }
                catch (IOException iOException) {
                    try {
                        this.fullName = USER_DIR + FILE_SEP + this.prefFileName;
                        fileInputStream = new FileInputStream(this.fullName);
                    }
                    catch (IOException iOException2) {
                        this.fullName = null;
                    }
                }
            }
        }
        if (this.fullName != null) {
            try {
                this.internal.load(fileInputStream);
            }
            finally {
                fileInputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        FileOutputStream fileOutputStream = null;
        if (this.fullName != null) {
            try {
                fileOutputStream = new FileOutputStream(this.fullName);
            }
            catch (IOException iOException) {
                this.fullName = null;
            }
        }
        if (this.fullName == null) {
            if (PREF_DIR != null) {
                try {
                    this.fullName = PREF_DIR + FILE_SEP + this.prefFileName;
                    fileOutputStream = new FileOutputStream(this.fullName);
                }
                catch (IOException iOException) {
                    this.fullName = null;
                }
            }
            if (this.fullName == null) {
                try {
                    this.fullName = USER_HOME + FILE_SEP + this.prefFileName;
                    fileOutputStream = new FileOutputStream(this.fullName);
                }
                catch (IOException iOException) {
                    this.fullName = null;
                    throw iOException;
                }
            }
        }
        try {
            this.internal.store(fileOutputStream, this.prefFileName);
        }
        finally {
            fileOutputStream.close();
        }
    }

    private Object getDefault(String string) {
        if (this.defaults != null) {
            return this.defaults.get(string);
        }
        return null;
    }

    public Rectangle getRectangle(String string) {
        Rectangle rectangle = (Rectangle)this.getDefault(string);
        String string2 = this.internal.getProperty(string);
        if (string2 == null) {
            return rectangle;
        }
        Rectangle rectangle2 = new Rectangle();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ", false);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string);
                return rectangle;
            }
            String string3 = stringTokenizer.nextToken();
            int n2 = Integer.parseInt(string3);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string);
                return rectangle;
            }
            string3 = stringTokenizer.nextToken();
            int n3 = Integer.parseInt(string3);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string);
                return rectangle;
            }
            string3 = stringTokenizer.nextToken();
            int n4 = Integer.parseInt(string3);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string);
                return rectangle;
            }
            string3 = stringTokenizer.nextToken();
            int n5 = Integer.parseInt(string3);
            rectangle2.setBounds(n2, n3, n4, n5);
            return rectangle2;
        }
        catch (NumberFormatException numberFormatException) {
            this.internal.remove(string);
            return rectangle;
        }
    }

    public Dimension getDimension(String string) {
        Dimension dimension = (Dimension)this.getDefault(string);
        String string2 = this.internal.getProperty(string);
        if (string2 == null) {
            return dimension;
        }
        Dimension dimension2 = new Dimension();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ", false);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string);
                return dimension;
            }
            String string3 = stringTokenizer.nextToken();
            int n2 = Integer.parseInt(string3);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string);
                return dimension;
            }
            string3 = stringTokenizer.nextToken();
            int n3 = Integer.parseInt(string3);
            dimension2.setSize(n2, n3);
            return dimension2;
        }
        catch (NumberFormatException numberFormatException) {
            this.internal.remove(string);
            return dimension;
        }
    }

    public Point getPoint(String string) {
        Point point = (Point)this.getDefault(string);
        String string2 = this.internal.getProperty(string);
        if (string2 == null) {
            return point;
        }
        Point point2 = new Point();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ", false);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string);
                return point;
            }
            String string3 = stringTokenizer.nextToken();
            int n2 = Integer.parseInt(string3);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string);
                return point;
            }
            string3 = stringTokenizer.nextToken();
            int n3 = Integer.parseInt(string3);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string);
                return point;
            }
            point2.setLocation(n2, n3);
            return point2;
        }
        catch (NumberFormatException numberFormatException) {
            this.internal.remove(string);
            return point;
        }
    }

    public Color getColor(String string) {
        Color color = (Color)this.getDefault(string);
        String string2 = this.internal.getProperty(string);
        if (string2 == null) {
            return color;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ", false);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string);
                return color;
            }
            String string3 = stringTokenizer.nextToken();
            int n2 = Integer.parseInt(string3);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string);
                return color;
            }
            string3 = stringTokenizer.nextToken();
            int n3 = Integer.parseInt(string3);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string);
                return color;
            }
            string3 = stringTokenizer.nextToken();
            int n4 = Integer.parseInt(string3);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string);
                return color;
            }
            string3 = stringTokenizer.nextToken();
            int n5 = Integer.parseInt(string3);
            return new Color(n2, n3, n4, n5);
        }
        catch (NumberFormatException numberFormatException) {
            this.internal.remove(string);
            return color;
        }
    }

    public Font getFont(String string) {
        Font font = (Font)this.getDefault(string);
        String string2 = this.internal.getProperty(string);
        if (string2 == null) {
            return font;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ", false);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string);
                return font;
            }
            String string3 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string);
                return font;
            }
            String string4 = stringTokenizer.nextToken();
            int n2 = Integer.parseInt(string4);
            if (!stringTokenizer.hasMoreTokens()) {
                this.internal.remove(string);
                return font;
            }
            string4 = stringTokenizer.nextToken();
            int n3 = Integer.parseInt(string4);
            return new Font(string3, n3, n2);
        }
        catch (NumberFormatException numberFormatException) {
            this.internal.remove(string);
            return font;
        }
    }

    public String getString(String string) {
        String string2 = this.internal.getProperty(string);
        if (string2 == null) {
            string2 = (String)this.getDefault(string);
        }
        return string2;
    }

    public String[] getStrings(String string) {
        int n2 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (true) {
            String string2 = this.getString(string + n2);
            ++n2;
            if (string2 == null) break;
            arrayList.add(string2);
        }
        if (arrayList.size() != 0) {
            String[] stringArray = new String[arrayList.size()];
            return arrayList.toArray(stringArray);
        }
        return (String[])this.getDefault(string);
    }

    public URL getURL(String string) {
        URL uRL = (URL)this.getDefault(string);
        String string2 = this.internal.getProperty(string);
        if (string2 == null) {
            return uRL;
        }
        URL uRL2 = null;
        try {
            uRL2 = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            this.internal.remove(string);
            return uRL;
        }
        return uRL2;
    }

    public URL[] getURLs(String string) {
        int n2 = 0;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        while (true) {
            URL uRL = this.getURL(string + n2);
            ++n2;
            if (uRL == null) break;
            arrayList.add(uRL);
        }
        if (arrayList.size() != 0) {
            URL[] uRLArray = new URL[arrayList.size()];
            return arrayList.toArray(uRLArray);
        }
        return (URL[])this.getDefault(string);
    }

    public File getFile(String string) {
        File file = (File)this.getDefault(string);
        String string2 = this.internal.getProperty(string);
        if (string2 == null) {
            return file;
        }
        File file2 = new File(string2);
        if (file2.exists()) {
            return file2;
        }
        this.internal.remove(string);
        return file;
    }

    public File[] getFiles(String string) {
        int n2 = 0;
        ArrayList<File> arrayList = new ArrayList<File>();
        while (true) {
            File file = this.getFile(string + n2);
            ++n2;
            if (file == null) break;
            arrayList.add(file);
        }
        if (arrayList.size() != 0) {
            File[] fileArray = new File[arrayList.size()];
            return arrayList.toArray(fileArray);
        }
        return (File[])this.getDefault(string);
    }

    public int getInteger(String string) {
        int n2;
        String string2;
        int n3 = 0;
        if (this.getDefault(string) != null) {
            n3 = (Integer)this.getDefault(string);
        }
        if ((string2 = this.internal.getProperty(string)) == null) {
            return n3;
        }
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.internal.remove(string);
            return n3;
        }
        return n2;
    }

    public float getFloat(String string) {
        float f2;
        String string2;
        float f3 = 0.0f;
        if (this.getDefault(string) != null) {
            f3 = ((Float)this.getDefault(string)).floatValue();
        }
        if ((string2 = this.internal.getProperty(string)) == null) {
            return f3;
        }
        try {
            f2 = Float.parseFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.setFloat(string, f3);
            return f3;
        }
        return f2;
    }

    public boolean getBoolean(String string) {
        if (this.internal.getProperty(string) != null) {
            return this.internal.getProperty(string).equals("true");
        }
        if (this.getDefault(string) != null) {
            return (Boolean)this.getDefault(string);
        }
        return false;
    }

    public void setRectangle(String string, Rectangle rectangle) {
        if (rectangle != null && !rectangle.equals(this.getDefault(string))) {
            this.internal.setProperty(string, rectangle.x + " " + rectangle.y + " " + rectangle.width + ' ' + rectangle.height);
        } else {
            this.internal.remove(string);
        }
    }

    public void setDimension(String string, Dimension dimension) {
        if (dimension != null && !dimension.equals(this.getDefault(string))) {
            this.internal.setProperty(string, dimension.width + " " + dimension.height);
        } else {
            this.internal.remove(string);
        }
    }

    public void setPoint(String string, Point point) {
        if (point != null && !point.equals(this.getDefault(string))) {
            this.internal.setProperty(string, point.x + " " + point.y);
        } else {
            this.internal.remove(string);
        }
    }

    public void setColor(String string, Color color) {
        if (color != null && !color.equals(this.getDefault(string))) {
            this.internal.setProperty(string, color.getRed() + " " + color.getGreen() + " " + color.getBlue() + " " + color.getAlpha());
        } else {
            this.internal.remove(string);
        }
    }

    public void setFont(String string, Font font) {
        if (font != null && !font.equals(this.getDefault(string))) {
            this.internal.setProperty(string, font.getName() + " " + font.getSize() + " " + font.getStyle());
        } else {
            this.internal.remove(string);
        }
    }

    public void setString(String string, String string2) {
        if (string2 != null && !string2.equals(this.getDefault(string))) {
            this.internal.setProperty(string, string2);
        } else {
            this.internal.remove(string);
        }
    }

    public void setStrings(String string, String[] stringArray) {
        Object object;
        int n2 = 0;
        if (stringArray != null) {
            object = stringArray;
            int n3 = ((String[])object).length;
            for (int i2 = 0; i2 < n3; ++i2) {
                String string2 = object[i2];
                if (string2 == null) continue;
                this.setString(string + n2, string2);
                ++n2;
            }
        }
        while ((object = this.getString(string + n2)) != null) {
            this.setString(string + n2, null);
            ++n2;
        }
    }

    public void setURL(String string, URL uRL) {
        if (uRL != null && !uRL.equals(this.getDefault(string))) {
            this.internal.setProperty(string, uRL.toString());
        } else {
            this.internal.remove(string);
        }
    }

    public void setURLs(String string, URL[] uRLArray) {
        Object object;
        int n2 = 0;
        if (uRLArray != null) {
            object = uRLArray;
            int n3 = ((URL[])object).length;
            for (int i2 = 0; i2 < n3; ++i2) {
                URL uRL = object[i2];
                if (uRL == null) continue;
                this.setURL(string + n2, uRL);
                ++n2;
            }
        }
        while ((object = this.getString(string + n2)) != null) {
            this.setString(string + n2, null);
            ++n2;
        }
    }

    public void setFile(String string, File file) {
        if (file != null && !file.equals(this.getDefault(string))) {
            this.internal.setProperty(string, file.getAbsolutePath());
        } else {
            this.internal.remove(string);
        }
    }

    public void setFiles(String string, File[] fileArray) {
        Object object;
        int n2 = 0;
        if (fileArray != null) {
            object = fileArray;
            int n3 = ((File[])object).length;
            for (int i2 = 0; i2 < n3; ++i2) {
                File file = object[i2];
                if (file == null) continue;
                this.setFile(string + n2, file);
                ++n2;
            }
        }
        while ((object = this.getString(string + n2)) != null) {
            this.setString(string + n2, null);
            ++n2;
        }
    }

    public void setInteger(String string, int n2) {
        if (this.getDefault(string) != null && (Integer)this.getDefault(string) != n2) {
            this.internal.setProperty(string, Integer.toString(n2));
        } else {
            this.internal.remove(string);
        }
    }

    public void setFloat(String string, float f2) {
        if (this.getDefault(string) != null && ((Float)this.getDefault(string)).floatValue() != f2) {
            this.internal.setProperty(string, Float.toString(f2));
        } else {
            this.internal.remove(string);
        }
    }

    public void setBoolean(String string, boolean bl2) {
        if (this.getDefault(string) != null && (Boolean)this.getDefault(string) != bl2) {
            this.internal.setProperty(string, bl2 ? "true" : "false");
        } else {
            this.internal.remove(string);
        }
    }
}

