/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassFileUtilities {
    public static final byte CONSTANT_UTF8_INFO = 1;
    public static final byte CONSTANT_INTEGER_INFO = 3;
    public static final byte CONSTANT_FLOAT_INFO = 4;
    public static final byte CONSTANT_LONG_INFO = 5;
    public static final byte CONSTANT_DOUBLE_INFO = 6;
    public static final byte CONSTANT_CLASS_INFO = 7;
    public static final byte CONSTANT_STRING_INFO = 8;
    public static final byte CONSTANT_FIELDREF_INFO = 9;
    public static final byte CONSTANT_METHODREF_INFO = 10;
    public static final byte CONSTANT_INTERFACEMETHODREF_INFO = 11;
    public static final byte CONSTANT_NAMEANDTYPE_INFO = 12;

    protected ClassFileUtilities() {
    }

    public static void main(String[] stringArray) {
        boolean bl2 = false;
        if (stringArray.length == 1 && stringArray[0].equals("-f")) {
            bl2 = true;
        } else if (stringArray.length != 0) {
            System.err.println("usage: org.apache.batik.util.ClassFileUtilities [-f]");
            System.err.println();
            System.err.println("  -f    list files that cause each jar file dependency");
            System.exit(1);
        }
        File file = new File(".");
        File file2 = null;
        String[] stringArray2 = file.list();
        for (String object5 : stringArray2) {
            if (!object5.startsWith("batik-")) continue;
            file2 = new File(object5);
            if (file2.isDirectory()) break;
            file2 = null;
        }
        if (file2 == null || !file2.isDirectory()) {
            System.out.println("Directory 'batik-xxx' not found in current directory!");
            return;
        }
        try {
            Iterator iterator;
            Object object;
            Object object22;
            Object object32;
            Object object42;
            HashMap hashMap = new HashMap();
            HashMap hashMap2 = new HashMap();
            ClassFileUtilities.collectJars(file2, hashMap2, hashMap);
            HashSet<JarFile> hashSet = new HashSet<JarFile>();
            Iterator iterator2 = hashMap2.values().iterator();
            while (iterator2.hasNext()) {
                hashSet.add(((Jar)iterator2.next()).jarFile);
            }
            for (Object object42 : hashMap.values()) {
                object32 = ClassFileUtilities.getClassDependencies(((ClassFile)object42).getInputStream(), hashSet, false);
                Iterator<Object> iterator3 = object32.iterator();
                while (iterator3.hasNext()) {
                    object22 = iterator3.next();
                    object = (ClassFile)hashMap.get(object22);
                    if (object42 == object || object == null) continue;
                    ((ClassFile)object42).deps.add(object);
                }
            }
            for (Object object42 : hashMap.values()) {
                for (Iterator<Object> iterator3 : ((ClassFile)object42).deps) {
                    object22 = (ClassFile)((Object)iterator3);
                    object = ((ClassFile)object42).jar;
                    iterator = ((ClassFile)object22).jar;
                    if (((ClassFile)object42).name.equals(((ClassFile)object22).name) || iterator == object || ((Jar)object).files.contains(((ClassFile)object22).name)) continue;
                    Integer n2 = (Integer)((Jar)object).deps.get(iterator);
                    if (n2 == null) {
                        ((Jar)object).deps.put(iterator, 1);
                        continue;
                    }
                    ((Jar)object).deps.put(iterator, n2 + 1);
                }
            }
            object42 = new ArrayList(10);
            for (Object object32 : hashMap2.values()) {
                for (Object object22 : ((Jar)object32).deps.keySet()) {
                    object = (Jar)object22;
                    iterator = new Triple();
                    ((Triple)((Object)iterator)).from = object32;
                    ((Triple)((Object)iterator)).to = object;
                    ((Triple)((Object)iterator)).count = (Integer)((Jar)object32).deps.get(object);
                    object42.add(iterator);
                }
            }
            Collections.sort(object42);
            Iterator iterator4 = object42.iterator();
            while (iterator4.hasNext()) {
                object32 = (Triple)iterator4.next();
                System.out.println(((Triple)object32).count + "," + ((Triple)object32).from.name + "," + ((Triple)object32).to.name);
                if (!bl2) continue;
                for (Object object22 : ((Triple)object32).from.files) {
                    object = (ClassFile)object22;
                    for (Integer n2 : ((ClassFile)object).deps) {
                        ClassFile classFile = (ClassFile)((Object)n2);
                        if (classFile.jar != ((Triple)object32).to || ((Triple)object32).from.files.contains(classFile.name)) continue;
                        System.out.println("\t" + ((ClassFile)object).name + " --> " + classFile.name);
                    }
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void collectJars(File file, Map map, Map map2) {
        File[] fileArray;
        for (File file2 : fileArray = file.listFiles()) {
            String string = file2.getName();
            if (string.endsWith(".jar") && file2.isFile()) {
                Jar jar = new Jar();
                jar.name = file2.getPath();
                jar.file = file2;
                jar.jarFile = new JarFile(file2);
                map.put(jar.name, jar);
                Enumeration<JarEntry> enumeration = jar.jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = enumeration.nextElement();
                    String string2 = zipEntry.getName();
                    if (!string2.endsWith(".class")) continue;
                    ClassFile classFile = new ClassFile();
                    classFile.name = string2;
                    classFile.jar = jar;
                    map2.put(jar.name + '!' + classFile.name, classFile);
                    jar.files.add(classFile);
                }
                continue;
            }
            if (!file2.isDirectory()) continue;
            ClassFileUtilities.collectJars(file2, map, map2);
        }
    }

    public static Set getClassDependencies(String string, Set set, boolean bl2) {
        return ClassFileUtilities.getClassDependencies(new FileInputStream(string), set, bl2);
    }

    public static Set getClassDependencies(InputStream inputStream, Set set, boolean bl2) {
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        ClassFileUtilities.computeClassDependencies(inputStream, set, hashSet2, hashSet, bl2);
        return hashSet;
    }

    private static void computeClassDependencies(InputStream inputStream, Set set, Set set2, Set set3, boolean bl2) {
        for (Object e2 : ClassFileUtilities.getClassDependencies(inputStream)) {
            String string = (String)e2;
            if (set2.contains(string)) continue;
            set2.add(string);
            for (Object e3 : set) {
                Object object;
                InputStream inputStream2 = null;
                String string2 = null;
                Object e4 = e3;
                if (e4 instanceof JarFile) {
                    object = (JarFile)e4;
                    String string3 = string + ".class";
                    ZipEntry zipEntry = ((JarFile)object).getEntry(string3);
                    if (zipEntry != null) {
                        string2 = ((ZipFile)object).getName() + '!' + string3;
                        inputStream2 = ((JarFile)object).getInputStream(zipEntry);
                    }
                } else {
                    string2 = (String)e4 + '/' + string + ".class";
                    object = new File(string2);
                    if (((File)object).isFile()) {
                        inputStream2 = new FileInputStream((File)object);
                    }
                }
                if (inputStream2 == null) continue;
                set3.add(string2);
                if (!bl2) continue;
                ClassFileUtilities.computeClassDependencies(inputStream2, set, set2, set3, bl2);
            }
        }
    }

    public static Set getClassDependencies(InputStream inputStream) {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        if (dataInputStream.readInt() != -889275714) {
            throw new IOException("Invalid classfile");
        }
        dataInputStream.readInt();
        int n2 = dataInputStream.readShort();
        String[] stringArray = new String[n2];
        HashSet<Integer> hashSet = new HashSet<Integer>();
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        block8: for (int i2 = 1; i2 < n2; ++i2) {
            int n3 = dataInputStream.readByte() & 0xFF;
            switch (n3) {
                case 5: 
                case 6: {
                    dataInputStream.readLong();
                    ++i2;
                    continue block8;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: {
                    dataInputStream.readInt();
                    continue block8;
                }
                case 7: {
                    hashSet.add(dataInputStream.readShort() & 0xFFFF);
                    continue block8;
                }
                case 8: {
                    dataInputStream.readShort();
                    continue block8;
                }
                case 12: {
                    dataInputStream.readShort();
                    hashSet2.add(dataInputStream.readShort() & 0xFFFF);
                    continue block8;
                }
                case 1: {
                    stringArray[i2] = dataInputStream.readUTF();
                    continue block8;
                }
                default: {
                    throw new RuntimeException("unexpected data in constant-pool:" + n3);
                }
            }
        }
        HashSet<String> hashSet3 = new HashSet<String>();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            hashSet3.add(stringArray[(Integer)iterator.next()]);
        }
        iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            hashSet3.addAll(ClassFileUtilities.getDescriptorClasses(stringArray[(Integer)iterator.next()]));
        }
        return hashSet3;
    }

    protected static Set getDescriptorClasses(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        int n2 = 0;
        char c2 = string.charAt(n2);
        switch (c2) {
            case '(': {
                StringBuffer stringBuffer;
                block14: while (true) {
                    c2 = string.charAt(++n2);
                    switch (c2) {
                        case '[': {
                            while ((c2 = string.charAt(++n2)) == '[') {
                            }
                            if (c2 != 'L') continue block14;
                        }
                        case 'L': {
                            c2 = string.charAt(++n2);
                            stringBuffer = new StringBuffer();
                            while (c2 != ';') {
                                stringBuffer.append(c2);
                                c2 = string.charAt(++n2);
                            }
                            hashSet.add(stringBuffer.toString());
                            break;
                        }
                        default: {
                            break;
                        }
                        case ')': {
                            break block14;
                        }
                    }
                }
                c2 = string.charAt(++n2);
                switch (c2) {
                    case '[': {
                        while ((c2 = string.charAt(++n2)) == '[') {
                        }
                        if (c2 != 'L') break;
                    }
                    case 'L': {
                        c2 = string.charAt(++n2);
                        stringBuffer = new StringBuffer();
                        while (c2 != ';') {
                            stringBuffer.append(c2);
                            c2 = string.charAt(++n2);
                        }
                        hashSet.add(stringBuffer.toString());
                        break;
                    }
                }
                break;
            }
            case '[': {
                while ((c2 = string.charAt(++n2)) == '[') {
                }
                if (c2 != 'L') break;
            }
            case 'L': {
                c2 = string.charAt(++n2);
                StringBuffer stringBuffer = new StringBuffer();
                while (c2 != ';') {
                    stringBuffer.append(c2);
                    c2 = string.charAt(++n2);
                }
                hashSet.add(stringBuffer.toString());
                break;
            }
        }
        return hashSet;
    }

    protected static class Triple
    implements Comparable {
        public Jar from;
        public Jar to;
        public int count;

        protected Triple() {
        }

        public int compareTo(Object object) {
            return ((Triple)object).count - this.count;
        }
    }

    protected static class Jar {
        public String name;
        public File file;
        public JarFile jarFile;
        public Map deps = new HashMap();
        public Set files = new HashSet();

        protected Jar() {
        }
    }

    protected static class ClassFile {
        public String name;
        public List deps = new ArrayList(10);
        public Jar jar;

        protected ClassFile() {
        }

        public InputStream getInputStream() {
            return this.jar.jarFile.getInputStream(this.jar.jarFile.getEntry(this.name));
        }
    }
}

