/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

import java.io.InputStream;

public class Base64DecodeStream
extends InputStream {
    InputStream src;
    private static final byte[] pem_array;
    byte[] decode_buffer = new byte[4];
    byte[] out_buffer = new byte[3];
    int out_offset = 3;
    boolean EOF = false;

    public Base64DecodeStream(InputStream inputStream) {
        this.src = inputStream;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void close() {
        this.EOF = true;
    }

    @Override
    public int available() {
        return 3 - this.out_offset;
    }

    @Override
    public int read() {
        if (this.out_offset == 3 && (this.EOF || this.getNextAtom())) {
            this.EOF = true;
            return -1;
        }
        return this.out_buffer[this.out_offset++] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        int n4;
        for (n4 = 0; n4 < n3; ++n4) {
            if (this.out_offset == 3 && (this.EOF || this.getNextAtom())) {
                this.EOF = true;
                if (n4 == 0) {
                    return -1;
                }
                return n4;
            }
            byArray[n2 + n4] = this.out_buffer[this.out_offset++];
        }
        return n4;
    }

    final boolean getNextAtom() {
        int n2 = 0;
        while (n2 != 4) {
            int n3 = this.src.read(this.decode_buffer, n2, 4 - n2);
            if (n3 == -1) {
                return true;
            }
            int n4 = n2;
            for (int i2 = n2; i2 < n2 + n3; ++i2) {
                if (this.decode_buffer[i2] == 10 || this.decode_buffer[i2] == 13 || this.decode_buffer[i2] == 32) continue;
                this.decode_buffer[n4++] = this.decode_buffer[i2];
            }
            n2 = n4;
        }
        byte by2 = pem_array[this.decode_buffer[0] & 0xFF];
        byte by3 = pem_array[this.decode_buffer[1] & 0xFF];
        byte by4 = pem_array[this.decode_buffer[2] & 0xFF];
        byte by5 = pem_array[this.decode_buffer[3] & 0xFF];
        this.out_buffer[0] = (byte)(by2 << 2 | by3 >>> 4);
        this.out_buffer[1] = (byte)(by3 << 4 | by4 >>> 2);
        this.out_buffer[2] = (byte)(by4 << 6 | by5);
        if (this.decode_buffer[3] != 61) {
            this.out_offset = 0;
        } else if (this.decode_buffer[2] == 61) {
            this.out_buffer[2] = this.out_buffer[0];
            this.out_offset = 2;
            this.EOF = true;
        } else {
            this.out_buffer[2] = this.out_buffer[1];
            this.out_buffer[1] = this.out_buffer[0];
            this.out_offset = 1;
            this.EOF = true;
        }
        return false;
    }

    static {
        int n2;
        int n3;
        pem_array = new byte[256];
        for (n3 = 0; n3 < pem_array.length; ++n3) {
            Base64DecodeStream.pem_array[n3] = -1;
        }
        n3 = 0;
        for (n2 = 65; n2 <= 90; n2 = (int)((char)(n2 + 1))) {
            Base64DecodeStream.pem_array[n2] = (byte)n3++;
        }
        for (n2 = 97; n2 <= 122; n2 = (int)((char)(n2 + 1))) {
            Base64DecodeStream.pem_array[n2] = (byte)n3++;
        }
        for (n2 = 48; n2 <= 57; n2 = (int)((char)(n2 + 1))) {
            Base64DecodeStream.pem_array[n2] = (byte)n3++;
        }
        Base64DecodeStream.pem_array[43] = (byte)n3++;
        Base64DecodeStream.pem_array[47] = (byte)n3++;
    }
}

