/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

import java.net.URL;
import java.security.Policy;
import org.apache.batik.util.BatikSecurityManager;
import org.apache.batik.util.Messages;

public class ApplicationSecurityEnforcer {
    public static final String EXCEPTION_ALIEN_SECURITY_MANAGER = "ApplicationSecurityEnforcer.message.security.exception.alien.security.manager";
    public static final String EXCEPTION_NO_POLICY_FILE = "ApplicationSecurityEnforcer.message.null.pointer.exception.no.policy.file";
    public static final String PROPERTY_JAVA_SECURITY_POLICY = "java.security.policy";
    public static final String JAR_PROTOCOL = "jar:";
    public static final String JAR_URL_FILE_SEPARATOR = "!/";
    public static final String PROPERTY_APP_DEV_BASE = "app.dev.base";
    public static final String PROPERTY_APP_JAR_BASE = "app.jar.base";
    public static final String APP_MAIN_CLASS_DIR = "classes/";
    protected Class appMainClass;
    protected String securityPolicy;
    protected String appMainClassRelativeURL;
    protected BatikSecurityManager lastSecurityManagerInstalled;

    public ApplicationSecurityEnforcer(Class clazz, String string, String string2) {
        this(clazz, string);
    }

    public ApplicationSecurityEnforcer(Class clazz, String string) {
        this.appMainClass = clazz;
        this.securityPolicy = string;
        this.appMainClassRelativeURL = clazz.getName().replace('.', '/') + ".class";
    }

    public void enforceSecurity(boolean bl2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && securityManager != this.lastSecurityManagerInstalled) {
            throw new SecurityException(Messages.getString(EXCEPTION_ALIEN_SECURITY_MANAGER));
        }
        if (bl2) {
            System.setSecurityManager(null);
            this.installSecurityManager();
        } else if (securityManager != null) {
            System.setSecurityManager(null);
            this.lastSecurityManagerInstalled = null;
        }
    }

    public URL getPolicyURL() {
        ClassLoader classLoader = this.appMainClass.getClassLoader();
        URL uRL = classLoader.getResource(this.securityPolicy);
        if (uRL == null) {
            throw new NullPointerException(Messages.formatMessage(EXCEPTION_NO_POLICY_FILE, new Object[]{this.securityPolicy}));
        }
        return uRL;
    }

    public void installSecurityManager() {
        URL uRL;
        Policy policy = Policy.getPolicy();
        BatikSecurityManager batikSecurityManager = new BatikSecurityManager();
        ClassLoader classLoader = this.appMainClass.getClassLoader();
        String string = System.getProperty(PROPERTY_JAVA_SECURITY_POLICY);
        if (string == null || string.equals("")) {
            uRL = this.getPolicyURL();
            System.setProperty(PROPERTY_JAVA_SECURITY_POLICY, uRL.toString());
        }
        if ((uRL = classLoader.getResource(this.appMainClassRelativeURL)) == null) {
            throw new RuntimeException(this.appMainClassRelativeURL);
        }
        String string2 = uRL.toString();
        if (string2.startsWith(JAR_PROTOCOL)) {
            this.setJarBase(string2);
        } else {
            this.setDevBase(string2);
        }
        System.setSecurityManager(batikSecurityManager);
        this.lastSecurityManagerInstalled = batikSecurityManager;
        policy.refresh();
        if (string == null || string.equals("")) {
            System.setProperty(PROPERTY_JAVA_SECURITY_POLICY, "");
        }
    }

    private void setJarBase(String string) {
        String string2 = System.getProperty(PROPERTY_APP_JAR_BASE);
        if (string2 == null) {
            int n2 = (string = string.substring(JAR_PROTOCOL.length())).indexOf(JAR_URL_FILE_SEPARATOR + this.appMainClassRelativeURL);
            if (n2 == -1) {
                throw new RuntimeException();
            }
            String string3 = string.substring(0, n2);
            string3 = (n2 = string3.lastIndexOf(47)) == -1 ? "" : string3.substring(0, n2);
            System.setProperty(PROPERTY_APP_JAR_BASE, string3);
        }
    }

    private void setDevBase(String string) {
        String string2 = System.getProperty(PROPERTY_APP_DEV_BASE);
        if (string2 == null) {
            int n2 = string.indexOf(APP_MAIN_CLASS_DIR + this.appMainClassRelativeURL);
            if (n2 == -1) {
                throw new RuntimeException();
            }
            String string3 = string.substring(0, n2);
            System.setProperty(PROPERTY_APP_DEV_BASE, string3);
        }
    }
}

