/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.DirectoryEntry;

public class TableDirectory {
    private int version = 0;
    private short numTables = 0;
    private short searchRange = 0;
    private short entrySelector = 0;
    private short rangeShift = 0;
    private DirectoryEntry[] entries;

    public TableDirectory(RandomAccessFile randomAccessFile) {
        int n2;
        this.version = randomAccessFile.readInt();
        this.numTables = randomAccessFile.readShort();
        this.searchRange = randomAccessFile.readShort();
        this.entrySelector = randomAccessFile.readShort();
        this.rangeShift = randomAccessFile.readShort();
        this.entries = new DirectoryEntry[this.numTables];
        for (n2 = 0; n2 < this.numTables; ++n2) {
            this.entries[n2] = new DirectoryEntry(randomAccessFile);
        }
        n2 = 1;
        while (n2 != 0) {
            n2 = 0;
            for (int i2 = 0; i2 < this.numTables - 1; ++i2) {
                if (this.entries[i2].getOffset() <= this.entries[i2 + 1].getOffset()) continue;
                DirectoryEntry directoryEntry = this.entries[i2];
                this.entries[i2] = this.entries[i2 + 1];
                this.entries[i2 + 1] = directoryEntry;
                n2 = 1;
            }
        }
    }

    public DirectoryEntry getEntry(int n2) {
        return this.entries[n2];
    }

    public DirectoryEntry getEntryByTag(int n2) {
        for (int i2 = 0; i2 < this.numTables; ++i2) {
            if (this.entries[i2].getTag() != n2) continue;
            return this.entries[i2];
        }
        return null;
    }

    public short getEntrySelector() {
        return this.entrySelector;
    }

    public short getNumTables() {
        return this.numTables;
    }

    public short getRangeShift() {
        return this.rangeShift;
    }

    public short getSearchRange() {
        return this.searchRange;
    }

    public int getVersion() {
        return this.version;
    }
}

