/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.ByteArrayInputStream;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.DirectoryEntry;
import org.apache.batik.svggen.font.table.Table;

public class LocaTable
implements Table {
    private byte[] buf = null;
    private int[] offsets = null;
    private short factor = 0;

    protected LocaTable(DirectoryEntry directoryEntry, RandomAccessFile randomAccessFile) {
        randomAccessFile.seek(directoryEntry.getOffset());
        this.buf = new byte[directoryEntry.getLength()];
        randomAccessFile.read(this.buf);
    }

    public void init(int n2, boolean bl2) {
        if (this.buf == null) {
            return;
        }
        this.offsets = new int[n2 + 1];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.buf);
        if (bl2) {
            this.factor = (short)2;
            for (int i2 = 0; i2 <= n2; ++i2) {
                this.offsets[i2] = byteArrayInputStream.read() << 8 | byteArrayInputStream.read();
            }
        } else {
            this.factor = 1;
            for (int i3 = 0; i3 <= n2; ++i3) {
                this.offsets[i3] = byteArrayInputStream.read() << 24 | byteArrayInputStream.read() << 16 | byteArrayInputStream.read() << 8 | byteArrayInputStream.read();
            }
        }
        this.buf = null;
    }

    public int getOffset(int n2) {
        if (this.offsets == null) {
            return 0;
        }
        return this.offsets[n2] * this.factor;
    }

    @Override
    public int getType() {
        return 1819239265;
    }
}

