/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.ByteArrayInputStream;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.DirectoryEntry;
import org.apache.batik.svggen.font.table.GlyfCompositeDescript;
import org.apache.batik.svggen.font.table.GlyfDescript;
import org.apache.batik.svggen.font.table.GlyfSimpleDescript;
import org.apache.batik.svggen.font.table.LocaTable;
import org.apache.batik.svggen.font.table.Table;

public class GlyfTable
implements Table {
    private byte[] buf = null;
    private GlyfDescript[] descript;

    protected GlyfTable(DirectoryEntry directoryEntry, RandomAccessFile randomAccessFile) {
        randomAccessFile.seek(directoryEntry.getOffset());
        this.buf = new byte[directoryEntry.getLength()];
        randomAccessFile.read(this.buf);
    }

    public void init(int n2, LocaTable locaTable) {
        int n3;
        if (this.buf == null) {
            return;
        }
        this.descript = new GlyfDescript[n2];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.buf);
        for (n3 = 0; n3 < n2; ++n3) {
            int n4 = locaTable.getOffset(n3 + 1) - locaTable.getOffset(n3);
            if (n4 <= 0) continue;
            byteArrayInputStream.reset();
            byteArrayInputStream.skip(locaTable.getOffset(n3));
            short s2 = (short)(byteArrayInputStream.read() << 8 | byteArrayInputStream.read());
            this.descript[n3] = s2 >= 0 ? new GlyfSimpleDescript(this, s2, byteArrayInputStream) : new GlyfCompositeDescript(this, byteArrayInputStream);
        }
        this.buf = null;
        for (n3 = 0; n3 < n2; ++n3) {
            if (this.descript[n3] == null) continue;
            this.descript[n3].resolve();
        }
    }

    public GlyfDescript getDescription(int n2) {
        return this.descript[n2];
    }

    @Override
    public int getType() {
        return 1735162214;
    }
}

