/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.ByteArrayInputStream;
import org.apache.batik.svggen.font.table.GlyfDescript;
import org.apache.batik.svggen.font.table.GlyfTable;

public class GlyfSimpleDescript
extends GlyfDescript {
    private int[] endPtsOfContours;
    private byte[] flags;
    private short[] xCoordinates;
    private short[] yCoordinates;
    private int count;

    public GlyfSimpleDescript(GlyfTable glyfTable, short n2, ByteArrayInputStream byteArrayInputStream) {
        super(glyfTable, (short)n2, byteArrayInputStream);
        int n3;
        this.endPtsOfContours = new int[n2];
        for (n3 = 0; n3 < n2; ++n3) {
            this.endPtsOfContours[n3] = byteArrayInputStream.read() << 8 | byteArrayInputStream.read();
        }
        this.count = this.endPtsOfContours[n2 - 1] + 1;
        this.flags = new byte[this.count];
        this.xCoordinates = new short[this.count];
        this.yCoordinates = new short[this.count];
        n3 = byteArrayInputStream.read() << 8 | byteArrayInputStream.read();
        this.readInstructions(byteArrayInputStream, n3);
        this.readFlags(this.count, byteArrayInputStream);
        this.readCoords(this.count, byteArrayInputStream);
    }

    @Override
    public int getEndPtOfContours(int n2) {
        return this.endPtsOfContours[n2];
    }

    @Override
    public byte getFlags(int n2) {
        return this.flags[n2];
    }

    @Override
    public short getXCoordinate(int n2) {
        return this.xCoordinates[n2];
    }

    @Override
    public short getYCoordinate(int n2) {
        return this.yCoordinates[n2];
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    public int getPointCount() {
        return this.count;
    }

    @Override
    public int getContourCount() {
        return this.getNumberOfContours();
    }

    private void readCoords(int n2, ByteArrayInputStream byteArrayInputStream) {
        int n3;
        short s2 = 0;
        short s3 = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            if ((this.flags[n3] & 0x10) != 0) {
                if ((this.flags[n3] & 2) != 0) {
                    s2 = (short)(s2 + (short)byteArrayInputStream.read());
                }
            } else {
                s2 = (this.flags[n3] & 2) != 0 ? (short)(s2 + (short)(-((short)byteArrayInputStream.read()))) : (short)(s2 + (short)(byteArrayInputStream.read() << 8 | byteArrayInputStream.read()));
            }
            this.xCoordinates[n3] = s2;
        }
        for (n3 = 0; n3 < n2; ++n3) {
            if ((this.flags[n3] & 0x20) != 0) {
                if ((this.flags[n3] & 4) != 0) {
                    s3 = (short)(s3 + (short)byteArrayInputStream.read());
                }
            } else {
                s3 = (this.flags[n3] & 4) != 0 ? (short)(s3 + (short)(-((short)byteArrayInputStream.read()))) : (short)(s3 + (short)(byteArrayInputStream.read() << 8 | byteArrayInputStream.read()));
            }
            this.yCoordinates[n3] = s3;
        }
    }

    private void readFlags(int n2, ByteArrayInputStream byteArrayInputStream) {
        try {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.flags[i2] = (byte)byteArrayInputStream.read();
                if ((this.flags[i2] & 8) == 0) continue;
                int n3 = byteArrayInputStream.read();
                for (int i3 = 1; i3 <= n3; ++i3) {
                    this.flags[i2 + i3] = this.flags[i2];
                }
                i2 += n3;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("error: array index out of bounds");
        }
    }
}

