/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.CmapFormat;
import org.apache.batik.svggen.font.table.CmapIndexEntry;
import org.apache.batik.svggen.font.table.DirectoryEntry;
import org.apache.batik.svggen.font.table.Table;

public class CmapTable
implements Table {
    private int version;
    private int numTables;
    private CmapIndexEntry[] entries;
    private CmapFormat[] formats;

    protected CmapTable(DirectoryEntry directoryEntry, RandomAccessFile randomAccessFile) {
        int n2;
        randomAccessFile.seek(directoryEntry.getOffset());
        long l2 = randomAccessFile.getFilePointer();
        this.version = randomAccessFile.readUnsignedShort();
        this.numTables = randomAccessFile.readUnsignedShort();
        this.entries = new CmapIndexEntry[this.numTables];
        this.formats = new CmapFormat[this.numTables];
        for (n2 = 0; n2 < this.numTables; ++n2) {
            this.entries[n2] = new CmapIndexEntry(randomAccessFile);
        }
        for (n2 = 0; n2 < this.numTables; ++n2) {
            randomAccessFile.seek(l2 + (long)this.entries[n2].getOffset());
            int n3 = randomAccessFile.readUnsignedShort();
            this.formats[n2] = CmapFormat.create(n3, randomAccessFile);
        }
    }

    public CmapFormat getCmapFormat(short s2, short s3) {
        for (int i2 = 0; i2 < this.numTables; ++i2) {
            if (this.entries[i2].getPlatformId() != s2 || this.entries[i2].getEncodingId() != s3) continue;
            return this.formats[i2];
        }
        return null;
    }

    @Override
    public int getType() {
        return 1668112752;
    }

    public String toString() {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(this.numTables * 8).append("cmap\n");
        for (n2 = 0; n2 < this.numTables; ++n2) {
            stringBuffer.append('\t').append(this.entries[n2].toString()).append('\n');
        }
        for (n2 = 0; n2 < this.numTables; ++n2) {
            stringBuffer.append('\t').append(this.formats[n2].toString()).append('\n');
        }
        return stringBuffer.toString();
    }
}

