/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font;

import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import org.apache.batik.constants.XMLConstants;
import org.apache.batik.svggen.font.Font;
import org.apache.batik.svggen.font.Glyph;
import org.apache.batik.svggen.font.Messages;
import org.apache.batik.svggen.font.Point;
import org.apache.batik.svggen.font.table.CmapFormat;
import org.apache.batik.svggen.font.table.Feature;
import org.apache.batik.svggen.font.table.FeatureTags;
import org.apache.batik.svggen.font.table.GsubTable;
import org.apache.batik.svggen.font.table.KernSubtable;
import org.apache.batik.svggen.font.table.KernTable;
import org.apache.batik.svggen.font.table.KerningPair;
import org.apache.batik.svggen.font.table.LangSys;
import org.apache.batik.svggen.font.table.PostTable;
import org.apache.batik.svggen.font.table.Script;
import org.apache.batik.svggen.font.table.ScriptTags;
import org.apache.batik.svggen.font.table.SingleSubst;
import org.apache.batik.util.SVGConstants;

public class SVGFont
implements XMLConstants,
FeatureTags,
ScriptTags,
SVGConstants {
    static final String EOL;
    static final String PROPERTY_LINE_SEPARATOR = "line.separator";
    static final String PROPERTY_LINE_SEPARATOR_DEFAULT = "\n";
    static final int DEFAULT_FIRST = 32;
    static final int DEFAULT_LAST = 126;
    private static String QUOT_EOL;
    private static String CONFIG_USAGE;
    private static String CONFIG_SVG_BEGIN;
    private static String CONFIG_SVG_TEST_CARD_START;
    private static String CONFIG_SVG_TEST_CARD_END;
    public static final char ARG_KEY_START_CHAR = '-';
    public static final String ARG_KEY_CHAR_RANGE_LOW = "-l";
    public static final String ARG_KEY_CHAR_RANGE_HIGH = "-h";
    public static final String ARG_KEY_ID = "-id";
    public static final String ARG_KEY_ASCII = "-ascii";
    public static final String ARG_KEY_TESTCARD = "-testcard";
    public static final String ARG_KEY_AUTO_RANGE = "-autorange";
    public static final String ARG_KEY_OUTPUT_PATH = "-o";

    protected static String encodeEntities(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (string.charAt(i2) == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (string.charAt(i2) == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (string.charAt(i2) == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            if (string.charAt(i2) == '\'') {
                stringBuffer.append("&apos;");
                continue;
            }
            if (string.charAt(i2) == '\"') {
                stringBuffer.append("&quot;");
                continue;
            }
            stringBuffer.append(string.charAt(i2));
        }
        return stringBuffer.toString();
    }

    protected static String getContourAsSVGPathData(Glyph glyph, int n2, int n3) {
        if (glyph.getPoint((int)n2).endOfContour) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        while (n4 < n3) {
            Point point = glyph.getPoint(n2 + n4 % n3);
            Point point2 = glyph.getPoint(n2 + (n4 + 1) % n3);
            Point point3 = glyph.getPoint(n2 + (n4 + 2) % n3);
            if (n4 == 0) {
                stringBuffer.append("M").append(String.valueOf(point.x)).append(" ").append(String.valueOf(point.y));
            }
            if (point.onCurve && point2.onCurve) {
                if (point2.x == point.x) {
                    stringBuffer.append("V").append(String.valueOf(point2.y));
                } else if (point2.y == point.y) {
                    stringBuffer.append("H").append(String.valueOf(point2.x));
                } else {
                    stringBuffer.append("L").append(String.valueOf(point2.x)).append(" ").append(String.valueOf(point2.y));
                }
                ++n4;
                continue;
            }
            if (point.onCurve && !point2.onCurve && point3.onCurve) {
                stringBuffer.append("Q").append(String.valueOf(point2.x)).append(" ").append(String.valueOf(point2.y)).append(" ").append(String.valueOf(point3.x)).append(" ").append(String.valueOf(point3.y));
                n4 += 2;
                continue;
            }
            if (point.onCurve && !point2.onCurve && !point3.onCurve) {
                stringBuffer.append("Q").append(String.valueOf(point2.x)).append(" ").append(String.valueOf(point2.y)).append(" ").append(String.valueOf(SVGFont.midValue(point2.x, point3.x))).append(" ").append(String.valueOf(SVGFont.midValue(point2.y, point3.y)));
                n4 += 2;
                continue;
            }
            if (!point.onCurve && !point2.onCurve) {
                stringBuffer.append("T").append(String.valueOf(SVGFont.midValue(point.x, point2.x))).append(" ").append(String.valueOf(SVGFont.midValue(point.y, point2.y)));
                ++n4;
                continue;
            }
            if (!point.onCurve && point2.onCurve) {
                stringBuffer.append("T").append(String.valueOf(point2.x)).append(" ").append(String.valueOf(point2.y));
                ++n4;
                continue;
            }
            System.out.println("drawGlyph case not catered for!!");
            break;
        }
        stringBuffer.append("Z");
        return stringBuffer.toString();
    }

    protected static String getSVGFontFaceElement(Font font) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = font.getNameTable().getRecord((short)1);
        short s2 = font.getHeadTable().getUnitsPerEm();
        String string2 = font.getOS2Table().getPanose().toString();
        short s3 = font.getHheaTable().getAscender();
        short s4 = font.getHheaTable().getDescender();
        int n2 = 0;
        stringBuffer.append("<").append("font-face").append(EOL).append("    ").append("font-family").append("=\"").append(string).append(QUOT_EOL).append("    ").append("units-per-em").append("=\"").append(s2).append(QUOT_EOL).append("    ").append("panose-1").append("=\"").append(string2).append(QUOT_EOL).append("    ").append("ascent").append("=\"").append(s3).append(QUOT_EOL).append("    ").append("descent").append("=\"").append(s4).append(QUOT_EOL).append("    ").append("alphabetic").append("=\"").append(n2).append('\"').append(" />").append(EOL);
        return stringBuffer.toString();
    }

    protected static void writeFontAsSVGFragment(PrintStream printStream, Font font, String string, int n2, int n3, boolean bl2, boolean bl3) {
        Object object;
        LangSys langSys;
        Object object2;
        short s2 = font.getOS2Table().getAvgCharWidth();
        printStream.print("<");
        printStream.print("font");
        printStream.print(" ");
        if (string != null) {
            printStream.print("id");
            printStream.print("=\"");
            printStream.print(string);
            printStream.print('\"');
            printStream.print(" ");
        }
        printStream.print("horiz-adv-x");
        printStream.print("=\"");
        printStream.print(s2);
        printStream.print('\"');
        printStream.print(" >");
        printStream.print(SVGFont.getSVGFontFaceElement(font));
        CmapFormat cmapFormat = null;
        if (bl3) {
            cmapFormat = font.getCmapTable().getCmapFormat((short)1, (short)0);
        } else {
            cmapFormat = font.getCmapTable().getCmapFormat((short)3, (short)1);
            if (cmapFormat == null) {
                cmapFormat = font.getCmapTable().getCmapFormat((short)3, (short)0);
            }
        }
        if (cmapFormat == null) {
            throw new Exception("Cannot find a suitable cmap table");
        }
        GsubTable gsubTable = (GsubTable)font.getTable(1196643650);
        SingleSubst singleSubst = null;
        SingleSubst singleSubst2 = null;
        SingleSubst singleSubst3 = null;
        if (gsubTable != null && (object2 = gsubTable.getScriptList().findScript("arab")) != null && (langSys = ((Script)object2).getDefaultLangSys()) != null) {
            Feature feature = gsubTable.getFeatureList().findFeature(langSys, "init");
            object = gsubTable.getFeatureList().findFeature(langSys, "medi");
            Feature feature2 = gsubTable.getFeatureList().findFeature(langSys, "fina");
            if (feature != null) {
                singleSubst = (SingleSubst)gsubTable.getLookupList().getLookup(feature, 0).getSubtable(0);
            }
            if (object != null) {
                singleSubst2 = (SingleSubst)gsubTable.getLookupList().getLookup((Feature)object, 0).getSubtable(0);
            }
            if (feature2 != null) {
                singleSubst3 = (SingleSubst)gsubTable.getLookupList().getLookup(feature2, 0).getSubtable(0);
            }
        }
        printStream.println(SVGFont.getGlyphAsSVG(font, font.getGlyph(0), 0, s2, singleSubst, singleSubst2, singleSubst3, ""));
        try {
            if (n2 == -1) {
                n2 = !bl2 ? 32 : cmapFormat.getFirst();
            }
            if (n3 == -1) {
                n3 = !bl2 ? 126 : cmapFormat.getLast();
            }
            object2 = new HashSet();
            for (int i2 = n2; i2 <= n3; ++i2) {
                int n4 = cmapFormat.mapCharCode(i2);
                if (n4 <= 0) continue;
                object2.add(n4);
                printStream.println(SVGFont.getGlyphAsSVG(font, font.getGlyph(n4), n4, s2, singleSubst, singleSubst2, singleSubst3, 32 <= i2 && i2 <= 127 ? SVGFont.encodeEntities(String.valueOf((char)i2)) : "&#x" + Integer.toHexString(i2) + ";"));
            }
            KernTable kernTable = (KernTable)font.getTable(1801810542);
            if (kernTable != null) {
                KernSubtable kernSubtable = kernTable.getSubtable(0);
                object = (PostTable)font.getTable(1886352244);
                for (int i3 = 0; i3 < kernSubtable.getKerningPairCount(); ++i3) {
                    KerningPair kerningPair = kernSubtable.getKerningPair(i3);
                    if (!object2.contains(kerningPair.getLeft()) || !object2.contains(kerningPair.getRight())) continue;
                    printStream.println(SVGFont.getKerningPairAsSVG(kerningPair, (PostTable)object));
                }
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        printStream.print("</");
        printStream.print("font");
        printStream.println(">");
    }

    protected static String getGlyphAsSVG(Font font, Glyph glyph, int n2, int n3, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        int n5 = 0;
        int n6 = font.getHmtxTable().getAdvanceWidth(n2);
        if (n2 == 0) {
            stringBuffer.append("<");
            stringBuffer.append("missing-glyph");
        } else {
            stringBuffer.append("<").append("glyph").append(" ").append("unicode").append("=\"").append(string2).append('\"');
            String string3 = font.getPostTable().getGlyphName(n2);
            if (string3 != null) {
                stringBuffer.append(" ").append("glyph-name").append("=\"").append(string3).append('\"');
            }
        }
        if (n6 != n3) {
            stringBuffer.append(" ").append("horiz-adv-x").append("=\"").append(n6).append('\"');
        }
        if (string != null) {
            stringBuffer.append(string);
        }
        if (glyph != null) {
            stringBuffer.append(" ").append("d").append("=\"");
            for (int i2 = 0; i2 < glyph.getPointCount(); ++i2) {
                ++n5;
                if (!glyph.getPoint((int)i2).endOfContour) continue;
                stringBuffer.append(SVGFont.getContourAsSVGPathData(glyph, n4, n5));
                n4 = i2 + 1;
                n5 = 0;
            }
            stringBuffer.append('\"');
        }
        stringBuffer.append(" />");
        SVGFont.chopUpStringBuffer(stringBuffer);
        return stringBuffer.toString();
    }

    protected static String getGlyphAsSVG(Font font, Glyph glyph, int n2, int n3, SingleSubst singleSubst, SingleSubst singleSubst2, SingleSubst singleSubst3, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        int n4 = n2;
        int n5 = n2;
        int n6 = n2;
        if (singleSubst != null) {
            n4 = singleSubst.substitute(n2);
        }
        if (singleSubst2 != null) {
            n5 = singleSubst2.substitute(n2);
        }
        if (singleSubst3 != null) {
            n6 = singleSubst3.substitute(n2);
        }
        if (n4 != n2) {
            stringBuffer.append(SVGFont.getGlyphAsSVG(font, font.getGlyph(n4), n4, n3, " arabic-form=\"initial\"", string));
            stringBuffer.append(EOL);
            bl2 = true;
        }
        if (n5 != n2) {
            stringBuffer.append(SVGFont.getGlyphAsSVG(font, font.getGlyph(n5), n5, n3, " arabic-form=\"medial\"", string));
            stringBuffer.append(EOL);
            bl2 = true;
        }
        if (n6 != n2) {
            stringBuffer.append(SVGFont.getGlyphAsSVG(font, font.getGlyph(n6), n6, n3, " arabic-form=\"terminal\"", string));
            stringBuffer.append(EOL);
            bl2 = true;
        }
        if (bl2) {
            stringBuffer.append(SVGFont.getGlyphAsSVG(font, glyph, n2, n3, " arabic-form=\"isolated\"", string));
        } else {
            stringBuffer.append(SVGFont.getGlyphAsSVG(font, glyph, n2, n3, null, string));
        }
        return stringBuffer.toString();
    }

    protected static String getKerningPairAsSVG(KerningPair kerningPair, PostTable postTable) {
        String string = postTable.getGlyphName(kerningPair.getLeft());
        String string2 = postTable.getGlyphName(kerningPair.getRight());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<").append("hkern").append(" ");
        if (string == null) {
            stringBuffer.append("u1").append("=\"");
            stringBuffer.append(kerningPair.getLeft());
        } else {
            stringBuffer.append("g1").append("=\"");
            stringBuffer.append(string);
        }
        stringBuffer.append('\"').append(" ");
        if (string2 == null) {
            stringBuffer.append("u2").append("=\"");
            stringBuffer.append(kerningPair.getRight());
        } else {
            stringBuffer.append("g2").append("=\"");
            stringBuffer.append(string2);
        }
        stringBuffer.append('\"').append(" ").append("k").append("=\"");
        stringBuffer.append(-kerningPair.getValue());
        stringBuffer.append('\"').append(" />");
        return stringBuffer.toString();
    }

    protected static void writeSvgBegin(PrintStream printStream) {
        printStream.println(Messages.formatMessage(CONFIG_SVG_BEGIN, new Object[]{"-//W3C//DTD SVG 1.0//EN", "http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd"}));
    }

    protected static void writeSvgDefsBegin(PrintStream printStream) {
        printStream.println("<defs >");
    }

    protected static void writeSvgDefsEnd(PrintStream printStream) {
        printStream.println("</defs>");
    }

    protected static void writeSvgEnd(PrintStream printStream) {
        printStream.println("</svg>");
    }

    protected static void writeSvgTestCard(PrintStream printStream, String string) {
        printStream.println(Messages.formatMessage(CONFIG_SVG_TEST_CARD_START, null));
        printStream.println(string);
        printStream.println(Messages.formatMessage(CONFIG_SVG_TEST_CARD_END, null));
    }

    public static void main(String[] stringArray) {
        try {
            String string = SVGFont.parseArgs(stringArray, null);
            String string2 = SVGFont.parseArgs(stringArray, ARG_KEY_CHAR_RANGE_LOW);
            String string3 = SVGFont.parseArgs(stringArray, ARG_KEY_CHAR_RANGE_HIGH);
            String string4 = SVGFont.parseArgs(stringArray, ARG_KEY_ID);
            String string5 = SVGFont.parseArgs(stringArray, ARG_KEY_ASCII);
            String string6 = SVGFont.parseArgs(stringArray, ARG_KEY_TESTCARD);
            String string7 = SVGFont.parseArgs(stringArray, ARG_KEY_OUTPUT_PATH);
            String string8 = SVGFont.parseArgs(stringArray, ARG_KEY_AUTO_RANGE);
            PrintStream printStream = null;
            FileOutputStream fileOutputStream = null;
            if (string7 != null) {
                fileOutputStream = new FileOutputStream(string7);
                printStream = new PrintStream(fileOutputStream);
            } else {
                printStream = System.out;
            }
            if (string != null) {
                Font font = Font.create(string);
                SVGFont.writeSvgBegin(printStream);
                SVGFont.writeSvgDefsBegin(printStream);
                SVGFont.writeFontAsSVGFragment(printStream, font, string4, string2 != null ? Integer.parseInt(string2) : -1, string3 != null ? Integer.parseInt(string3) : -1, string8 != null, string5 != null);
                SVGFont.writeSvgDefsEnd(printStream);
                if (string6 != null) {
                    String string9 = font.getNameTable().getRecord((short)1);
                    SVGFont.writeSvgTestCard(printStream, string9);
                }
                SVGFont.writeSvgEnd(printStream);
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            } else {
                SVGFont.usage();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
            SVGFont.usage();
        }
    }

    private static void chopUpStringBuffer(StringBuffer stringBuffer) {
        if (stringBuffer.length() < 256) {
            return;
        }
        for (int i2 = 240; i2 < stringBuffer.length(); ++i2) {
            if (stringBuffer.charAt(i2) != ' ') continue;
            stringBuffer.setCharAt(i2, '\n');
            i2 += 240;
        }
    }

    private static int midValue(int n2, int n3) {
        return n2 + (n3 - n2) / 2;
    }

    private static String parseArgs(String[] stringArray, String string) {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (string == null) {
                if (stringArray[i2].charAt(0) == '-') continue;
                return stringArray[i2];
            }
            if (!string.equalsIgnoreCase(stringArray[i2])) continue;
            if (i2 < stringArray.length - 1 && stringArray[i2 + 1].charAt(0) != '-') {
                return stringArray[i2 + 1];
            }
            return stringArray[i2];
        }
        return null;
    }

    private static void usage() {
        System.err.println(Messages.formatMessage(CONFIG_USAGE, null));
    }

    static {
        String string;
        try {
            string = System.getProperty(PROPERTY_LINE_SEPARATOR, PROPERTY_LINE_SEPARATOR_DEFAULT);
        }
        catch (SecurityException securityException) {
            string = PROPERTY_LINE_SEPARATOR_DEFAULT;
        }
        EOL = string;
        QUOT_EOL = '\"' + EOL;
        CONFIG_USAGE = "SVGFont.config.usage";
        CONFIG_SVG_BEGIN = "SVGFont.config.svg.begin";
        CONFIG_SVG_TEST_CARD_START = "SVGFont.config.svg.test.card.start";
        CONFIG_SVG_TEST_CARD_END = "SVGFont.config.svg.test.card.end";
    }
}

