/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font;

import org.apache.batik.svggen.font.Point;
import org.apache.batik.svggen.font.table.GlyphDescription;

public class Glyph {
    protected short leftSideBearing;
    protected int advanceWidth;
    private Point[] points;

    public Glyph(GlyphDescription glyphDescription, short s2, int n2) {
        this.leftSideBearing = s2;
        this.advanceWidth = n2;
        this.describe(glyphDescription);
    }

    public int getAdvanceWidth() {
        return this.advanceWidth;
    }

    public short getLeftSideBearing() {
        return this.leftSideBearing;
    }

    public Point getPoint(int n2) {
        return this.points[n2];
    }

    public int getPointCount() {
        return this.points.length;
    }

    public void reset() {
    }

    public void scale(int n2) {
        for (Point point : this.points) {
            point.x = (point.x << 10) * n2 >> 26;
            point.y = (point.y << 10) * n2 >> 26;
        }
        this.leftSideBearing = (short)(this.leftSideBearing * n2 >> 6);
        this.advanceWidth = this.advanceWidth * n2 >> 6;
    }

    private void describe(GlyphDescription glyphDescription) {
        int n2 = 0;
        this.points = new Point[glyphDescription.getPointCount() + 2];
        for (int i2 = 0; i2 < glyphDescription.getPointCount(); ++i2) {
            boolean bl2;
            boolean bl3 = bl2 = glyphDescription.getEndPtOfContours(n2) == i2;
            if (bl2) {
                ++n2;
            }
            this.points[i2] = new Point(glyphDescription.getXCoordinate(i2), glyphDescription.getYCoordinate(i2), (glyphDescription.getFlags(i2) & 1) != 0, bl2);
        }
        this.points[glyphDescription.getPointCount()] = new Point(0, 0, true, true);
        this.points[glyphDescription.getPointCount() + 1] = new Point(this.advanceWidth, 0, true, true);
    }
}

