/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.apache.batik.svggen.SVGGraphics2DRuntimeException;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class XmlWriter
implements SVGConstants {
    private static String EOL;
    private static final String TAG_END = "/>";
    private static final String TAG_START = "</";
    private static final char[] SPACES;
    private static final int SPACES_LEN;

    XmlWriter() {
    }

    private static void writeXml(Attr attr, IndentWriter indentWriter, boolean bl2) {
        String string = attr.getName();
        indentWriter.write(string);
        indentWriter.write("=\"");
        XmlWriter.writeChildrenXml(attr, indentWriter, bl2);
        indentWriter.write(34);
    }

    private static void writeChildrenXml(Attr attr, IndentWriter indentWriter, boolean bl2) {
        int n2;
        char[] cArray = attr.getValue().toCharArray();
        if (cArray == null) {
            return;
        }
        int n3 = cArray.length;
        int n4 = 0;
        block6: for (n2 = 0; n2 < n3; ++n2) {
            char c2 = cArray[n2];
            switch (c2) {
                case '<': {
                    indentWriter.write(cArray, n4, n2 - n4);
                    n4 = n2 + 1;
                    indentWriter.write("&lt;");
                    continue block6;
                }
                case '>': {
                    indentWriter.write(cArray, n4, n2 - n4);
                    n4 = n2 + 1;
                    indentWriter.write("&gt;");
                    continue block6;
                }
                case '&': {
                    indentWriter.write(cArray, n4, n2 - n4);
                    n4 = n2 + 1;
                    indentWriter.write("&amp;");
                    continue block6;
                }
                case '\"': {
                    indentWriter.write(cArray, n4, n2 - n4);
                    n4 = n2 + 1;
                    indentWriter.write("&quot;");
                    continue block6;
                }
                default: {
                    if (!bl2 || c2 <= '\u007f') continue block6;
                    indentWriter.write(cArray, n4, n2 - n4);
                    String string = "0000" + Integer.toHexString(c2);
                    indentWriter.write("&#x" + string.substring(string.length() - 4) + ";");
                    n4 = n2 + 1;
                }
            }
        }
        indentWriter.write(cArray, n4, n2 - n4);
    }

    private static void writeXml(Comment comment, IndentWriter indentWriter, boolean bl2) {
        int n2;
        char[] cArray = comment.getData().toCharArray();
        if (cArray == null) {
            indentWriter.write("<!---->");
            return;
        }
        indentWriter.write("<!--");
        boolean bl3 = false;
        int n3 = cArray.length;
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            char c2 = cArray[n2];
            if (c2 == '-') {
                if (bl3) {
                    indentWriter.write(cArray, n4, n2 - n4);
                    n4 = n2;
                    indentWriter.write(32);
                }
                bl3 = true;
                continue;
            }
            bl3 = false;
        }
        indentWriter.write(cArray, n4, n2 - n4);
        if (bl3) {
            indentWriter.write(32);
        }
        indentWriter.write("-->");
    }

    private static void writeXml(Text text, IndentWriter indentWriter, boolean bl2) {
        XmlWriter.writeXml(text, indentWriter, false, bl2);
    }

    private static void writeXml(Text text, IndentWriter indentWriter, boolean bl2, boolean bl3) {
        char c2;
        int n2;
        char[] cArray = text.getData().toCharArray();
        if (cArray == null) {
            System.err.println("Null text data??");
            return;
        }
        int n3 = cArray.length;
        int n4 = 0;
        if (bl2) {
            block12: for (n2 = 0; n2 < n3; ++n2) {
                c2 = cArray[n2];
                switch (c2) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        continue block12;
                    }
                }
            }
            n4 = n2;
        }
        block13: while (n2 < n3) {
            c2 = cArray[n2];
            switch (c2) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (!bl2) break;
                    int n5 = n2++;
                    block14: while (n2 < n3) {
                        switch (cArray[n2]) {
                            case '\t': 
                            case '\n': 
                            case '\r': 
                            case ' ': {
                                ++n2;
                                continue block14;
                            }
                        }
                    }
                    if (n2 != n3) continue block13;
                    indentWriter.write(cArray, n4, n5 - n4);
                    return;
                }
                case '<': {
                    indentWriter.write(cArray, n4, n2 - n4);
                    n4 = n2 + 1;
                    indentWriter.write("&lt;");
                    break;
                }
                case '>': {
                    indentWriter.write(cArray, n4, n2 - n4);
                    n4 = n2 + 1;
                    indentWriter.write("&gt;");
                    break;
                }
                case '&': {
                    indentWriter.write(cArray, n4, n2 - n4);
                    n4 = n2 + 1;
                    indentWriter.write("&amp;");
                    break;
                }
                default: {
                    if (!bl3 || c2 <= '\u007f') break;
                    indentWriter.write(cArray, n4, n2 - n4);
                    String string = "0000" + Integer.toHexString(c2);
                    indentWriter.write("&#x" + string.substring(string.length() - 4) + ";");
                    n4 = n2 + 1;
                }
            }
            ++n2;
        }
        indentWriter.write(cArray, n4, n2 - n4);
    }

    private static void writeXml(CDATASection cDATASection, IndentWriter indentWriter, boolean bl2) {
        char[] cArray = cDATASection.getData().toCharArray();
        if (cArray == null) {
            indentWriter.write("<![CDATA[]]>");
            return;
        }
        indentWriter.write("<![CDATA[");
        int n2 = cArray.length;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            char c2 = cArray[n4];
            if (c2 == ']' && n4 + 2 < cArray.length && cArray[n4 + 1] == ']' && cArray[n4 + 2] == '>') {
                indentWriter.write(cArray, n3, n4 - n3);
                n3 = n4 + 1;
                indentWriter.write("]]]]><![CDATA[>");
                continue;
            }
            ++n4;
        }
        indentWriter.write(cArray, n3, n4 - n3);
        indentWriter.write("]]>");
    }

    private static void writeXml(Element element, IndentWriter indentWriter, boolean bl2) {
        int n2;
        indentWriter.write(TAG_START, 0, 1);
        indentWriter.write(element.getTagName());
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap != null) {
            n2 = namedNodeMap.getLength();
            for (int i2 = 0; i2 < n2; ++i2) {
                Attr attr = (Attr)namedNodeMap.item(i2);
                indentWriter.write(32);
                XmlWriter.writeXml(attr, indentWriter, bl2);
            }
        }
        int n3 = n2 = element.getParentNode().getLastChild() == element ? 1 : 0;
        if (!element.hasChildNodes()) {
            if (n2 != 0) {
                indentWriter.setIndentLevel(indentWriter.getIndentLevel() - 2);
            }
            indentWriter.printIndent();
            indentWriter.write(TAG_END, 0, 2);
            return;
        }
        Node node = element.getFirstChild();
        indentWriter.printIndent();
        indentWriter.write(TAG_END, 1, 1);
        if (node.getNodeType() != 3 || element.getLastChild() != node) {
            indentWriter.setIndentLevel(indentWriter.getIndentLevel() + 2);
        }
        XmlWriter.writeChildrenXml(element, indentWriter, bl2);
        indentWriter.write(TAG_START, 0, 2);
        indentWriter.write(element.getTagName());
        if (n2 != 0) {
            indentWriter.setIndentLevel(indentWriter.getIndentLevel() - 2);
        }
        indentWriter.printIndent();
        indentWriter.write(TAG_END, 1, 1);
    }

    private static void writeChildrenXml(Element element, IndentWriter indentWriter, boolean bl2) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            XmlWriter.writeXml(node, (Writer)indentWriter, bl2);
        }
    }

    private static void writeDocumentHeader(IndentWriter indentWriter) {
        String string = null;
        if (indentWriter.getProxied() instanceof OutputStreamWriter) {
            OutputStreamWriter outputStreamWriter = (OutputStreamWriter)indentWriter.getProxied();
            string = XmlWriter.java2std(outputStreamWriter.getEncoding());
        }
        indentWriter.write("<?xml version=\"1.0\"");
        if (string != null) {
            indentWriter.write(" encoding=\"");
            indentWriter.write(string);
            indentWriter.write(34);
        }
        indentWriter.write("?>");
        indentWriter.write(EOL);
        indentWriter.write("<!DOCTYPE svg PUBLIC '");
        indentWriter.write("-//W3C//DTD SVG 1.0//EN");
        indentWriter.write("'");
        indentWriter.write(EOL);
        indentWriter.write("          '");
        indentWriter.write("http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd");
        indentWriter.write("'");
        indentWriter.write(">");
        indentWriter.write(EOL);
    }

    private static void writeXml(Document document, IndentWriter indentWriter, boolean bl2) {
        XmlWriter.writeDocumentHeader(indentWriter);
        NodeList nodeList = document.getChildNodes();
        XmlWriter.writeXml(nodeList, indentWriter, bl2);
    }

    private static void writeXml(NodeList nodeList, IndentWriter indentWriter, boolean bl2) {
        int n2 = nodeList.getLength();
        if (n2 == 0) {
            return;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = nodeList.item(i2);
            XmlWriter.writeXml(node, (Writer)indentWriter, bl2);
            indentWriter.write(EOL);
        }
    }

    static String java2std(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("ISO8859_")) {
            return "ISO-8859-" + string.substring(8);
        }
        if (string.startsWith("8859_")) {
            return "ISO-8859-" + string.substring(5);
        }
        if ("ASCII7".equalsIgnoreCase(string) || "ASCII".equalsIgnoreCase(string)) {
            return "US-ASCII";
        }
        if ("UTF8".equalsIgnoreCase(string)) {
            return "UTF-8";
        }
        if (string.startsWith("Unicode")) {
            return "UTF-16";
        }
        if ("SJIS".equalsIgnoreCase(string)) {
            return "Shift_JIS";
        }
        if ("JIS".equalsIgnoreCase(string)) {
            return "ISO-2022-JP";
        }
        if ("EUCJIS".equalsIgnoreCase(string)) {
            return "EUC-JP";
        }
        return "UTF-8";
    }

    public static void writeXml(Node node, Writer writer, boolean bl2) {
        try {
            IndentWriter indentWriter = null;
            indentWriter = writer instanceof IndentWriter ? (IndentWriter)writer : new IndentWriter(writer);
            switch (node.getNodeType()) {
                case 2: {
                    XmlWriter.writeXml((Attr)node, indentWriter, bl2);
                    break;
                }
                case 8: {
                    XmlWriter.writeXml((Comment)node, indentWriter, bl2);
                    break;
                }
                case 3: {
                    XmlWriter.writeXml((Text)node, indentWriter, bl2);
                    break;
                }
                case 4: {
                    XmlWriter.writeXml((CDATASection)node, indentWriter, bl2);
                    break;
                }
                case 9: {
                    XmlWriter.writeXml((Document)node, indentWriter, bl2);
                    break;
                }
                case 11: {
                    XmlWriter.writeDocumentHeader(indentWriter);
                    NodeList nodeList = node.getChildNodes();
                    XmlWriter.writeXml(nodeList, indentWriter, bl2);
                    break;
                }
                case 1: {
                    XmlWriter.writeXml((Element)node, indentWriter, bl2);
                    break;
                }
                default: {
                    throw new SVGGraphics2DRuntimeException("Unable to write node of type " + node.getClass().getName());
                }
            }
        }
        catch (IOException iOException) {
            throw new SVGGraphics2DIOException(iOException);
        }
    }

    static {
        String string;
        SPACES = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
        SPACES_LEN = SPACES.length;
        try {
            string = System.getProperty("line.separator", "\n");
        }
        catch (SecurityException securityException) {
            string = "\n";
        }
        EOL = string;
    }

    static class IndentWriter
    extends Writer {
        protected Writer proxied;
        protected int indentLevel;
        protected int column;

        public IndentWriter(Writer writer) {
            if (writer == null) {
                throw new SVGGraphics2DRuntimeException("proxy should not be null");
            }
            this.proxied = writer;
        }

        public void setIndentLevel(int n2) {
            this.indentLevel = n2;
        }

        public int getIndentLevel() {
            return this.indentLevel;
        }

        public void printIndent() {
            this.proxied.write(EOL);
            for (int i2 = this.indentLevel; i2 > 0; i2 -= SPACES_LEN) {
                if (i2 > SPACES_LEN) {
                    this.proxied.write(SPACES, 0, SPACES_LEN);
                    continue;
                }
                this.proxied.write(SPACES, 0, i2);
                break;
            }
            this.column = this.indentLevel;
        }

        public Writer getProxied() {
            return this.proxied;
        }

        public int getColumn() {
            return this.column;
        }

        @Override
        public void write(int n2) {
            ++this.column;
            this.proxied.write(n2);
        }

        @Override
        public void write(char[] cArray) {
            this.column += cArray.length;
            this.proxied.write(cArray);
        }

        @Override
        public void write(char[] cArray, int n2, int n3) {
            this.column += n3;
            this.proxied.write(cArray, n2, n3);
        }

        @Override
        public void write(String string) {
            this.column += string.length();
            this.proxied.write(string);
        }

        @Override
        public void write(String string, int n2, int n3) {
            this.column += n3;
            this.proxied.write(string, n2, n3);
        }

        @Override
        public void flush() {
            this.proxied.flush();
        }

        @Override
        public void close() {
            this.column = -1;
            this.proxied.close();
        }
    }
}

