/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Polygon;
import java.awt.geom.PathIterator;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphicObjectConverter;
import org.w3c.dom.Element;

public class SVGPolygon
extends SVGGraphicObjectConverter {
    public SVGPolygon(SVGGeneratorContext sVGGeneratorContext) {
        super(sVGGeneratorContext);
    }

    public Element toSVG(Polygon polygon) {
        Element element = this.generatorContext.domFactory.createElementNS("http://www.w3.org/2000/svg", "polygon");
        StringBuffer stringBuffer = new StringBuffer(" ");
        PathIterator pathIterator = polygon.getPathIterator(null);
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            int n2 = pathIterator.currentSegment(fArray);
            switch (n2) {
                case 0: {
                    this.appendPoint(stringBuffer, fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    this.appendPoint(stringBuffer, fArray[0], fArray[1]);
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    throw new RuntimeException("invalid segmentType:" + n2);
                }
            }
            pathIterator.next();
        }
        element.setAttributeNS(null, "points", stringBuffer.substring(0, stringBuffer.length() - 1));
        return element;
    }

    private void appendPoint(StringBuffer stringBuffer, float f2, float f3) {
        stringBuffer.append(this.doubleString(f2));
        stringBuffer.append(" ");
        stringBuffer.append(this.doubleString(f3));
        stringBuffer.append(" ");
    }
}

