/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.batik.ext.awt.g2d.AbstractGraphics2D;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.batik.svggen.DOMGroupManager;
import org.apache.batik.svggen.DOMTreeManager;
import org.apache.batik.svggen.DefaultErrorHandler;
import org.apache.batik.svggen.DefaultStyleHandler;
import org.apache.batik.svggen.ErrorConstants;
import org.apache.batik.svggen.ExtensionHandler;
import org.apache.batik.svggen.GenericImageHandler;
import org.apache.batik.svggen.ImageHandler;
import org.apache.batik.svggen.SVGCSSStyler;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphicContext;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.apache.batik.svggen.SVGGraphics2DRuntimeException;
import org.apache.batik.svggen.SVGIDGenerator;
import org.apache.batik.svggen.SVGShape;
import org.apache.batik.svggen.SVGSyntax;
import org.apache.batik.svggen.XmlWriter;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGGraphics2D
extends AbstractGraphics2D
implements Cloneable,
ErrorConstants,
SVGSyntax {
    public static final String DEFAULT_XML_ENCODING = "ISO-8859-1";
    public static final int DEFAULT_MAX_GC_OVERRIDES = 3;
    protected DOMTreeManager domTreeManager;
    protected DOMGroupManager domGroupManager;
    protected SVGGeneratorContext generatorCtx;
    protected SVGShape shapeConverter;
    protected Dimension svgCanvasSize;
    protected Graphics2D fmg;
    protected Set unsupportedAttributes;

    public final Dimension getSVGCanvasSize() {
        return this.svgCanvasSize;
    }

    public final void setSVGCanvasSize(Dimension dimension) {
        this.svgCanvasSize = new Dimension(dimension);
    }

    public final SVGGeneratorContext getGeneratorContext() {
        return this.generatorCtx;
    }

    public final SVGShape getShapeConverter() {
        return this.shapeConverter;
    }

    public final DOMTreeManager getDOMTreeManager() {
        return this.domTreeManager;
    }

    protected final void setDOMTreeManager(DOMTreeManager dOMTreeManager) {
        this.domTreeManager = dOMTreeManager;
        this.generatorCtx.genericImageHandler.setDOMTreeManager(this.domTreeManager);
    }

    protected final DOMGroupManager getDOMGroupManager() {
        return this.domGroupManager;
    }

    protected final void setDOMGroupManager(DOMGroupManager dOMGroupManager) {
        this.domGroupManager = dOMGroupManager;
    }

    public final Document getDOMFactory() {
        return this.generatorCtx.domFactory;
    }

    public final ImageHandler getImageHandler() {
        return this.generatorCtx.imageHandler;
    }

    public final GenericImageHandler getGenericImageHandler() {
        return this.generatorCtx.genericImageHandler;
    }

    public final ExtensionHandler getExtensionHandler() {
        return this.generatorCtx.extensionHandler;
    }

    public final void setExtensionHandler(ExtensionHandler extensionHandler) {
        this.generatorCtx.setExtensionHandler(extensionHandler);
    }

    public SVGGraphics2D(Document document) {
        this(SVGGeneratorContext.createDefault(document), false);
    }

    public SVGGraphics2D(Document document, ImageHandler imageHandler, ExtensionHandler extensionHandler, boolean bl2) {
        this(SVGGraphics2D.buildSVGGeneratorContext(document, imageHandler, extensionHandler), bl2);
    }

    public static SVGGeneratorContext buildSVGGeneratorContext(Document document, ImageHandler imageHandler, ExtensionHandler extensionHandler) {
        SVGGeneratorContext sVGGeneratorContext = new SVGGeneratorContext(document);
        sVGGeneratorContext.setIDGenerator(new SVGIDGenerator());
        sVGGeneratorContext.setExtensionHandler(extensionHandler);
        sVGGeneratorContext.setImageHandler(imageHandler);
        sVGGeneratorContext.setStyleHandler(new DefaultStyleHandler());
        sVGGeneratorContext.setComment("Generated by the Batik Graphics2D SVG Generator");
        sVGGeneratorContext.setErrorHandler(new DefaultErrorHandler());
        return sVGGeneratorContext;
    }

    public SVGGraphics2D(SVGGeneratorContext sVGGeneratorContext, boolean bl2) {
        super(bl2);
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        this.fmg = bufferedImage.createGraphics();
        this.unsupportedAttributes = new HashSet();
        this.unsupportedAttributes.add(TextAttribute.BACKGROUND);
        this.unsupportedAttributes.add(TextAttribute.BIDI_EMBEDDING);
        this.unsupportedAttributes.add(TextAttribute.CHAR_REPLACEMENT);
        this.unsupportedAttributes.add(TextAttribute.JUSTIFICATION);
        this.unsupportedAttributes.add(TextAttribute.RUN_DIRECTION);
        this.unsupportedAttributes.add(TextAttribute.SUPERSCRIPT);
        this.unsupportedAttributes.add(TextAttribute.SWAP_COLORS);
        this.unsupportedAttributes.add(TextAttribute.TRANSFORM);
        this.unsupportedAttributes.add(TextAttribute.WIDTH);
        if (sVGGeneratorContext == null) {
            throw new SVGGraphics2DRuntimeException("generatorContext should not be null");
        }
        this.setGeneratorContext(sVGGeneratorContext);
    }

    protected void setGeneratorContext(SVGGeneratorContext sVGGeneratorContext) {
        this.generatorCtx = sVGGeneratorContext;
        this.gc = new GraphicContext(new AffineTransform());
        SVGGeneratorContext.GraphicContextDefaults graphicContextDefaults = sVGGeneratorContext.getGraphicContextDefaults();
        if (graphicContextDefaults != null) {
            if (graphicContextDefaults.getPaint() != null) {
                this.gc.setPaint(graphicContextDefaults.getPaint());
            }
            if (graphicContextDefaults.getStroke() != null) {
                this.gc.setStroke(graphicContextDefaults.getStroke());
            }
            if (graphicContextDefaults.getComposite() != null) {
                this.gc.setComposite(graphicContextDefaults.getComposite());
            }
            if (graphicContextDefaults.getClip() != null) {
                this.gc.setClip(graphicContextDefaults.getClip());
            }
            if (graphicContextDefaults.getRenderingHints() != null) {
                this.gc.setRenderingHints(graphicContextDefaults.getRenderingHints());
            }
            if (graphicContextDefaults.getFont() != null) {
                this.gc.setFont(graphicContextDefaults.getFont());
            }
            if (graphicContextDefaults.getBackground() != null) {
                this.gc.setBackground(graphicContextDefaults.getBackground());
            }
        }
        this.shapeConverter = new SVGShape(sVGGeneratorContext);
        this.domTreeManager = new DOMTreeManager(this.gc, sVGGeneratorContext, 3);
        this.domGroupManager = new DOMGroupManager(this.gc, this.domTreeManager);
        this.domTreeManager.addGroupManager(this.domGroupManager);
        sVGGeneratorContext.genericImageHandler.setDOMTreeManager(this.domTreeManager);
    }

    public SVGGraphics2D(SVGGraphics2D sVGGraphics2D) {
        super(sVGGraphics2D);
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        this.fmg = bufferedImage.createGraphics();
        this.unsupportedAttributes = new HashSet();
        this.unsupportedAttributes.add(TextAttribute.BACKGROUND);
        this.unsupportedAttributes.add(TextAttribute.BIDI_EMBEDDING);
        this.unsupportedAttributes.add(TextAttribute.CHAR_REPLACEMENT);
        this.unsupportedAttributes.add(TextAttribute.JUSTIFICATION);
        this.unsupportedAttributes.add(TextAttribute.RUN_DIRECTION);
        this.unsupportedAttributes.add(TextAttribute.SUPERSCRIPT);
        this.unsupportedAttributes.add(TextAttribute.SWAP_COLORS);
        this.unsupportedAttributes.add(TextAttribute.TRANSFORM);
        this.unsupportedAttributes.add(TextAttribute.WIDTH);
        this.generatorCtx = sVGGraphics2D.generatorCtx;
        this.gc.validateTransformStack();
        this.shapeConverter = sVGGraphics2D.shapeConverter;
        this.domTreeManager = sVGGraphics2D.domTreeManager;
        this.domGroupManager = new DOMGroupManager(this.gc, this.domTreeManager);
        this.domTreeManager.addGroupManager(this.domGroupManager);
    }

    public void stream(String string) {
        this.stream(string, false);
    }

    public void stream(String string, boolean bl2) {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(string), DEFAULT_XML_ENCODING);
            this.stream(outputStreamWriter, bl2);
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (SVGGraphics2DIOException sVGGraphics2DIOException) {
            throw sVGGraphics2DIOException;
        }
        catch (IOException iOException) {
            this.generatorCtx.errorHandler.handleError(new SVGGraphics2DIOException(iOException));
        }
    }

    public void stream(Writer writer) {
        this.stream(writer, false);
    }

    public void stream(Writer writer, boolean bl2, boolean bl3) {
        Element element = this.getRoot();
        this.stream(element, writer, bl2, bl3);
    }

    public void stream(Writer writer, boolean bl2) {
        Element element = this.getRoot();
        this.stream(element, writer, bl2, false);
    }

    public void stream(Element element, Writer writer) {
        this.stream(element, writer, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stream(Element element, Writer writer, boolean bl2, boolean bl3) {
        Node node = element.getParentNode();
        Node node2 = element.getNextSibling();
        try {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/svg");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xlink", "http://www.w3.org/1999/xlink");
            DocumentFragment documentFragment = element.getOwnerDocument().createDocumentFragment();
            documentFragment.appendChild(element);
            if (bl2) {
                SVGCSSStyler.style(documentFragment);
            }
            XmlWriter.writeXml(documentFragment, writer, bl3);
            writer.flush();
        }
        catch (SVGGraphics2DIOException sVGGraphics2DIOException) {
            this.generatorCtx.errorHandler.handleError(sVGGraphics2DIOException);
        }
        catch (IOException iOException) {
            this.generatorCtx.errorHandler.handleError(new SVGGraphics2DIOException(iOException));
        }
        finally {
            if (node != null) {
                if (node2 == null) {
                    node.appendChild(element);
                } else {
                    node.insertBefore(element, node2);
                }
            }
        }
    }

    public List getDefinitionSet() {
        return this.domTreeManager.getDefinitionSet();
    }

    public Element getTopLevelGroup() {
        return this.getTopLevelGroup(true);
    }

    public Element getTopLevelGroup(boolean bl2) {
        return this.domTreeManager.getTopLevelGroup(bl2);
    }

    public void setTopLevelGroup(Element element) {
        this.domTreeManager.setTopLevelGroup(element);
    }

    public Element getRoot() {
        return this.getRoot(null);
    }

    public Element getRoot(Element element) {
        element = this.domTreeManager.getRoot(element);
        if (this.svgCanvasSize != null) {
            element.setAttributeNS(null, "width", String.valueOf(this.svgCanvasSize.width));
            element.setAttributeNS(null, "height", String.valueOf(this.svgCanvasSize.height));
        }
        return element;
    }

    @Override
    public Graphics create() {
        return new SVGGraphics2D(this);
    }

    @Override
    public void setXORMode(Color color) {
        this.generatorCtx.errorHandler.handleError(new SVGGraphics2DRuntimeException("XOR Mode is not supported by Graphics2D SVG Generator"));
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return this.fmg.getFontMetrics(font);
    }

    @Override
    public void copyArea(int n2, int n3, int n4, int n5, int n6, int n7) {
    }

    @Override
    public boolean drawImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        Element element = this.getGenericImageHandler().createElement(this.getGeneratorContext());
        AffineTransform affineTransform = this.getGenericImageHandler().handleImage(image, element, n2, n3, image.getWidth(null), image.getHeight(null), this.getGeneratorContext());
        if (affineTransform == null) {
            this.domGroupManager.addElement(element);
        } else {
            AffineTransform affineTransform2 = null;
            try {
                affineTransform2 = affineTransform.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new SVGGraphics2DRuntimeException("unexpected exception");
            }
            this.gc.transform(affineTransform);
            this.domGroupManager.addElement(element);
            this.gc.transform(affineTransform2);
        }
        return true;
    }

    @Override
    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, ImageObserver imageObserver) {
        Element element = this.getGenericImageHandler().createElement(this.getGeneratorContext());
        AffineTransform affineTransform = this.getGenericImageHandler().handleImage(image, element, n2, n3, n4, n5, this.getGeneratorContext());
        if (affineTransform == null) {
            this.domGroupManager.addElement(element);
        } else {
            AffineTransform affineTransform2 = null;
            try {
                affineTransform2 = affineTransform.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new SVGGraphics2DRuntimeException("unexpected exception");
            }
            this.gc.transform(affineTransform);
            this.domGroupManager.addElement(element);
            this.gc.transform(affineTransform2);
        }
        return true;
    }

    @Override
    public void dispose() {
        this.domTreeManager.removeGroupManager(this.domGroupManager);
    }

    @Override
    public void draw(Shape shape) {
        Stroke stroke = this.gc.getStroke();
        if (stroke instanceof BasicStroke) {
            Element element = this.shapeConverter.toSVG(shape);
            if (element != null) {
                this.domGroupManager.addElement(element, (short)1);
            }
        } else {
            Shape shape2 = stroke.createStrokedShape(shape);
            this.fill(shape2);
        }
    }

    @Override
    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        boolean bl2 = true;
        if (affineTransform == null) {
            bl2 = this.drawImage(image, 0, 0, null);
        } else if (affineTransform.getDeterminant() != 0.0) {
            AffineTransform affineTransform2 = null;
            try {
                affineTransform2 = affineTransform.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new SVGGraphics2DRuntimeException("unexpected exception");
            }
            this.gc.transform(affineTransform);
            bl2 = this.drawImage(image, 0, 0, null);
            this.gc.transform(affineTransform2);
        } else {
            AffineTransform affineTransform3 = new AffineTransform(this.gc.getTransform());
            this.gc.transform(affineTransform);
            bl2 = this.drawImage(image, 0, 0, null);
            this.gc.setTransform(affineTransform3);
        }
        return bl2;
    }

    @Override
    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n2, int n3) {
        bufferedImage = bufferedImageOp.filter(bufferedImage, null);
        this.drawImage((Image)bufferedImage, n2, n3, null);
    }

    @Override
    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        AffineTransform affineTransform2;
        Element element = this.getGenericImageHandler().createElement(this.getGeneratorContext());
        AffineTransform affineTransform3 = this.getGenericImageHandler().handleImage(renderedImage, element, renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight(), this.getGeneratorContext());
        if (affineTransform == null) {
            affineTransform2 = affineTransform3;
        } else if (affineTransform3 == null) {
            affineTransform2 = affineTransform;
        } else {
            affineTransform2 = new AffineTransform(affineTransform);
            affineTransform2.concatenate(affineTransform3);
        }
        if (affineTransform2 == null) {
            this.domGroupManager.addElement(element);
        } else if (affineTransform2.getDeterminant() != 0.0) {
            AffineTransform affineTransform4 = null;
            try {
                affineTransform4 = affineTransform2.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new SVGGraphics2DRuntimeException("unexpected exception");
            }
            this.gc.transform(affineTransform2);
            this.domGroupManager.addElement(element);
            this.gc.transform(affineTransform4);
        } else {
            AffineTransform affineTransform5 = new AffineTransform(this.gc.getTransform());
            this.gc.transform(affineTransform2);
            this.domGroupManager.addElement(element);
            this.gc.setTransform(affineTransform5);
        }
    }

    @Override
    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        AffineTransform affineTransform2;
        Element element = this.getGenericImageHandler().createElement(this.getGeneratorContext());
        AffineTransform affineTransform3 = this.getGenericImageHandler().handleImage(renderableImage, element, renderableImage.getMinX(), renderableImage.getMinY(), renderableImage.getWidth(), renderableImage.getHeight(), this.getGeneratorContext());
        if (affineTransform == null) {
            affineTransform2 = affineTransform3;
        } else if (affineTransform3 == null) {
            affineTransform2 = affineTransform;
        } else {
            affineTransform2 = new AffineTransform(affineTransform);
            affineTransform2.concatenate(affineTransform3);
        }
        if (affineTransform2 == null) {
            this.domGroupManager.addElement(element);
        } else if (affineTransform2.getDeterminant() != 0.0) {
            AffineTransform affineTransform4 = null;
            try {
                affineTransform4 = affineTransform2.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new SVGGraphics2DRuntimeException("unexpected exception");
            }
            this.gc.transform(affineTransform2);
            this.domGroupManager.addElement(element);
            this.gc.transform(affineTransform4);
        } else {
            AffineTransform affineTransform5 = new AffineTransform(this.gc.getTransform());
            this.gc.transform(affineTransform2);
            this.domGroupManager.addElement(element);
            this.gc.setTransform(affineTransform5);
        }
    }

    @Override
    public void drawString(String string, float f2, float f3) {
        if (this.textAsShapes) {
            GlyphVector glyphVector = this.getFont().createGlyphVector(this.getFontRenderContext(), string);
            this.drawGlyphVector(glyphVector, f2, f3);
            return;
        }
        if (this.generatorCtx.svgFont) {
            this.domTreeManager.gcConverter.getFontConverter().recordFontUsage(string, this.getFont());
        }
        AffineTransform affineTransform = this.getTransform();
        AffineTransform affineTransform2 = this.transformText(f2, f3);
        Element element = this.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "text");
        element.setAttributeNS(null, "x", this.generatorCtx.doubleString(f2));
        element.setAttributeNS(null, "y", this.generatorCtx.doubleString(f3));
        element.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", "preserve");
        element.appendChild(this.getDOMFactory().createTextNode(string));
        this.domGroupManager.addElement(element, (short)16);
        if (affineTransform2 != null) {
            this.setTransform(affineTransform);
        }
    }

    private AffineTransform transformText(float f2, float f3) {
        AffineTransform affineTransform = null;
        Font font = this.getFont();
        if (font != null) {
            affineTransform = font.getTransform();
            if (affineTransform != null && !affineTransform.isIdentity()) {
                AffineTransform affineTransform2 = new AffineTransform();
                affineTransform2.translate(f2, f3);
                affineTransform2.concatenate(affineTransform);
                affineTransform2.translate(-f2, -f3);
                this.transform(affineTransform2);
            } else {
                affineTransform = null;
            }
        }
        return affineTransform;
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f2, float f3) {
        if (this.textAsShapes || this.usesUnsupportedAttributes(attributedCharacterIterator)) {
            TextLayout textLayout = new TextLayout(attributedCharacterIterator, this.getFontRenderContext());
            textLayout.draw(this, f2, f3);
            return;
        }
        boolean bl2 = false;
        if (attributedCharacterIterator.getRunLimit() < attributedCharacterIterator.getEndIndex()) {
            bl2 = true;
        }
        Element element = this.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "text");
        element.setAttributeNS(null, "x", this.generatorCtx.doubleString(f2));
        element.setAttributeNS(null, "y", this.generatorCtx.doubleString(f3));
        element.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", "preserve");
        Font font = this.getFont();
        Paint paint = this.getPaint();
        char c2 = attributedCharacterIterator.first();
        this.setTextElementFill(attributedCharacterIterator);
        this.setTextFontAttributes(attributedCharacterIterator, font);
        SVGGraphicContext sVGGraphicContext = this.domTreeManager.getGraphicContextConverter().toSVG(this.gc);
        this.domGroupManager.addElement(element, (short)16);
        sVGGraphicContext.getContext().put("stroke", "none");
        sVGGraphicContext.getGroupContext().put("stroke", "none");
        boolean bl3 = true;
        AffineTransform affineTransform = this.getTransform();
        AffineTransform affineTransform2 = null;
        while (c2 != '\uffff') {
            Element element2 = element;
            if (bl2) {
                element2 = this.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "tspan");
                element.appendChild(element2);
            }
            this.setTextElementFill(attributedCharacterIterator);
            boolean bl4 = this.setTextFontAttributes(attributedCharacterIterator, font);
            if (bl4 || bl3) {
                affineTransform2 = this.transformText(f2, f3);
                bl3 = false;
            }
            int n2 = attributedCharacterIterator.getIndex();
            int n3 = attributedCharacterIterator.getRunLimit() - 1;
            StringBuffer stringBuffer = new StringBuffer(n3 - n2);
            stringBuffer.append(c2);
            for (int i2 = n2; i2 < n3; ++i2) {
                c2 = attributedCharacterIterator.next();
                stringBuffer.append(c2);
            }
            String string = stringBuffer.toString();
            if (this.generatorCtx.isEmbeddedFontsOn()) {
                this.getDOMTreeManager().getGraphicContextConverter().getFontConverter().recordFontUsage(string, this.getFont());
            }
            SVGGraphicContext sVGGraphicContext2 = this.domTreeManager.gcConverter.toSVG(this.gc);
            sVGGraphicContext2.getGroupContext().put("stroke", "none");
            SVGGraphicContext sVGGraphicContext3 = DOMGroupManager.processDeltaGC(sVGGraphicContext2, sVGGraphicContext);
            this.setTextElementAttributes(sVGGraphicContext3, attributedCharacterIterator);
            this.domTreeManager.getStyleHandler().setStyle(element2, sVGGraphicContext3.getContext(), this.domTreeManager.getGeneratorContext());
            element2.appendChild(this.getDOMFactory().createTextNode(string));
            if ((bl4 || bl3) && affineTransform2 != null) {
                this.setTransform(affineTransform);
            }
            c2 = attributedCharacterIterator.next();
        }
        this.setFont(font);
        this.setPaint(paint);
    }

    @Override
    public void fill(Shape shape) {
        Element element = this.shapeConverter.toSVG(shape);
        if (element != null) {
            this.domGroupManager.addElement(element, (short)16);
        }
    }

    private boolean setTextFontAttributes(AttributedCharacterIterator attributedCharacterIterator, Font font) {
        boolean bl2 = false;
        if (attributedCharacterIterator.getAttribute(TextAttribute.FONT) != null || attributedCharacterIterator.getAttribute(TextAttribute.FAMILY) != null || attributedCharacterIterator.getAttribute(TextAttribute.WEIGHT) != null || attributedCharacterIterator.getAttribute(TextAttribute.POSTURE) != null || attributedCharacterIterator.getAttribute(TextAttribute.SIZE) != null) {
            Map<AttributedCharacterIterator.Attribute, Object> map = attributedCharacterIterator.getAttributes();
            Font font2 = font.deriveFont(map);
            this.setFont(font2);
            bl2 = true;
        }
        return bl2;
    }

    private void setTextElementFill(AttributedCharacterIterator attributedCharacterIterator) {
        if (attributedCharacterIterator.getAttribute(TextAttribute.FOREGROUND) != null) {
            Color color = (Color)attributedCharacterIterator.getAttribute(TextAttribute.FOREGROUND);
            this.setPaint(color);
        }
    }

    private void setTextElementAttributes(SVGGraphicContext sVGGraphicContext, AttributedCharacterIterator attributedCharacterIterator) {
        int n2;
        String string = "";
        if (this.isUnderline(attributedCharacterIterator)) {
            string = string + "underline ";
        }
        if (this.isStrikeThrough(attributedCharacterIterator)) {
            string = string + "line-through ";
        }
        if ((n2 = string.length()) != 0) {
            sVGGraphicContext.getContext().put("text-decoration", string.substring(0, n2 - 1));
        }
    }

    private boolean isBold(AttributedCharacterIterator attributedCharacterIterator) {
        Object object = attributedCharacterIterator.getAttribute(TextAttribute.WEIGHT);
        if (object == null) {
            return false;
        }
        if (object.equals(TextAttribute.WEIGHT_REGULAR)) {
            return false;
        }
        if (object.equals(TextAttribute.WEIGHT_DEMILIGHT)) {
            return false;
        }
        if (object.equals(TextAttribute.WEIGHT_EXTRA_LIGHT)) {
            return false;
        }
        return !object.equals(TextAttribute.WEIGHT_LIGHT);
    }

    private boolean isItalic(AttributedCharacterIterator attributedCharacterIterator) {
        Object object = attributedCharacterIterator.getAttribute(TextAttribute.POSTURE);
        return TextAttribute.POSTURE_OBLIQUE.equals(object);
    }

    private boolean isUnderline(AttributedCharacterIterator attributedCharacterIterator) {
        Object object = attributedCharacterIterator.getAttribute(TextAttribute.UNDERLINE);
        return TextAttribute.UNDERLINE_ON.equals(object);
    }

    private boolean isStrikeThrough(AttributedCharacterIterator attributedCharacterIterator) {
        Object object = attributedCharacterIterator.getAttribute(TextAttribute.STRIKETHROUGH);
        return TextAttribute.STRIKETHROUGH_ON.equals(object);
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return null;
    }

    public void setUnsupportedAttributes(Set set) {
        this.unsupportedAttributes = set == null ? null : new HashSet(set);
    }

    public boolean usesUnsupportedAttributes(AttributedCharacterIterator attributedCharacterIterator) {
        if (this.unsupportedAttributes == null) {
            return false;
        }
        Set<AttributedCharacterIterator.Attribute> set = attributedCharacterIterator.getAllAttributeKeys();
        for (AttributedCharacterIterator.Attribute attribute : set) {
            if (!this.unsupportedAttributes.contains(attribute)) continue;
            return true;
        }
        return false;
    }
}

