/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.batik.ext.awt.g2d.TransformStackElement;
import org.apache.batik.svggen.SVGBasicStroke;
import org.apache.batik.svggen.SVGClip;
import org.apache.batik.svggen.SVGComposite;
import org.apache.batik.svggen.SVGConverter;
import org.apache.batik.svggen.SVGDescriptor;
import org.apache.batik.svggen.SVGFont;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphicContext;
import org.apache.batik.svggen.SVGGraphics2DRuntimeException;
import org.apache.batik.svggen.SVGPaint;
import org.apache.batik.svggen.SVGRenderingHints;
import org.apache.batik.svggen.SVGTransform;

public class SVGGraphicContextConverter {
    private static final int GRAPHIC_CONTEXT_CONVERTER_COUNT = 6;
    private SVGTransform transformConverter;
    private SVGPaint paintConverter;
    private SVGBasicStroke strokeConverter;
    private SVGComposite compositeConverter;
    private SVGClip clipConverter;
    private SVGRenderingHints hintsConverter;
    private SVGFont fontConverter;
    private SVGConverter[] converters = new SVGConverter[6];

    public SVGTransform getTransformConverter() {
        return this.transformConverter;
    }

    public SVGPaint getPaintConverter() {
        return this.paintConverter;
    }

    public SVGBasicStroke getStrokeConverter() {
        return this.strokeConverter;
    }

    public SVGComposite getCompositeConverter() {
        return this.compositeConverter;
    }

    public SVGClip getClipConverter() {
        return this.clipConverter;
    }

    public SVGRenderingHints getHintsConverter() {
        return this.hintsConverter;
    }

    public SVGFont getFontConverter() {
        return this.fontConverter;
    }

    public SVGGraphicContextConverter(SVGGeneratorContext sVGGeneratorContext) {
        if (sVGGeneratorContext == null) {
            throw new SVGGraphics2DRuntimeException("generatorContext should not be null");
        }
        this.transformConverter = new SVGTransform(sVGGeneratorContext);
        this.paintConverter = new SVGPaint(sVGGeneratorContext);
        this.strokeConverter = new SVGBasicStroke(sVGGeneratorContext);
        this.compositeConverter = new SVGComposite(sVGGeneratorContext);
        this.clipConverter = new SVGClip(sVGGeneratorContext);
        this.hintsConverter = new SVGRenderingHints(sVGGeneratorContext);
        this.fontConverter = new SVGFont(sVGGeneratorContext);
        int n2 = 0;
        this.converters[n2++] = this.paintConverter;
        this.converters[n2++] = this.strokeConverter;
        this.converters[n2++] = this.compositeConverter;
        this.converters[n2++] = this.clipConverter;
        this.converters[n2++] = this.hintsConverter;
        this.converters[n2++] = this.fontConverter;
    }

    public String toSVG(TransformStackElement[] transformStackElementArray) {
        return this.transformConverter.toSVGTransform(transformStackElementArray);
    }

    public SVGGraphicContext toSVG(GraphicContext graphicContext) {
        HashMap hashMap = new HashMap();
        for (SVGConverter sVGConverter : this.converters) {
            SVGDescriptor sVGDescriptor = sVGConverter.toSVG(graphicContext);
            if (sVGDescriptor == null) continue;
            sVGDescriptor.getAttributeMap(hashMap);
        }
        return new SVGGraphicContext(hashMap, graphicContext.getTransformStack());
    }

    public List getDefinitionSet() {
        LinkedList linkedList = new LinkedList();
        for (SVGConverter sVGConverter : this.converters) {
            linkedList.addAll(sVGConverter.getDefinitionSet());
        }
        return linkedList;
    }
}

