/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Color;
import java.awt.Paint;
import java.util.HashMap;
import java.util.Map;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.batik.svggen.AbstractSVGConverter;
import org.apache.batik.svggen.SVGDescriptor;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGPaintDescriptor;

public class SVGColor
extends AbstractSVGConverter {
    public static final Color aqua = Color.cyan;
    public static final Color black = Color.black;
    public static final Color blue = Color.blue;
    public static final Color fuchsia = Color.magenta;
    public static final Color gray = Color.gray;
    public static final Color green = new Color(0, 128, 0);
    public static final Color lime = Color.green;
    public static final Color maroon = new Color(128, 0, 0);
    public static final Color navy = new Color(0, 0, 128);
    public static final Color olive = new Color(128, 128, 0);
    public static final Color purple = new Color(128, 0, 128);
    public static final Color red = Color.red;
    public static final Color silver = new Color(192, 192, 192);
    public static final Color teal = new Color(0, 128, 128);
    public static final Color white = Color.white;
    public static final Color yellow = Color.yellow;
    private static Map colorMap = new HashMap();

    public SVGColor(SVGGeneratorContext sVGGeneratorContext) {
        super(sVGGeneratorContext);
    }

    @Override
    public SVGDescriptor toSVG(GraphicContext graphicContext) {
        Paint paint = graphicContext.getPaint();
        return SVGColor.toSVG((Color)paint, this.generatorContext);
    }

    public static SVGPaintDescriptor toSVG(Color color, SVGGeneratorContext sVGGeneratorContext) {
        String string = (String)colorMap.get(color);
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer("rgb(");
            stringBuffer.append(color.getRed());
            stringBuffer.append(",");
            stringBuffer.append(color.getGreen());
            stringBuffer.append(",");
            stringBuffer.append(color.getBlue());
            stringBuffer.append(")");
            string = stringBuffer.toString();
        }
        float f2 = (float)color.getAlpha() / 255.0f;
        String string2 = sVGGeneratorContext.doubleString(f2);
        return new SVGPaintDescriptor(string, string2);
    }

    static {
        colorMap.put(black, "black");
        colorMap.put(silver, "silver");
        colorMap.put(gray, "gray");
        colorMap.put(white, "white");
        colorMap.put(maroon, "maroon");
        colorMap.put(red, "red");
        colorMap.put(purple, "purple");
        colorMap.put(fuchsia, "fuchsia");
        colorMap.put(green, "green");
        colorMap.put(lime, "lime");
        colorMap.put(olive, "olive");
        colorMap.put(yellow, "yellow");
        colorMap.put(navy, "navy");
        colorMap.put(blue, "blue");
        colorMap.put(teal, "teal");
        colorMap.put(aqua, "aqua");
    }
}

